#  This file is part of the KDE project.
#
#  Copyright (C) 2012 ivan <ivan.cukic@kde.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

activitySwitchEffect =
    duration: animationTime(250)


effects.currentActivityChanged.connect (activity) ->
    effects.stackingOrder.map (client) ->
        activities = client.activities

        if (activity in activities && client.visible)

            animate(
                window: client
                animations: [
                    type:     Effect.Opacity
                    duration: activitySwitchEffect.duration
                    from:     0
                    to:       1
                ]
            )

            animate(
                window: client
                animations: [
                    type:     Effect.Scale
                    duration: activitySwitchEffect.duration
                    curve:    QEasingCurve.OutCubic
                    from:     0
                ]
            )

