/*
 * Decompiled with CFR 0.152.
 */
package su.litvak.chromecast.api.v2;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceListener;
import su.litvak.chromecast.api.v2.ChromeCast;
import su.litvak.chromecast.api.v2.ChromeCastsListener;

public final class ChromeCasts {
    private static final ChromeCasts INSTANCE = new ChromeCasts();
    private final MyServiceListener listener = new MyServiceListener();
    private JmDNS mDNS;
    private final List<ChromeCastsListener> listeners = new ArrayList<ChromeCastsListener>();
    private final List<ChromeCast> chromeCasts = Collections.synchronizedList(new ArrayList());

    private ChromeCasts() {
    }

    public static List<ChromeCast> get() {
        return new ArrayList<ChromeCast>(ChromeCasts.INSTANCE.chromeCasts);
    }

    private void doStartDiscovery(InetAddress addr) throws IOException {
        if (this.mDNS == null) {
            this.chromeCasts.clear();
            this.mDNS = addr != null ? JmDNS.create(addr) : JmDNS.create();
            this.mDNS.addServiceListener("_googlecast._tcp.local.", this.listener);
        }
    }

    private void doStopDiscovery() throws IOException {
        if (this.mDNS != null) {
            this.mDNS.close();
            this.mDNS = null;
        }
    }

    public static void startDiscovery() throws IOException {
        INSTANCE.doStartDiscovery(null);
    }

    public static void startDiscovery(InetAddress addr) throws IOException {
        INSTANCE.doStartDiscovery(addr);
    }

    public static void stopDiscovery() throws IOException {
        INSTANCE.doStopDiscovery();
    }

    public static void restartDiscovery() throws IOException {
        ChromeCasts.stopDiscovery();
        ChromeCasts.startDiscovery();
    }

    public static void restartDiscovery(InetAddress addr) throws IOException {
        ChromeCasts.stopDiscovery();
        ChromeCasts.startDiscovery(addr);
    }

    public static void registerListener(ChromeCastsListener listener) {
        if (listener != null) {
            ChromeCasts.INSTANCE.listeners.add(listener);
        }
    }

    public static void unregisterListener(ChromeCastsListener listener) {
        if (listener != null) {
            ChromeCasts.INSTANCE.listeners.remove(listener);
        }
    }

    private class MyServiceListener
    implements ServiceListener {
        private MyServiceListener() {
        }

        @Override
        public void serviceAdded(ServiceEvent se) {
            if (se.getInfo() != null) {
                ChromeCast device = new ChromeCast(ChromeCasts.this.mDNS, se.getInfo().getName());
                ChromeCasts.this.chromeCasts.add(device);
                for (ChromeCastsListener nextListener : ChromeCasts.this.listeners) {
                    nextListener.newChromeCastDiscovered(device);
                }
            }
        }

        @Override
        public void serviceRemoved(ServiceEvent se) {
            if ("_googlecast._tcp.local.".equals(se.getType())) {
                List<ChromeCast> copy = ChromeCasts.get();
                ChromeCast deviceRemoved = null;
                for (ChromeCast device : copy) {
                    if (!device.getName().equals(se.getInfo().getName())) continue;
                    deviceRemoved = device;
                    ChromeCasts.this.chromeCasts.remove(device);
                    break;
                }
                if (deviceRemoved != null) {
                    for (ChromeCastsListener nextListener : ChromeCasts.this.listeners) {
                        nextListener.chromeCastRemoved(deviceRemoved);
                    }
                }
            }
        }

        @Override
        public void serviceResolved(ServiceEvent se) {
        }
    }
}

