/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.registry;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.os.ApplicationInfo;
import oshi.util.ParseUtil;

public final class InstalledAppsData {
    private static final Logger LOG = LoggerFactory.getLogger(InstalledAppsData.class);
    private static final Map<WinReg.HKEY, List<String>> REGISTRY_PATHS = new HashMap<WinReg.HKEY, List<String>>();
    private static final int[] ACCESS_FLAGS = new int[]{256, 512};

    private InstalledAppsData() {
    }

    public static List<ApplicationInfo> queryInstalledApps() {
        LinkedHashSet<ApplicationInfo> appInfoSet = new LinkedHashSet<ApplicationInfo>();
        for (Map.Entry<WinReg.HKEY, List<String>> entry : REGISTRY_PATHS.entrySet()) {
            WinReg.HKEY rootKey = entry.getKey();
            List<String> uninstallPaths = entry.getValue();
            for (String registryPath : uninstallPaths) {
                for (int accessFlag : ACCESS_FLAGS) {
                    String[] keys;
                    for (String key : keys = Advapi32Util.registryGetKeys(rootKey, registryPath, accessFlag)) {
                        String fullPath = registryPath + "\\" + key;
                        try {
                            String name = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "DisplayName", accessFlag);
                            if (name == null) continue;
                            String version = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "DisplayVersion", accessFlag);
                            String publisher = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "Publisher", accessFlag);
                            String installDate = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "InstallDate", accessFlag);
                            String installLocation = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "InstallLocation", accessFlag);
                            String installSource = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "InstallSource", accessFlag);
                            long installDateEpoch = ParseUtil.parseDateToEpoch(installDate, "yyyyMMdd");
                            LinkedHashMap<String, String> additionalInfo = new LinkedHashMap<String, String>();
                            additionalInfo.put("installLocation", installLocation);
                            additionalInfo.put("installSource", installSource);
                            ApplicationInfo app = new ApplicationInfo(name, version, publisher, installDateEpoch, additionalInfo);
                            appInfoSet.add(app);
                        }
                        catch (Win32Exception win32Exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return new ArrayList<ApplicationInfo>(appInfoSet);
    }

    private static String getRegistryValueOrUnknown(WinReg.HKEY rootKey, String path, String key, int accessFlag) {
        try {
            String value = Advapi32Util.registryGetStringValue(rootKey, path, key, accessFlag);
            if (value != null && !value.trim().isEmpty()) {
                return value;
            }
        }
        catch (Win32Exception e) {
            LOG.trace("Unable to access " + path + " with flag " + accessFlag + ": " + e.getMessage());
        }
        return null;
    }

    static {
        REGISTRY_PATHS.put(WinReg.HKEY_LOCAL_MACHINE, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", "SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
        REGISTRY_PATHS.put(WinReg.HKEY_CURRENT_USER, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
    }
}

