/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.cal10n;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageParameterObj;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.ext.LoggerWrapper;
import org.slf4j.spi.LocationAwareLogger;

public class LocLogger
extends LoggerWrapper
implements Logger {
    private static final String FQCN = LocLogger.class.getName();
    static Marker LOCALIZED = MarkerFactory.getMarker("LOCALIZED");
    final IMessageConveyor imc;

    public LocLogger(Logger logger, IMessageConveyor imc) {
        super(logger, LoggerWrapper.class.getName());
        if (imc == null) {
            throw new IllegalArgumentException("IMessageConveyor cannot be null");
        }
        this.imc = imc;
    }

    public void trace(Enum<?> key, Object ... args) {
        if (!this.logger.isTraceEnabled()) {
            return;
        }
        String translatedMsg = this.imc.getMessage(key, args);
        MessageParameterObj mpo = new MessageParameterObj(key, args);
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(LOCALIZED, FQCN, 0, translatedMsg, args, null);
        } else {
            this.logger.trace(LOCALIZED, translatedMsg, (Object)mpo);
        }
    }

    public void debug(Enum<?> key, Object ... args) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        String translatedMsg = this.imc.getMessage(key, args);
        MessageParameterObj mpo = new MessageParameterObj(key, args);
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(LOCALIZED, FQCN, 10, translatedMsg, args, null);
        } else {
            this.logger.debug(LOCALIZED, translatedMsg, (Object)mpo);
        }
    }

    public void info(Enum<?> key, Object ... args) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        String translatedMsg = this.imc.getMessage(key, args);
        MessageParameterObj mpo = new MessageParameterObj(key, args);
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(LOCALIZED, FQCN, 20, translatedMsg, args, null);
        } else {
            this.logger.info(LOCALIZED, translatedMsg, (Object)mpo);
        }
    }

    public void warn(Enum<?> key, Object ... args) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        String translatedMsg = this.imc.getMessage(key, args);
        MessageParameterObj mpo = new MessageParameterObj(key, args);
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(LOCALIZED, FQCN, 30, translatedMsg, args, null);
        } else {
            this.logger.warn(LOCALIZED, translatedMsg, (Object)mpo);
        }
    }

    public void error(Enum<?> key, Object ... args) {
        if (!this.logger.isErrorEnabled()) {
            return;
        }
        String translatedMsg = this.imc.getMessage(key, args);
        MessageParameterObj mpo = new MessageParameterObj(key, args);
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(LOCALIZED, FQCN, 40, translatedMsg, args, null);
        } else {
            this.logger.error(LOCALIZED, translatedMsg, (Object)mpo);
        }
    }
}

