/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.XMLUtil;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.control.ActionMessage;
import org.jupnp.model.message.control.ActionRequestMessage;
import org.jupnp.model.message.control.ActionResponseMessage;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.transport.impl.PooledXmlProcessor;
import org.jupnp.transport.spi.SOAPActionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SOAPActionProcessorImpl
extends PooledXmlProcessor
implements SOAPActionProcessor,
ErrorHandler {
    private final Logger logger = LoggerFactory.getLogger(SOAPActionProcessor.class);

    @Override
    public void writeBody(ActionRequestMessage requestMessage, ActionInvocation actionInvocation) throws UnsupportedDataException {
        this.logger.trace("Writing body of {} for: {}", (Object)requestMessage, (Object)actionInvocation);
        try {
            Document d = this.newDocument();
            Element body = this.writeBodyElement(d);
            this.writeBodyRequest(d, body, requestMessage, actionInvocation);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("===================================== SOAP BODY BEGIN ============================================");
                this.logger.trace(requestMessage.getBodyString());
                this.logger.trace("-===================================== SOAP BODY END ============================================");
            }
        }
        catch (Exception e) {
            throw new UnsupportedDataException("Can't transform message payload", e);
        }
    }

    @Override
    public void writeBody(ActionResponseMessage responseMessage, ActionInvocation actionInvocation) throws UnsupportedDataException {
        this.logger.trace("Writing body of {} for: {}", (Object)responseMessage, (Object)actionInvocation);
        try {
            Document d = this.newDocument();
            Element body = this.writeBodyElement(d);
            if (actionInvocation.getFailure() != null) {
                this.writeBodyFailure(d, body, responseMessage, actionInvocation);
            } else {
                this.writeBodyResponse(d, body, responseMessage, actionInvocation);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("===================================== SOAP BODY BEGIN ============================================");
                this.logger.trace(responseMessage.getBodyString());
                this.logger.trace("-===================================== SOAP BODY END ============================================");
            }
        }
        catch (Exception e) {
            throw new UnsupportedDataException("Can't transform message payload", e);
        }
    }

    @Override
    public void readBody(ActionRequestMessage requestMessage, ActionInvocation actionInvocation) throws UnsupportedDataException {
        this.logger.trace("Reading body of {} for: {}", (Object)requestMessage, (Object)actionInvocation);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("===================================== SOAP BODY BEGIN ============================================");
            this.logger.trace(requestMessage.getBodyString());
            this.logger.trace("-===================================== SOAP BODY END ============================================");
        }
        String body = this.getMessageBody(requestMessage);
        try {
            Document d = this.readDocument(new InputSource(new StringReader(body)), this);
            Element bodyElement = this.readBodyElement(d);
            this.readBodyRequest(d, bodyElement, requestMessage, actionInvocation);
        }
        catch (Exception e) {
            throw new UnsupportedDataException("Can't transform message payload", e, body);
        }
    }

    @Override
    public void readBody(ActionResponseMessage responseMsg, ActionInvocation actionInvocation) throws UnsupportedDataException {
        this.logger.trace("Reading body of {} for: {}", (Object)responseMsg, (Object)actionInvocation);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("===================================== SOAP BODY BEGIN ============================================");
            this.logger.trace(responseMsg.getBodyString());
            this.logger.trace("-===================================== SOAP BODY END ============================================");
        }
        String body = this.getMessageBody(responseMsg);
        try {
            Document d = this.readDocument(new InputSource(new StringReader(body)), this);
            Element bodyElement = this.readBodyElement(d);
            ActionException failure = this.readBodyFailure(d, bodyElement);
            if (failure == null) {
                this.readBodyResponse(d, bodyElement, responseMsg, actionInvocation);
            } else {
                actionInvocation.setFailure(failure);
            }
        }
        catch (Exception e) {
            throw new UnsupportedDataException("Can't transform message payload", e, body);
        }
    }

    protected void writeBodyFailure(Document d, Element bodyElement, ActionResponseMessage message, ActionInvocation actionInvocation) throws Exception {
        this.writeFaultElement(d, bodyElement, actionInvocation);
        message.setBody(this.toString(d));
    }

    protected void writeBodyRequest(Document d, Element bodyElement, ActionRequestMessage message, ActionInvocation actionInvocation) throws Exception {
        Element actionRequestElement = this.writeActionRequestElement(d, bodyElement, message, actionInvocation);
        this.writeActionInputArguments(d, actionRequestElement, actionInvocation);
        message.setBody(this.toString(d));
    }

    protected void writeBodyResponse(Document d, Element bodyElement, ActionResponseMessage message, ActionInvocation actionInvocation) throws Exception {
        Element actionResponseElement = this.writeActionResponseElement(d, bodyElement, message, actionInvocation);
        this.writeActionOutputArguments(d, actionResponseElement, actionInvocation);
        message.setBody(this.toString(d));
    }

    protected ActionException readBodyFailure(Document d, Element bodyElement) throws Exception {
        return this.readFaultElement(bodyElement);
    }

    protected void readBodyRequest(Document d, Element bodyElement, ActionRequestMessage message, ActionInvocation actionInvocation) throws Exception {
        Element actionRequestElement = this.readActionRequestElement(bodyElement, message, actionInvocation);
        this.readActionInputArguments(actionRequestElement, actionInvocation);
    }

    protected void readBodyResponse(Document d, Element bodyElement, ActionResponseMessage message, ActionInvocation actionInvocation) throws Exception {
        Element actionResponse = this.readActionResponseElement(bodyElement, actionInvocation);
        this.readActionOutputArguments(actionResponse, actionInvocation);
    }

    protected Element writeBodyElement(Document d) {
        Element envelopeElement = d.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "s:Envelope");
        Attr encodingStyleAttr = d.createAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "s:encodingStyle");
        encodingStyleAttr.setValue("http://schemas.xmlsoap.org/soap/encoding/");
        envelopeElement.setAttributeNode(encodingStyleAttr);
        d.appendChild(envelopeElement);
        Element bodyElement = d.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "s:Body");
        envelopeElement.appendChild(bodyElement);
        return bodyElement;
    }

    protected Element readBodyElement(Document d) {
        Element envelopeElement = d.getDocumentElement();
        if (envelopeElement == null || !this.getUnprefixedNodeName(envelopeElement).equals("Envelope")) {
            throw new RuntimeException("Response root element was not 'Envelope'");
        }
        NodeList envelopeElementChildren = envelopeElement.getChildNodes();
        int i = 0;
        while (i < envelopeElementChildren.getLength()) {
            Node envelopeChild = envelopeElementChildren.item(i);
            if (envelopeChild.getNodeType() == 1 && this.getUnprefixedNodeName(envelopeChild).equals("Body")) {
                return (Element)envelopeChild;
            }
            ++i;
        }
        throw new RuntimeException("Response envelope did not contain 'Body' child element");
    }

    protected Element writeActionRequestElement(Document d, Element bodyElement, ActionRequestMessage message, ActionInvocation actionInvocation) {
        this.logger.trace("Writing action request element: {}", (Object)actionInvocation.getAction().getName());
        Element actionRequestElement = d.createElementNS(message.getActionNamespace(), "u:" + actionInvocation.getAction().getName());
        bodyElement.appendChild(actionRequestElement);
        return actionRequestElement;
    }

    protected Element readActionRequestElement(Element bodyElement, ActionRequestMessage message, ActionInvocation actionInvocation) {
        NodeList bodyChildren = bodyElement.getChildNodes();
        this.logger.trace("Looking for action request element matching namespace: {}", (Object)message.getActionNamespace());
        int i = 0;
        while (i < bodyChildren.getLength()) {
            String unprefixedName;
            Node bodyChild = bodyChildren.item(i);
            if (bodyChild.getNodeType() == 1 && (unprefixedName = this.getUnprefixedNodeName(bodyChild)).equals(actionInvocation.getAction().getName())) {
                if (bodyChild.getNamespaceURI() == null || !bodyChild.getNamespaceURI().equals(message.getActionNamespace())) {
                    throw new UnsupportedDataException("Illegal or missing namespace on action request element: " + String.valueOf(bodyChild));
                }
                this.logger.trace("Reading action request element: {}", (Object)unprefixedName);
                return (Element)bodyChild;
            }
            ++i;
        }
        throw new UnsupportedDataException("Could not read action request element matching namespace: " + message.getActionNamespace());
    }

    protected Element writeActionResponseElement(Document d, Element bodyElement, ActionResponseMessage message, ActionInvocation actionInvocation) {
        this.logger.trace("Writing action response element: {}", (Object)actionInvocation.getAction().getName());
        Element actionResponseElement = d.createElementNS(message.getActionNamespace(), "u:" + actionInvocation.getAction().getName() + "Response");
        bodyElement.appendChild(actionResponseElement);
        return actionResponseElement;
    }

    protected Element readActionResponseElement(Element bodyElement, ActionInvocation actionInvocation) {
        NodeList bodyChildren = bodyElement.getChildNodes();
        int i = 0;
        while (i < bodyChildren.getLength()) {
            Node bodyChild = bodyChildren.item(i);
            if (bodyChild.getNodeType() == 1 && this.getUnprefixedNodeName(bodyChild).equals(actionInvocation.getAction().getName() + "Response")) {
                this.logger.trace("Reading action response element: {}", (Object)this.getUnprefixedNodeName(bodyChild));
                return (Element)bodyChild;
            }
            ++i;
        }
        this.logger.trace("Could not read action response element");
        return null;
    }

    protected void writeActionInputArguments(Document d, Element actionRequestElement, ActionInvocation actionInvocation) {
        ActionArgument<S>[] actionArgumentArray = actionInvocation.getAction().getInputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument argument = actionArgumentArray[n2];
            this.logger.trace("Writing action input argument: {}", (Object)argument.getName());
            String value = actionInvocation.getInput(argument) != null ? actionInvocation.getInput(argument).toString() : "";
            XMLUtil.appendNewElement(d, actionRequestElement, argument.getName(), value);
            ++n2;
        }
    }

    public void readActionInputArguments(Element actionRequestElement, ActionInvocation actionInvocation) throws ActionException {
        actionInvocation.setInput(this.readArgumentValues(actionRequestElement.getChildNodes(), actionInvocation.getAction().getInputArguments()));
    }

    protected void writeActionOutputArguments(Document d, Element actionResponseElement, ActionInvocation actionInvocation) {
        ActionArgument<S>[] actionArgumentArray = actionInvocation.getAction().getOutputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument argument = actionArgumentArray[n2];
            this.logger.trace("Writing action output argument: {}", (Object)argument.getName());
            String value = actionInvocation.getOutput(argument) != null ? actionInvocation.getOutput(argument).toString() : "";
            XMLUtil.appendNewElement(d, actionResponseElement, argument.getName(), value);
            ++n2;
        }
    }

    protected void readActionOutputArguments(Element actionResponseElement, ActionInvocation actionInvocation) throws ActionException {
        actionInvocation.setOutput(this.readArgumentValues(actionResponseElement.getChildNodes(), actionInvocation.getAction().getOutputArguments()));
    }

    protected void writeFaultElement(Document d, Element bodyElement, ActionInvocation actionInvocation) {
        Element faultElement = d.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "s:Fault");
        bodyElement.appendChild(faultElement);
        XMLUtil.appendNewElement(d, faultElement, "faultcode", "s:Client");
        XMLUtil.appendNewElement(d, faultElement, "faultstring", "UPnPError");
        Element detailElement = d.createElement("detail");
        faultElement.appendChild(detailElement);
        Element upnpErrorElement = d.createElementNS("urn:schemas-upnp-org:control-1-0", "UPnPError");
        detailElement.appendChild(upnpErrorElement);
        int errorCode = actionInvocation.getFailure().getErrorCode();
        String errorDescription = actionInvocation.getFailure().getMessage();
        this.logger.trace("Writing fault element: {} - {}", (Object)errorCode, (Object)errorDescription);
        XMLUtil.appendNewElement(d, upnpErrorElement, "errorCode", Integer.toString(errorCode));
        XMLUtil.appendNewElement(d, upnpErrorElement, "errorDescription", errorDescription);
    }

    protected ActionException readFaultElement(Element bodyElement) {
        boolean receivedFaultElement = false;
        String errorCode = null;
        String errorDescription = null;
        NodeList bodyChildren = bodyElement.getChildNodes();
        int i = 0;
        while (i < bodyChildren.getLength()) {
            Node bodyChild = bodyChildren.item(i);
            if (bodyChild.getNodeType() == 1 && this.getUnprefixedNodeName(bodyChild).equals("Fault")) {
                receivedFaultElement = true;
                NodeList faultChildren = bodyChild.getChildNodes();
                int j = 0;
                while (j < faultChildren.getLength()) {
                    Node faultChild = faultChildren.item(j);
                    if (faultChild.getNodeType() == 1 && this.getUnprefixedNodeName(faultChild).equals("detail")) {
                        NodeList detailChildren = faultChild.getChildNodes();
                        int x = 0;
                        while (x < detailChildren.getLength()) {
                            Node detailChild = detailChildren.item(x);
                            if (detailChild.getNodeType() == 1 && this.getUnprefixedNodeName(detailChild).equals("UPnPError")) {
                                NodeList errorChildren = detailChild.getChildNodes();
                                int y = 0;
                                while (y < errorChildren.getLength()) {
                                    Node errorChild = errorChildren.item(y);
                                    if (errorChild.getNodeType() == 1) {
                                        if (this.getUnprefixedNodeName(errorChild).equals("errorCode")) {
                                            errorCode = XMLUtil.getTextContent(errorChild);
                                        }
                                        if (this.getUnprefixedNodeName(errorChild).equals("errorDescription")) {
                                            errorDescription = XMLUtil.getTextContent(errorChild);
                                        }
                                    }
                                    ++y;
                                }
                            }
                            ++x;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (errorCode != null) {
            try {
                int numericCode = Integer.parseInt(errorCode);
                ErrorCode standardErrorCode = ErrorCode.getByCode(numericCode);
                if (standardErrorCode != null) {
                    this.logger.trace("Reading fault element: {} - {}", (Object)standardErrorCode.getCode(), (Object)errorDescription);
                    return new ActionException(standardErrorCode, errorDescription, false);
                }
                this.logger.trace("Reading fault element: {} - {}", (Object)numericCode, (Object)errorDescription);
                return new ActionException(numericCode, errorDescription);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Error code was not a number", e);
            }
        }
        if (receivedFaultElement) {
            throw new RuntimeException("Received fault element but no error code");
        }
        return null;
    }

    protected String getMessageBody(ActionMessage message) throws UnsupportedDataException {
        if (!message.isBodyNonEmptyString()) {
            throw new UnsupportedDataException("Can't transform null or non-string/zero-length body of: " + String.valueOf(message));
        }
        return message.getBodyString().trim();
    }

    protected String toString(Document d) throws Exception {
        String output = XMLUtil.documentToString(d);
        while (output.endsWith("\n") || output.endsWith("\r")) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    protected String getUnprefixedNodeName(Node node) {
        return node.getPrefix() != null ? node.getNodeName().substring(node.getPrefix().length() + 1) : node.getNodeName();
    }

    protected ActionArgumentValue[] readArgumentValues(NodeList nodeList, ActionArgument[] args) throws ActionException {
        List<Node> nodes = this.getMatchingNodes(nodeList, args);
        ActionArgumentValue[] values = new ActionArgumentValue[args.length];
        int i = 0;
        while (i < args.length) {
            ActionArgument arg = args[i];
            Node node = this.findActionArgumentNode(nodes, arg);
            if (node == null) {
                throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Could not find argument '" + arg.getName() + "' node");
            }
            this.logger.trace("Reading action argument: {}", (Object)arg.getName());
            String value = XMLUtil.getTextContent(node);
            values[i] = this.createValue(arg, value);
            ++i;
        }
        return values;
    }

    protected List<Node> getMatchingNodes(NodeList nodeList, ActionArgument[] args) throws ActionException {
        ArrayList<String> names = new ArrayList<String>();
        ActionArgument[] actionArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument argument = actionArgumentArray[n2];
            names.add(argument.getName());
            names.addAll(Arrays.asList(argument.getAliases()));
            ++n2;
        }
        ArrayList<Node> matches = new ArrayList<Node>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            if (child.getNodeType() == 1 && names.contains(this.getUnprefixedNodeName(child))) {
                matches.add(child);
            }
            ++i;
        }
        if (matches.size() < args.length) {
            throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Invalid number of input or output arguments in XML message, expected " + args.length + " but found " + matches.size());
        }
        return matches;
    }

    protected ActionArgumentValue createValue(ActionArgument arg, String value) throws ActionException {
        try {
            return new ActionArgumentValue(arg, (Object)value);
        }
        catch (InvalidValueException e) {
            throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Wrong type or invalid value for '" + arg.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    protected Node findActionArgumentNode(List<Node> nodes, ActionArgument arg) {
        for (Node node : nodes) {
            if (!arg.isNameOrAlias(this.getUnprefixedNodeName(node))) continue;
            return node;
        }
        return null;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.logger.warn(e.toString());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }
}

