/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.message.header;

import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.types.BytesRange;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.support.model.dlna.message.header.DLNAHeader;
import org.jupnp.support.model.dlna.types.NormalPlayTimeRange;
import org.jupnp.support.model.dlna.types.TimeSeekRangeType;

public class TimeSeekRangeHeader
extends DLNAHeader<TimeSeekRangeType> {
    public TimeSeekRangeHeader() {
    }

    public TimeSeekRangeHeader(TimeSeekRangeType timeSeekRange) {
        this.setValue(timeSeekRange);
    }

    @Override
    public void setString(String s) {
        String[] params;
        if (!s.isEmpty() && (params = s.split(" ")).length > 0) {
            try {
                TimeSeekRangeType t = new TimeSeekRangeType(NormalPlayTimeRange.valueOf(params[0]));
                if (params.length > 1) {
                    t.setBytesRange(BytesRange.valueOf(params[1]));
                }
                this.setValue(t);
                return;
            }
            catch (InvalidValueException e) {
                throw new InvalidHeaderException("Invalid TimeSeekRange header value: " + s + "; " + e.getMessage(), e);
            }
        }
        throw new InvalidHeaderException("Invalid TimeSeekRange header value: " + s);
    }

    @Override
    public String getString() {
        TimeSeekRangeType t = (TimeSeekRangeType)this.getValue();
        Object s = t.getNormalPlayTimeRange().getString();
        if (t.getBytesRange() != null) {
            s = (String)s + " " + t.getBytesRange().getString(true);
        }
        return s;
    }
}

