/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.async;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.UpnpService;
import org.jupnp.model.Location;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.message.discovery.OutgoingNotificationRequest;
import org.jupnp.model.message.discovery.OutgoingNotificationRequestDeviceType;
import org.jupnp.model.message.discovery.OutgoingNotificationRequestRootDevice;
import org.jupnp.model.message.discovery.OutgoingNotificationRequestServiceType;
import org.jupnp.model.message.discovery.OutgoingNotificationRequestUDN;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.types.NotificationSubtype;
import org.jupnp.model.types.ServiceType;
import org.jupnp.protocol.SendingAsync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SendingNotification
extends SendingAsync {
    private final Logger logger = LoggerFactory.getLogger(SendingNotification.class);
    private LocalDevice device;

    protected SendingNotification(UpnpService upnpService, LocalDevice device) {
        super(upnpService);
        this.device = device;
    }

    public LocalDevice getDevice() {
        return this.device;
    }

    @Override
    protected void execute() throws RouterException {
        List<NetworkAddress> activeStreamServers = this.getUpnpService().getRouter().getActiveStreamServers(null);
        if (activeStreamServers.isEmpty()) {
            this.logger.trace("Aborting notifications, no active stream servers found (network disabled?)");
            return;
        }
        ArrayList<Location> descriptorLocations = new ArrayList<Location>();
        for (NetworkAddress activeStreamServer : activeStreamServers) {
            descriptorLocations.add(new Location(activeStreamServer, this.getUpnpService().getConfiguration().getNamespace().getDescriptorPathString(this.getDevice())));
        }
        int i = 0;
        while (i < this.getBulkRepeat()) {
            try {
                for (Location descriptorLocation : descriptorLocations) {
                    this.sendMessages(descriptorLocation);
                }
                this.logger.trace("Sleeping {} milliseconds", (Object)this.getBulkIntervalMilliseconds());
                Thread.sleep(this.getBulkIntervalMilliseconds());
            }
            catch (InterruptedException e) {
                this.logger.warn("Advertisement thread was interrupted", e);
            }
            ++i;
        }
    }

    protected int getBulkRepeat() {
        return 3;
    }

    protected int getBulkIntervalMilliseconds() {
        return 150;
    }

    public void sendMessages(Location descriptorLocation) throws RouterException {
        List<OutgoingNotificationRequest> serviceTypeMsgs;
        this.logger.trace("Sending root device messages: {}", (Object)this.getDevice());
        List<OutgoingNotificationRequest> rootDeviceMsgs = this.createDeviceMessages(this.getDevice(), descriptorLocation);
        for (OutgoingNotificationRequest upnpMessage : rootDeviceMsgs) {
            this.getUpnpService().getRouter().send(upnpMessage);
        }
        if (this.getDevice().hasEmbeddedDevices()) {
            LocalDevice[] localDeviceArray = (LocalDevice[])this.getDevice().findEmbeddedDevices();
            int n = localDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                LocalDevice embeddedDevice = localDeviceArray[n2];
                this.logger.trace("Sending embedded device messages: {}", (Object)embeddedDevice);
                List<OutgoingNotificationRequest> embeddedDeviceMsgs = this.createDeviceMessages(embeddedDevice, descriptorLocation);
                for (OutgoingNotificationRequest upnpMessage : embeddedDeviceMsgs) {
                    this.getUpnpService().getRouter().send(upnpMessage);
                }
                ++n2;
            }
        }
        if (!(serviceTypeMsgs = this.createServiceTypeMessages(this.getDevice(), descriptorLocation)).isEmpty()) {
            this.logger.trace("Sending service type messages");
            for (OutgoingNotificationRequest upnpMessage : serviceTypeMsgs) {
                this.getUpnpService().getRouter().send(upnpMessage);
            }
        }
    }

    protected List<OutgoingNotificationRequest> createDeviceMessages(LocalDevice device, Location descriptorLocation) {
        ArrayList<OutgoingNotificationRequest> msgs = new ArrayList<OutgoingNotificationRequest>();
        if (device.isRoot()) {
            msgs.add(new OutgoingNotificationRequestRootDevice(descriptorLocation, device, this.getNotificationSubtype()));
        }
        msgs.add(new OutgoingNotificationRequestUDN(descriptorLocation, device, this.getNotificationSubtype()));
        msgs.add(new OutgoingNotificationRequestDeviceType(descriptorLocation, device, this.getNotificationSubtype()));
        return msgs;
    }

    protected List<OutgoingNotificationRequest> createServiceTypeMessages(LocalDevice device, Location descriptorLocation) {
        ArrayList<OutgoingNotificationRequest> msgs = new ArrayList<OutgoingNotificationRequest>();
        ServiceType[] serviceTypeArray = device.findServiceTypes();
        int n = serviceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceType serviceType = serviceTypeArray[n2];
            msgs.add(new OutgoingNotificationRequestServiceType(descriptorLocation, device, this.getNotificationSubtype(), serviceType));
            ++n2;
        }
        return msgs;
    }

    protected abstract NotificationSubtype getNotificationSubtype();
}

