/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.logging.Level;
import org.jaudiotagger.audio.exceptions.UnableToCreateFileException;
import org.jaudiotagger.audio.exceptions.UnableToModifyFileException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.logging.FileSystemMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.Pair;
import org.jaudiotagger.tag.id3.AbstractID3Tag;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.AggregatedFrame;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v24Frames;
import org.jaudiotagger.tag.id3.TyerTdatAggregatedFrame;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyNumberTotal;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyPairs;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyEncrypted;
import org.jaudiotagger.tag.id3.framebody.FrameBodyIPLS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPOPM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIPL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTMCL;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTXXX;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUFID;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAR;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWXXX;
import org.jaudiotagger.tag.id3.valuepair.ID3NumberTotalFields;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.reference.PictureTypes;
import org.jaudiotagger.utils.ShiftData;

public abstract class AbstractID3v2Tag
extends AbstractID3Tag
implements Tag {
    private Long startLocationInFile = null;
    private Long endLocationInFile = null;
    protected static final String TYPE_HEADER = "header";
    protected static final String TYPE_BODY = "body";
    public static final byte[] TAG_ID = new byte[]{73, 68, 51};
    public static final String TAGID = "ID3";
    public static final int TAG_HEADER_LENGTH = 10;
    public static final int FIELD_TAGID_LENGTH = 3;
    public static final int FIELD_TAG_MAJOR_VERSION_LENGTH = 1;
    public static final int FIELD_TAG_MINOR_VERSION_LENGTH = 1;
    public static final int FIELD_TAG_FLAG_LENGTH = 1;
    public static final int FIELD_TAG_SIZE_LENGTH = 4;
    public static final int FIELD_TAGID_POS = 0;
    public static final int FIELD_TAG_MAJOR_VERSION_POS = 3;
    public static final int FIELD_TAG_MINOR_VERSION_POS = 4;
    public static final int FIELD_TAG_FLAG_POS = 5;
    public static final int FIELD_TAG_SIZE_POS = 6;
    protected static final int TAG_SIZE_INCREMENT = 100;
    protected Map<String, List<TagField>> frameMap = null;
    protected Map<String, List<TagField>> encryptedFrameMap = null;
    protected static final String TYPE_DUPLICATEFRAMEID = "duplicateFrameId";
    protected String duplicateFrameId = "";
    protected static final String TYPE_DUPLICATEBYTES = "duplicateBytes";
    protected int duplicateBytes = 0;
    protected static final String TYPE_EMPTYFRAMEBYTES = "emptyFrameBytes";
    protected int emptyFrameBytes = 0;
    protected static final String TYPE_FILEREADSIZE = "fileReadSize";
    protected int fileReadSize = 0;
    protected static final String TYPE_INVALIDFRAMES = "invalidFrames";
    protected int invalidFrames = 0;

    private static boolean isID3V2Header(RandomAccessFile raf) throws IOException {
        long start = raf.getFilePointer();
        byte[] tagIdentifier = new byte[3];
        raf.read(tagIdentifier);
        raf.seek(start);
        return Arrays.equals(tagIdentifier, TAG_ID);
    }

    private static boolean isID3V2Header(FileChannel fc) throws IOException {
        long start = fc.position();
        ByteBuffer headerBuffer = Utils.readFileDataIntoBufferBE(fc, 3);
        fc.position(start);
        String s = Utils.readThreeBytesAsChars(headerBuffer);
        return s.equals(TAGID);
    }

    public static boolean isId3Tag(RandomAccessFile raf) throws IOException {
        if (!AbstractID3v2Tag.isID3V2Header(raf)) {
            return false;
        }
        byte[] tagHeader = new byte[4];
        raf.seek(raf.getFilePointer() + 3L + 1L + 1L + 1L);
        raf.read(tagHeader);
        ByteBuffer bb = ByteBuffer.wrap(tagHeader);
        int size = ID3SyncSafeInteger.bufferToValue(bb);
        raf.seek(size + 10);
        return true;
    }

    public static boolean isId3Tag(FileChannel fc) throws IOException {
        if (!AbstractID3v2Tag.isID3V2Header(fc)) {
            return false;
        }
        ByteBuffer bb = ByteBuffer.allocateDirect(4);
        fc.position(fc.position() + 3L + 1L + 1L + 1L);
        fc.read(bb);
        bb.flip();
        int size = ID3SyncSafeInteger.bufferToValue(bb);
        fc.position(size + 10);
        return true;
    }

    public AbstractID3v2Tag() {
    }

    protected AbstractID3v2Tag(AbstractID3v2Tag copyObject) {
    }

    protected void copyPrimitives(AbstractID3v2Tag copyObject) {
        logger.config("Copying Primitives");
        this.duplicateFrameId = copyObject.duplicateFrameId;
        this.duplicateBytes = copyObject.duplicateBytes;
        this.emptyFrameBytes = copyObject.emptyFrameBytes;
        this.fileReadSize = copyObject.fileReadSize;
        this.invalidFrames = copyObject.invalidFrames;
    }

    protected void copyFrames(AbstractID3v2Tag copyObject) {
        this.frameMap = new LinkedHashMap<String, List<TagField>>();
        this.encryptedFrameMap = new LinkedHashMap<String, List<TagField>>();
        for (String id : copyObject.frameMap.keySet()) {
            List<TagField> fields = copyObject.frameMap.get(id);
            for (TagField o : fields) {
                if (o instanceof AbstractID3v2Frame) {
                    this.addFrame((AbstractID3v2Frame)o);
                    continue;
                }
                if (!(o instanceof TyerTdatAggregatedFrame)) continue;
                for (AbstractID3v2Frame next : ((TyerTdatAggregatedFrame)o).getFrames()) {
                    this.addFrame(next);
                }
            }
        }
    }

    protected abstract void addFrame(AbstractID3v2Frame var1);

    protected abstract List<AbstractID3v2Frame> convertFrame(AbstractID3v2Frame var1) throws InvalidFrameException;

    public int getDuplicateBytes() {
        return this.duplicateBytes;
    }

    public String getDuplicateFrameId() {
        return this.duplicateFrameId;
    }

    public int getEmptyFrameBytes() {
        return this.emptyFrameBytes;
    }

    public int getInvalidFrames() {
        return this.invalidFrames;
    }

    public int getFileReadBytes() {
        return this.fileReadSize;
    }

    public boolean hasFrame(String identifier) {
        return this.frameMap.containsKey(identifier);
    }

    public boolean hasFrameAndBody(String identifier) {
        List<TagField> fields;
        if (this.hasFrame(identifier) && (fields = this.getFrame(identifier)).size() > 0) {
            TagField frame = fields.get(0);
            if (frame instanceof AbstractID3v2Frame) {
                return !(((AbstractID3v2Frame)frame).getBody() instanceof FrameBodyUnsupported);
            }
            return true;
        }
        return false;
    }

    public boolean hasFrameOfType(String identifier) {
        Iterator<String> iterator = this.frameMap.keySet().iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            String key = iterator.next();
            if (!key.startsWith(identifier)) continue;
            found = true;
        }
        return found;
    }

    public List<TagField> getFrame(String identifier) {
        return this.frameMap.get(identifier);
    }

    public List<TagField> getEncryptedFrame(String identifier) {
        return this.encryptedFrameMap.get(identifier);
    }

    @Override
    public String getFirst(String identifier) {
        AbstractID3v2Frame frame = this.getFirstField(identifier);
        if (frame == null) {
            return "";
        }
        return this.getTextValueForFrame(frame);
    }

    private String getTextValueForFrame(AbstractID3v2Frame frame) {
        return frame.getBody().getUserFriendlyValue();
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        List<TagField> fields = this.getFields(genericKey);
        if (fields.size() > 0) {
            return fields.get(0);
        }
        return null;
    }

    @Override
    public AbstractID3v2Frame getFirstField(String identifier) {
        List<TagField> fields = this.getFrame(identifier);
        if (fields == null || fields.isEmpty() || this.containsAggregatedFrame(fields)) {
            return null;
        }
        return (AbstractID3v2Frame)fields.get(0);
    }

    public void setFrame(AbstractID3v2Frame frame) {
        ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
        frames.add(frame);
        this.frameMap.put(frame.getIdentifier(), frames);
    }

    protected void setTagField(String id, TagField frame) {
        ArrayList<TagField> frames = new ArrayList<TagField>();
        frames.add(frame);
        this.frameMap.put(id, frames);
    }

    protected abstract ID3Frames getID3Frames();

    @Override
    public void setField(FieldKey genericKey, String ... values) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, values);
        this.setField(tagfield);
    }

    @Override
    public void addField(FieldKey genericKey, String ... value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.addField(tagfield);
    }

    public void mergeNumberTotalFrames(AbstractID3v2Frame newFrame, AbstractID3v2Frame nextFrame) {
        AbstractFrameBodyNumberTotal newBody = (AbstractFrameBodyNumberTotal)newFrame.getBody();
        AbstractFrameBodyNumberTotal oldBody = (AbstractFrameBodyNumberTotal)nextFrame.getBody();
        if (newBody.getNumber() != null && newBody.getNumber() > 0) {
            oldBody.setNumber(newBody.getNumberAsText());
        }
        if (newBody.getTotal() != null && newBody.getTotal() > 0) {
            oldBody.setTotal(newBody.getTotalAsText());
        }
    }

    public void mergeDuplicateFrames(AbstractID3v2Frame newFrame) {
        List<TagField> frames = this.frameMap.get(newFrame.getId());
        if (frames == null) {
            frames = new ArrayList<TagField>();
        }
        ListIterator<TagField> li = frames.listIterator();
        while (li.hasNext()) {
            TagField tagField = li.next();
            if (!(tagField instanceof AbstractID3v2Frame)) continue;
            AbstractID3v2Frame nextFrame = (AbstractID3v2Frame)tagField;
            if (newFrame.getBody() instanceof FrameBodyTXXX) {
                if (!((FrameBodyTXXX)newFrame.getBody()).getDescription().equals(((FrameBodyTXXX)nextFrame.getBody()).getDescription())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyWXXX) {
                if (!((FrameBodyWXXX)newFrame.getBody()).getDescription().equals(((FrameBodyWXXX)nextFrame.getBody()).getDescription())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyCOMM) {
                if (!((FrameBodyCOMM)newFrame.getBody()).getDescription().equals(((FrameBodyCOMM)nextFrame.getBody()).getDescription())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyUFID) {
                if (!((FrameBodyUFID)newFrame.getBody()).getOwner().equals(((FrameBodyUFID)nextFrame.getBody()).getOwner())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyUSLT) {
                if (!((FrameBodyUSLT)newFrame.getBody()).getDescription().equals(((FrameBodyUSLT)nextFrame.getBody()).getDescription())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyPOPM) {
                if (!((FrameBodyPOPM)newFrame.getBody()).getEmailToUser().equals(((FrameBodyPOPM)nextFrame.getBody()).getEmailToUser())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof AbstractFrameBodyNumberTotal) {
                this.mergeNumberTotalFrames(newFrame, nextFrame);
                return;
            }
            if (!(newFrame.getBody() instanceof AbstractFrameBodyPairs)) continue;
            AbstractFrameBodyPairs frameBody = (AbstractFrameBodyPairs)newFrame.getBody();
            AbstractFrameBodyPairs existingFrameBody = (AbstractFrameBodyPairs)nextFrame.getBody();
            existingFrameBody.addPair(frameBody.getText());
            return;
        }
        if (!this.getID3Frames().isMultipleAllowed(newFrame.getId())) {
            this.setFrame(newFrame);
        } else {
            frames.add(newFrame);
            this.frameMap.put(newFrame.getId(), frames);
        }
    }

    private void addNewFrameToMap(List<TagField> list, Map<String, List<TagField>> frameMap, AbstractID3v2Frame existingFrame, AbstractID3v2Frame frame) {
        if (list.size() == 0) {
            list.add(existingFrame);
            list.add(frame);
            frameMap.put(frame.getId(), list);
        } else {
            list.add(frame);
        }
    }

    private void addNewFrameOrAddField(List<TagField> list, Map<String, List<TagField>> frameMap, AbstractID3v2Frame existingFrame, AbstractID3v2Frame frame) {
        ArrayList<TagField> mergedList = new ArrayList<TagField>();
        if (existingFrame != null) {
            mergedList.add(existingFrame);
        } else {
            mergedList.addAll(list);
        }
        if (frame.getBody() instanceof FrameBodyTXXX) {
            FrameBodyTXXX frameBody = (FrameBodyTXXX)frame.getBody();
            boolean match = false;
            ListIterator i = mergedList.listIterator();
            while (i.hasNext()) {
                FrameBodyTXXX existingFrameBody = (FrameBodyTXXX)((AbstractID3v2Frame)i.next()).getBody();
                if (!frameBody.getDescription().equals(existingFrameBody.getDescription())) continue;
                existingFrameBody.addTextValue(frameBody.getText());
                match = true;
                break;
            }
            if (!match) {
                this.addNewFrameToMap(list, frameMap, existingFrame, frame);
            }
        } else if (frame.getBody() instanceof FrameBodyWXXX) {
            FrameBodyWXXX frameBody = (FrameBodyWXXX)frame.getBody();
            boolean match = false;
            ListIterator i = mergedList.listIterator();
            while (i.hasNext()) {
                FrameBodyWXXX existingFrameBody = (FrameBodyWXXX)((AbstractID3v2Frame)i.next()).getBody();
                if (!frameBody.getDescription().equals(existingFrameBody.getDescription())) continue;
                existingFrameBody.addUrlLink(frameBody.getUrlLink());
                match = true;
                break;
            }
            if (!match) {
                this.addNewFrameToMap(list, frameMap, existingFrame, frame);
            }
        } else if (frame.getBody() instanceof AbstractFrameBodyTextInfo) {
            AbstractFrameBodyTextInfo frameBody = (AbstractFrameBodyTextInfo)frame.getBody();
            AbstractFrameBodyTextInfo existingFrameBody = (AbstractFrameBodyTextInfo)existingFrame.getBody();
            existingFrameBody.addTextValue(frameBody.getText());
        } else if (frame.getBody() instanceof AbstractFrameBodyPairs) {
            AbstractFrameBodyPairs frameBody = (AbstractFrameBodyPairs)frame.getBody();
            AbstractFrameBodyPairs existingFrameBody = (AbstractFrameBodyPairs)existingFrame.getBody();
            existingFrameBody.addPair(frameBody.getText());
        } else if (frame.getBody() instanceof AbstractFrameBodyNumberTotal) {
            AbstractFrameBodyNumberTotal frameBody = (AbstractFrameBodyNumberTotal)frame.getBody();
            AbstractFrameBodyNumberTotal existingFrameBody = (AbstractFrameBodyNumberTotal)existingFrame.getBody();
            if (frameBody.getNumber() != null && frameBody.getNumber() > 0) {
                existingFrameBody.setNumber(frameBody.getNumberAsText());
            }
            if (frameBody.getTotal() != null && frameBody.getTotal() > 0) {
                existingFrameBody.setTotal(frameBody.getTotalAsText());
            }
        } else {
            this.addNewFrameToMap(list, frameMap, existingFrame, frame);
        }
    }

    @Override
    public void setField(TagField field) throws FieldDataInvalidException {
        if (!(field instanceof AbstractID3v2Frame) && !(field instanceof AggregatedFrame)) {
            throw new FieldDataInvalidException("Field " + field + " is not of type AbstractID3v2Frame nor AggregatedFrame");
        }
        if (field instanceof AbstractID3v2Frame) {
            this.mergeDuplicateFrames((AbstractID3v2Frame)field);
        } else {
            this.setTagField(field.getId(), field);
        }
    }

    @Override
    public void addField(TagField field) throws FieldDataInvalidException {
        if (field == null) {
            return;
        }
        if (!(field instanceof AbstractID3v2Frame) && !(field instanceof AggregatedFrame)) {
            throw new FieldDataInvalidException("Field " + field + " is not of type AbstractID3v2Frame or AggregatedFrame");
        }
        if (field instanceof AbstractID3v2Frame) {
            AbstractID3v2Frame frame = (AbstractID3v2Frame)field;
            List<TagField> fields = this.frameMap.get(field.getId());
            if (fields == null) {
                fields = new ArrayList<TagField>();
                fields.add(field);
                this.frameMap.put(field.getId(), fields);
            } else if (fields.size() == 1 && fields.get(0) instanceof AbstractID3v2Frame) {
                this.addNewFrameOrAddField(fields, this.frameMap, (AbstractID3v2Frame)fields.get(0), frame);
            } else {
                this.addNewFrameOrAddField(fields, this.frameMap, null, frame);
            }
        } else {
            this.setTagField(field.getId(), field);
        }
    }

    public void setFrame(String identifier, List<TagField> multiFrame) {
        logger.finest("Adding " + multiFrame.size() + " frames for " + identifier);
        this.frameMap.put(identifier, multiFrame);
    }

    public Iterator<Object> getFrameOfType(String identifier) {
        Iterator<String> iterator = this.frameMap.keySet().iterator();
        HashSet<Object> result = new HashSet<Object>();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith(identifier)) continue;
            List<TagField> o = this.frameMap.get(key);
            if (o instanceof List) {
                for (TagField next : o) {
                    result.add(next);
                }
                continue;
            }
            result.add(o);
        }
        return result.iterator();
    }

    @Override
    public void delete(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        FileChannel fc = file.getChannel();
        fc.position();
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        fc.read(byteBuffer, 0L);
        byteBuffer.flip();
        if (this.seek(byteBuffer)) {
            file.seek(0L);
            file.write(buffer);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractID3v2Tag)) {
            return false;
        }
        AbstractID3v2Tag object = (AbstractID3v2Tag)obj;
        return this.frameMap.equals(object.frameMap) && super.equals(obj);
    }

    public Iterator<List<TagField>> iterator() {
        return this.frameMap.values().iterator();
    }

    public void removeFrame(String identifier) {
        logger.config("Removing frame with identifier:" + identifier);
        this.frameMap.remove(identifier);
    }

    public void removeUnsupportedFrames() {
        Iterator<List<TagField>> fieldsIterator = this.iterator();
        while (fieldsIterator.hasNext()) {
            List<TagField> fields = fieldsIterator.next();
            Iterator<TagField> i = fields.iterator();
            while (i.hasNext()) {
                TagField o = i.next();
                if (!(o instanceof AbstractID3v2Frame) || !(((AbstractID3v2Frame)o).getBody() instanceof FrameBodyUnsupported)) continue;
                logger.finest("Removing frame" + ((AbstractID3v2Frame)o).getIdentifier());
                i.remove();
            }
            if (!fields.isEmpty()) continue;
            fieldsIterator.remove();
        }
    }

    public void removeFrameOfType(String identifier) {
        HashSet<String> result = new HashSet<String>();
        for (String key : this.frameMap.keySet()) {
            if (!key.startsWith(identifier)) continue;
            result.add(key);
        }
        for (String match : result) {
            logger.finest("Removing frame with identifier:" + match + "because starts with:" + identifier);
            this.frameMap.remove(match);
        }
    }

    public abstract long write(File var1, long var2) throws IOException;

    protected FileLock getFileLockForWriting(FileChannel fileChannel, String filePath) throws IOException {
        FileLock fileLock;
        logger.finest("locking fileChannel for " + filePath);
        try {
            fileLock = fileChannel.tryLock();
        }
        catch (IOException exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
        if (fileLock == null) {
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_FILE_LOCKED.getMsg(filePath));
        }
        return fileLock;
    }

    @Override
    public void write(RandomAccessFile file) throws IOException {
    }

    public void write(WritableByteChannel channel, int currentTagSize) throws IOException {
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(Channels.newChannel(outputStream), 0);
    }

    public void write(OutputStream outputStream, int currentTagSize) throws IOException {
        this.write(Channels.newChannel(outputStream), currentTagSize);
    }

    protected void writePadding(WritableByteChannel channel, int padding) throws IOException {
        if (padding > 0) {
            channel.write(ByteBuffer.wrap(new byte[padding]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getV2TagSizeIfExists(File file) throws IOException {
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        ByteBuffer bb = null;
        try {
            fis = new FileInputStream(file);
            fc = fis.getChannel();
            bb = ByteBuffer.allocate(10);
            ((FileChannel)fc).read(bb);
            bb.flip();
            if (bb.limit() < 10) {
                long l = 0L;
                return l;
            }
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        byte[] tagIdentifier = new byte[3];
        bb.get(tagIdentifier, 0, 3);
        if (!Arrays.equals(tagIdentifier, TAG_ID)) {
            return 0L;
        }
        byte majorVersion = bb.get();
        if (majorVersion != 2 && majorVersion != 3 && majorVersion != 4) {
            return 0L;
        }
        bb.get();
        bb.get();
        int frameSize = ID3SyncSafeInteger.bufferToValue(bb);
        return frameSize += 10;
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        logger.config("ByteBuffer pos:" + byteBuffer.position() + ":limit" + byteBuffer.limit() + ":cap" + byteBuffer.capacity());
        byte[] tagIdentifier = new byte[3];
        byteBuffer.get(tagIdentifier, 0, 3);
        if (!Arrays.equals(tagIdentifier, TAG_ID)) {
            return false;
        }
        if (byteBuffer.get() != this.getMajorVersion()) {
            return false;
        }
        return byteBuffer.get() == this.getRevision();
    }

    protected int calculateTagSize(int tagSize, int preferredSize) {
        if (TagOptionSingleton.getInstance().isId3v2PaddingWillShorten()) {
            return tagSize;
        }
        if (tagSize <= preferredSize) {
            return preferredSize;
        }
        return tagSize + 100;
    }

    protected void writeBufferToFile(File file, ByteBuffer headerBuffer, byte[] bodyByteBuffer, int padding, int sizeIncPadding, long audioStartLocation) throws IOException {
        try (SeekableByteChannel fc = Files.newByteChannel(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);){
            if ((long)sizeIncPadding > audioStartLocation) {
                fc.position(audioStartLocation);
                ShiftData.shiftDataByOffsetToMakeSpace(fc, (int)((long)sizeIncPadding - audioStartLocation));
            } else if (TagOptionSingleton.getInstance().isId3v2PaddingWillShorten() && (long)sizeIncPadding < audioStartLocation) {
                fc.position(audioStartLocation);
                ShiftData.shiftDataByOffsetToShrinkSpace(fc, (int)(audioStartLocation - (long)sizeIncPadding));
            }
            fc.position(0L);
            fc.write(headerBuffer);
            fc.write(ByteBuffer.wrap(bodyByteBuffer));
            fc.write(ByteBuffer.wrap(new byte[padding]));
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, this.getLoggingFilename() + ioe.getMessage(), ioe);
            if (ioe.getMessage().equals(FileSystemMessage.ACCESS_IS_DENIED.getMsg())) {
                logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
                throw new UnableToModifyFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
            }
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
            throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
        }
    }

    private boolean containsAggregatedFrame(Collection<TagField> fields) {
        boolean result = false;
        if (fields != null) {
            for (TagField field : fields) {
                if (!(field instanceof AggregatedFrame)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected final void copyFrameIntoMap(String id, AbstractID3v2Frame newFrame) {
        List<TagField> tagFields = this.frameMap.get(newFrame.getIdentifier());
        if (tagFields == null) {
            tagFields = new ArrayList<TagField>();
            tagFields.add(newFrame);
            this.frameMap.put(newFrame.getIdentifier(), tagFields);
        } else if (this.containsAggregatedFrame(tagFields)) {
            logger.severe("Duplicated Aggregate Frame, ignoring:" + id);
        } else {
            this.combineFrames(newFrame, tagFields);
        }
    }

    protected void combineFrames(AbstractID3v2Frame newFrame, List<TagField> existing) {
        existing.add(newFrame);
    }

    protected void loadFrameIntoMap(String frameId, AbstractID3v2Frame next) {
        if (next.getBody() instanceof FrameBodyEncrypted) {
            this.loadFrameIntoSpecifiedMap(this.encryptedFrameMap, frameId, next);
        } else {
            this.loadFrameIntoSpecifiedMap(this.frameMap, frameId, next);
        }
    }

    protected void loadFrameIntoSpecifiedMap(Map<String, List<TagField>> map, String frameId, AbstractID3v2Frame next) {
        if (ID3v24Frames.getInstanceOf().isMultipleAllowed(frameId) || ID3v23Frames.getInstanceOf().isMultipleAllowed(frameId) || ID3v22Frames.getInstanceOf().isMultipleAllowed(frameId)) {
            if (map.containsKey(frameId)) {
                List<TagField> multiValues = map.get(frameId);
                multiValues.add(next);
            } else {
                logger.finer("Adding Multi FrameList(3)" + frameId);
                ArrayList<AbstractID3v2Frame> fields = new ArrayList<AbstractID3v2Frame>();
                fields.add(next);
                map.put(frameId, fields);
            }
        } else if (map.containsKey(frameId) && !map.get(frameId).isEmpty()) {
            logger.warning("Ignoring Duplicate Frame:" + frameId);
            if (this.duplicateFrameId.length() > 0) {
                this.duplicateFrameId = this.duplicateFrameId + ";";
            }
            this.duplicateFrameId = this.duplicateFrameId + frameId;
            for (TagField tagField : this.frameMap.get(frameId)) {
                if (!(tagField instanceof AbstractID3v2Frame)) continue;
                this.duplicateBytes += ((AbstractID3v2Frame)tagField).getSize();
            }
        } else {
            logger.finer("Adding Frame" + frameId);
            ArrayList<AbstractID3v2Frame> fields = new ArrayList<AbstractID3v2Frame>();
            fields.add(next);
            map.put(frameId, fields);
        }
    }

    @Override
    public int getSize() {
        int size = 0;
        for (List<TagField> fields : this.frameMap.values()) {
            if (fields == null) continue;
            for (TagField field : fields) {
                if (field instanceof AggregatedFrame) {
                    AggregatedFrame af = (AggregatedFrame)field;
                    for (AbstractID3v2Frame next : af.frames) {
                        size += next.getSize();
                    }
                    continue;
                }
                if (!(field instanceof AbstractID3v2Frame)) continue;
                AbstractID3v2Frame frame = (AbstractID3v2Frame)field;
                size += frame.getSize();
            }
        }
        return size;
    }

    protected ByteArrayOutputStream writeFramesToBuffer() throws IOException {
        ByteArrayOutputStream bodyBuffer = new ByteArrayOutputStream();
        this.writeFramesToBufferStream(this.frameMap, bodyBuffer);
        this.writeFramesToBufferStream(this.encryptedFrameMap, bodyBuffer);
        return bodyBuffer;
    }

    private void writeFramesToBufferStream(Map<String, List<TagField>> map, ByteArrayOutputStream bodyBuffer) throws IOException {
        TreeSet<String> sortedWriteOrder = new TreeSet<String>(this.getPreferredFrameOrderComparator());
        sortedWriteOrder.addAll(map.keySet());
        for (String id : sortedWriteOrder) {
            List<TagField> fields = map.get(id);
            for (TagField field : fields) {
                if (field instanceof AbstractID3v2Frame) {
                    AbstractID3v2Frame frame = (AbstractID3v2Frame)field;
                    frame.setLoggingFilename(this.getLoggingFilename());
                    frame.write(bodyBuffer);
                    continue;
                }
                if (!(field instanceof AggregatedFrame)) continue;
                AggregatedFrame aggreagatedFrame = (AggregatedFrame)field;
                for (AbstractID3v2Frame next : aggreagatedFrame.getFrames()) {
                    next.setLoggingFilename(this.getLoggingFilename());
                    next.write(bodyBuffer);
                }
            }
        }
    }

    public abstract Comparator<String> getPreferredFrameOrderComparator();

    public void createStructure() {
        this.createStructureHeader();
        this.createStructureBody();
    }

    public void createStructureHeader() {
        MP3File.getStructureFormatter().addElement(TYPE_DUPLICATEBYTES, this.duplicateBytes);
        MP3File.getStructureFormatter().addElement(TYPE_DUPLICATEFRAMEID, this.duplicateFrameId);
        MP3File.getStructureFormatter().addElement(TYPE_EMPTYFRAMEBYTES, this.emptyFrameBytes);
        MP3File.getStructureFormatter().addElement(TYPE_FILEREADSIZE, this.fileReadSize);
        MP3File.getStructureFormatter().addElement(TYPE_INVALIDFRAMES, this.invalidFrames);
    }

    public void createStructureBody() {
        MP3File.getStructureFormatter().openHeadingElement(TYPE_BODY, "");
        for (List<TagField> fields : this.frameMap.values()) {
            for (TagField o : fields) {
                if (!(o instanceof AbstractID3v2Frame)) continue;
                AbstractID3v2Frame frame = (AbstractID3v2Frame)o;
                frame.createStructure();
            }
        }
        MP3File.getStructureFormatter().closeHeadingElement(TYPE_BODY);
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        ArrayList<String> values = new ArrayList<String>();
        List<TagField> fields = this.getFields(genericKey);
        if (ID3NumberTotalFields.isNumber(genericKey)) {
            if (fields != null && fields.size() > 0) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)fields.get(0);
                values.add(((AbstractFrameBodyNumberTotal)frame.getBody()).getNumberAsText());
            }
            return values;
        }
        if (ID3NumberTotalFields.isTotal(genericKey)) {
            if (fields != null && fields.size() > 0) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)fields.get(0);
                values.add(((AbstractFrameBodyNumberTotal)frame.getBody()).getTotalAsText());
            }
            return values;
        }
        if (genericKey == FieldKey.RATING) {
            if (fields != null && fields.size() > 0) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)fields.get(0);
                values.add(String.valueOf(((FrameBodyPOPM)frame.getBody()).getRating()));
            }
            return values;
        }
        return this.doGetValues(this.getFrameAndSubIdFromGenericKey(genericKey));
    }

    @Override
    public List<TagField> getFields(String id) throws KeyNotFoundException {
        List<TagField> o = this.getFrame(id);
        if (o == null) {
            return new ArrayList<TagField>();
        }
        if (o instanceof List) {
            return o;
        }
        throw new RuntimeException("Found entry in frameMap that was not a frame or a list:" + o);
    }

    public abstract AbstractID3v2Frame createFrame(String var1);

    @Override
    public boolean hasCommonFields() {
        return true;
    }

    @Override
    public boolean hasField(FieldKey key) {
        if (key == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        try {
            return this.getFirstField(key) != null;
        }
        catch (KeyNotFoundException knfe) {
            logger.log(Level.SEVERE, knfe.getMessage(), knfe);
            return false;
        }
    }

    @Override
    public boolean hasField(String id) {
        return this.hasFrame(id);
    }

    @Override
    public boolean isEmpty() {
        return this.frameMap.size() == 0;
    }

    @Override
    public Iterator<TagField> getFields() {
        ArrayList<TagField> allTagFields = new ArrayList<TagField>();
        for (List<TagField> value : this.frameMap.values()) {
            allTagFields.addAll(value);
        }
        return allTagFields.iterator();
    }

    @Override
    public int getFieldCount() {
        Iterator<TagField> it = this.getFields();
        int count = 0;
        try {
            while (true) {
                it.next();
                ++count;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return count;
        }
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        Iterator<TagField> it = this.getFields();
        int count = 0;
        try {
            while (true) {
                AbstractID3v2Frame frame;
                TagField next;
                if ((next = it.next()) instanceof AbstractID3v2Frame && (frame = (AbstractID3v2Frame)next).getBody() instanceof AbstractFrameBodyTextInfo && !(frame.getBody() instanceof FrameBodyTXXX)) {
                    AbstractFrameBodyTextInfo frameBody = (AbstractFrameBodyTextInfo)frame.getBody();
                    count += frameBody.getNumberOfValues();
                    continue;
                }
                ++count;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return count;
        }
    }

    @Override
    public boolean setEncoding(Charset enc) throws FieldDataInvalidException {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    @Override
    public String getFirst(FieldKey genericKey) throws KeyNotFoundException {
        return this.getValue(genericKey, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getValue(FieldKey genericKey, int index) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        if (ID3NumberTotalFields.isNumber(genericKey) || ID3NumberTotalFields.isTotal(genericKey)) {
            List<TagField> fields = this.getFields(genericKey);
            if (fields == null || fields.size() <= 0) return "";
            AbstractID3v2Frame frame = (AbstractID3v2Frame)fields.get(0);
            if (ID3NumberTotalFields.isNumber(genericKey)) {
                return ((AbstractFrameBodyNumberTotal)frame.getBody()).getNumberAsText();
            }
            if (ID3NumberTotalFields.isTotal(genericKey)) {
                return ((AbstractFrameBodyNumberTotal)frame.getBody()).getTotalAsText();
            }
        } else if (genericKey == FieldKey.RATING) {
            List<TagField> fields = this.getFields(genericKey);
            if (fields == null || fields.size() <= index) return "";
            AbstractID3v2Frame frame = (AbstractID3v2Frame)fields.get(index);
            return String.valueOf(((FrameBodyPOPM)frame.getBody()).getRating());
        }
        FrameAndSubId frameAndSubId = this.getFrameAndSubIdFromGenericKey(genericKey);
        return this.doGetValueAtIndex(frameAndSubId, index);
    }

    @Override
    public TagField createField(FieldKey genericKey, String ... values) throws KeyNotFoundException, FieldDataInvalidException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        if (values == null || values[0] == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        String value = values[0];
        FrameAndSubId formatKey = this.getFrameAndSubIdFromGenericKey(genericKey);
        if (ID3NumberTotalFields.isNumber(genericKey)) {
            AbstractID3v2Frame frame = this.createFrame(formatKey.getFrameId());
            AbstractFrameBodyNumberTotal framebody = (AbstractFrameBodyNumberTotal)frame.getBody();
            framebody.setNumber(value);
            return frame;
        }
        if (ID3NumberTotalFields.isTotal(genericKey)) {
            AbstractID3v2Frame frame = this.createFrame(formatKey.getFrameId());
            AbstractFrameBodyNumberTotal framebody = (AbstractFrameBodyNumberTotal)frame.getBody();
            framebody.setTotal(value);
            return frame;
        }
        return this.doCreateTagField(formatKey, values);
    }

    protected TagField doCreateTagField(FrameAndSubId formatKey, String ... values) throws KeyNotFoundException, FieldDataInvalidException {
        String value = values[0];
        AbstractID3v2Frame frame = this.createFrame(formatKey.getFrameId());
        if (frame.getBody() instanceof FrameBodyUFID) {
            ((FrameBodyUFID)frame.getBody()).setOwner(formatKey.getSubId());
            try {
                ((FrameBodyUFID)frame.getBody()).setUniqueIdentifier(value.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("When encoding UFID charset ISO-8859-1 was deemed unsupported");
            }
        } else if (frame.getBody() instanceof FrameBodyTXXX) {
            ((FrameBodyTXXX)frame.getBody()).setDescription(formatKey.getSubId());
            ((FrameBodyTXXX)frame.getBody()).setText(value);
        } else if (frame.getBody() instanceof FrameBodyWXXX) {
            ((FrameBodyWXXX)frame.getBody()).setDescription(formatKey.getSubId());
            ((FrameBodyWXXX)frame.getBody()).setUrlLink(value);
        } else if (frame.getBody() instanceof FrameBodyCOMM) {
            if (formatKey.getSubId() != null) {
                ((FrameBodyCOMM)frame.getBody()).setDescription(formatKey.getSubId());
                if (((FrameBodyCOMM)frame.getBody()).isMediaMonkeyFrame()) {
                    ((FrameBodyCOMM)frame.getBody()).setLanguage("XXX");
                }
            }
            ((FrameBodyCOMM)frame.getBody()).setText(value);
        } else if (frame.getBody() instanceof FrameBodyUSLT) {
            ((FrameBodyUSLT)frame.getBody()).setDescription("");
            ((FrameBodyUSLT)frame.getBody()).setLyric(value);
        } else if (frame.getBody() instanceof FrameBodyWOAR) {
            ((FrameBodyWOAR)frame.getBody()).setUrlLink(value);
        } else if (frame.getBody() instanceof AbstractFrameBodyTextInfo) {
            ((AbstractFrameBodyTextInfo)frame.getBody()).setText(value);
        } else if (frame.getBody() instanceof FrameBodyPOPM) {
            ((FrameBodyPOPM)frame.getBody()).parseString(value);
        } else if (frame.getBody() instanceof FrameBodyIPLS) {
            if (formatKey.getSubId() != null) {
                ((FrameBodyIPLS)frame.getBody()).addPair(formatKey.getSubId(), value);
            } else if (values.length >= 2) {
                ((FrameBodyIPLS)frame.getBody()).addPair(values[0], values[1]);
            } else {
                ((FrameBodyIPLS)frame.getBody()).addPair(values[0]);
            }
        } else if (frame.getBody() instanceof FrameBodyTIPL) {
            if (formatKey.getSubId() != null) {
                ((FrameBodyTIPL)frame.getBody()).addPair(formatKey.getSubId(), value);
            } else if (values.length >= 2) {
                ((FrameBodyTIPL)frame.getBody()).addPair(values[0], values[1]);
            } else {
                ((FrameBodyTIPL)frame.getBody()).addPair(values[0]);
            }
        } else if (frame.getBody() instanceof FrameBodyTMCL) {
            if (values.length >= 2) {
                ((FrameBodyTMCL)frame.getBody()).addPair(values[0], values[1]);
            } else {
                ((FrameBodyTMCL)frame.getBody()).addPair(values[0]);
            }
        } else {
            if (frame.getBody() instanceof FrameBodyAPIC || frame.getBody() instanceof FrameBodyPIC) {
                throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
            }
            throw new FieldDataInvalidException("Field with key of:" + formatKey.getFrameId() + ":does not accept cannot parse data:" + value);
        }
        return frame;
    }

    protected List<String> doGetValues(FrameAndSubId formatKey) throws KeyNotFoundException {
        ArrayList<String> values = new ArrayList<String>();
        if (formatKey.getSubId() != null) {
            List<TagField> list = this.getFields(formatKey.getFrameId());
            ListIterator<TagField> li = list.listIterator();
            while (li.hasNext()) {
                AbstractTagFrameBody next = ((AbstractID3v2Frame)li.next()).getBody();
                if (next instanceof FrameBodyTXXX) {
                    if (!((FrameBodyTXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    values.addAll(((FrameBodyTXXX)next).getValues());
                    continue;
                }
                if (next instanceof FrameBodyWXXX) {
                    if (!((FrameBodyWXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    values.addAll(((FrameBodyWXXX)next).getUrlLinks());
                    continue;
                }
                if (next instanceof FrameBodyCOMM) {
                    if (!((FrameBodyCOMM)next).getDescription().equals(formatKey.getSubId())) continue;
                    values.addAll(((FrameBodyCOMM)next).getValues());
                    continue;
                }
                if (next instanceof FrameBodyUFID) {
                    if (!((FrameBodyUFID)next).getOwner().equals(formatKey.getSubId()) || ((FrameBodyUFID)next).getUniqueIdentifier() == null) continue;
                    values.add(new String(((FrameBodyUFID)next).getUniqueIdentifier()));
                    continue;
                }
                if (next instanceof AbstractFrameBodyPairs) {
                    for (Pair entry : ((AbstractFrameBodyPairs)next).getPairing().getMapping()) {
                        if (!entry.getKey().equals(formatKey.getSubId()) || entry.getValue() == null) continue;
                        values.add(entry.getValue());
                    }
                    continue;
                }
                logger.severe(this.getLoggingFilename() + ":Need to implement getFields(FieldKey genericKey) for:" + formatKey + next.getClass());
            }
        } else if (formatKey.getGenericKey() != null && formatKey.getGenericKey() == FieldKey.INVOLVEDPEOPLE) {
            List<TagField> list = this.getFields(formatKey.getFrameId());
            ListIterator<TagField> li = list.listIterator();
            while (li.hasNext()) {
                AbstractTagFrameBody next = ((AbstractID3v2Frame)li.next()).getBody();
                if (!(next instanceof AbstractFrameBodyPairs)) continue;
                for (Pair entry : ((AbstractFrameBodyPairs)next).getPairing().getMapping()) {
                    if (entry.getValue().isEmpty()) continue;
                    if (!entry.getKey().isEmpty()) {
                        values.add(entry.getPairValue());
                        continue;
                    }
                    values.add(entry.getValue());
                }
            }
        } else {
            List<TagField> list = this.getFields(formatKey.getFrameId());
            for (TagField next : list) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)next;
                if (frame == null) continue;
                if (frame.getBody() instanceof AbstractFrameBodyTextInfo) {
                    AbstractFrameBodyTextInfo fb = (AbstractFrameBodyTextInfo)frame.getBody();
                    values.addAll(fb.getValues());
                    continue;
                }
                values.add(this.getTextValueForFrame(frame));
            }
        }
        return values;
    }

    protected String doGetValueAtIndex(FrameAndSubId formatKey, int index) throws KeyNotFoundException {
        List<String> values = this.doGetValues(formatKey);
        if (values.size() > index) {
            return values.get(index);
        }
        return "";
    }

    public TagField createLinkedArtworkField(String url) {
        AbstractID3v2Frame frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        if (frame.getBody() instanceof FrameBodyAPIC) {
            FrameBodyAPIC body = (FrameBodyAPIC)frame.getBody();
            body.setObjectValue("PictureData", url.getBytes(StandardCharsets.ISO_8859_1));
            body.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
            body.setObjectValue("MIMEType", "-->");
            body.setObjectValue("Description", "");
        } else if (frame.getBody() instanceof FrameBodyPIC) {
            FrameBodyPIC body = (FrameBodyPIC)frame.getBody();
            body.setObjectValue("PictureData", url.getBytes(StandardCharsets.ISO_8859_1));
            body.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
            body.setObjectValue("ImageType", "-->");
            body.setObjectValue("Description", "");
        }
        return frame;
    }

    private void deleteNumberTotalFrame(FrameAndSubId formatKey, FieldKey numberFieldKey, FieldKey totalFieldKey, boolean deleteNumberFieldKey) {
        if (deleteNumberFieldKey) {
            String total = this.getFirst(totalFieldKey);
            if (total.length() == 0) {
                this.doDeleteTagField(formatKey);
                return;
            }
            List<TagField> fields = this.getFrame(formatKey.getFrameId());
            if (fields.size() > 0) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)fields.get(0);
                AbstractFrameBodyNumberTotal frameBody = (AbstractFrameBodyNumberTotal)frame.getBody();
                if (frameBody.getTotal() == 0) {
                    this.doDeleteTagField(formatKey);
                    return;
                }
                frameBody.setNumber(0);
                return;
            }
        } else {
            String number = this.getFirst(numberFieldKey);
            if (number.length() == 0) {
                this.doDeleteTagField(formatKey);
                return;
            }
            for (TagField field : this.getFrame(formatKey.getFrameId())) {
                if (!(field instanceof AbstractID3v2Frame)) continue;
                AbstractID3v2Frame frame = (AbstractID3v2Frame)field;
                AbstractFrameBodyNumberTotal frameBody = (AbstractFrameBodyNumberTotal)frame.getBody();
                if (frameBody.getNumber() == 0) {
                    this.doDeleteTagField(formatKey);
                }
                frameBody.setTotal(0);
            }
        }
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        FrameAndSubId formatKey = this.getFrameAndSubIdFromGenericKey(fieldKey);
        if (fieldKey == null) {
            throw new KeyNotFoundException();
        }
        switch (fieldKey) {
            case TRACK: {
                this.deleteNumberTotalFrame(formatKey, FieldKey.TRACK, FieldKey.TRACK_TOTAL, true);
                break;
            }
            case TRACK_TOTAL: {
                this.deleteNumberTotalFrame(formatKey, FieldKey.TRACK, FieldKey.TRACK_TOTAL, false);
                break;
            }
            case DISC_NO: {
                this.deleteNumberTotalFrame(formatKey, FieldKey.DISC_NO, FieldKey.DISC_TOTAL, true);
                break;
            }
            case DISC_TOTAL: {
                this.deleteNumberTotalFrame(formatKey, FieldKey.DISC_NO, FieldKey.DISC_TOTAL, false);
                break;
            }
            case MOVEMENT_NO: {
                this.deleteNumberTotalFrame(formatKey, FieldKey.MOVEMENT_NO, FieldKey.MOVEMENT_TOTAL, true);
                break;
            }
            case MOVEMENT_TOTAL: {
                this.deleteNumberTotalFrame(formatKey, FieldKey.MOVEMENT_NO, FieldKey.MOVEMENT_TOTAL, false);
                break;
            }
            default: {
                this.doDeleteTagField(formatKey);
            }
        }
    }

    protected void doDeleteTagField(FrameAndSubId formatKey) throws KeyNotFoundException {
        if (formatKey.getSubId() != null) {
            List<TagField> list = this.getFields(formatKey.getFrameId());
            ListIterator<TagField> li = list.listIterator();
            while (li.hasNext()) {
                AbstractTagFrameBody next = ((AbstractID3v2Frame)li.next()).getBody();
                if (next instanceof FrameBodyTXXX) {
                    if (!((FrameBodyTXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    if (list.size() == 1) {
                        this.removeFrame(formatKey.getFrameId());
                        continue;
                    }
                    li.remove();
                    continue;
                }
                if (next instanceof FrameBodyCOMM) {
                    if (!((FrameBodyCOMM)next).getDescription().equals(formatKey.getSubId())) continue;
                    if (list.size() == 1) {
                        this.removeFrame(formatKey.getFrameId());
                        continue;
                    }
                    li.remove();
                    continue;
                }
                if (next instanceof FrameBodyWXXX) {
                    if (!((FrameBodyWXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    if (list.size() == 1) {
                        this.removeFrame(formatKey.getFrameId());
                        continue;
                    }
                    li.remove();
                    continue;
                }
                if (next instanceof FrameBodyUFID) {
                    if (!((FrameBodyUFID)next).getOwner().equals(formatKey.getSubId())) continue;
                    if (list.size() == 1) {
                        this.removeFrame(formatKey.getFrameId());
                        continue;
                    }
                    li.remove();
                    continue;
                }
                throw new RuntimeException("Need to implement getFields(FieldKey genericKey) for:" + next.getClass());
            }
        } else if (formatKey.getSubId() == null) {
            this.removeFrame(formatKey.getFrameId());
        }
    }

    protected abstract FrameAndSubId getFrameAndSubIdFromGenericKey(FieldKey var1);

    @Override
    public List<TagField> getFields(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        FrameAndSubId formatKey = this.getFrameAndSubIdFromGenericKey(genericKey);
        if (formatKey == null) {
            throw new KeyNotFoundException();
        }
        List<TagField> list = this.getFields(formatKey.getFrameId());
        ArrayList<TagField> filteredList = new ArrayList<TagField>();
        String subFieldId = formatKey.getSubId();
        if (subFieldId != null) {
            for (TagField tagfield : list) {
                AbstractTagFrameBody next = ((AbstractID3v2Frame)tagfield).getBody();
                if (next instanceof FrameBodyTXXX) {
                    if (!((FrameBodyTXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    filteredList.add(tagfield);
                    continue;
                }
                if (next instanceof FrameBodyWXXX) {
                    if (!((FrameBodyWXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    filteredList.add(tagfield);
                    continue;
                }
                if (next instanceof FrameBodyCOMM) {
                    if (!((FrameBodyCOMM)next).getDescription().equals(formatKey.getSubId())) continue;
                    filteredList.add(tagfield);
                    continue;
                }
                if (next instanceof FrameBodyUFID) {
                    if (!((FrameBodyUFID)next).getOwner().equals(formatKey.getSubId())) continue;
                    filteredList.add(tagfield);
                    continue;
                }
                if (next instanceof FrameBodyIPLS) {
                    for (Pair entry : ((FrameBodyIPLS)next).getPairing().getMapping()) {
                        if (!entry.getKey().equals(formatKey.getSubId())) continue;
                        filteredList.add(tagfield);
                    }
                    continue;
                }
                if (next instanceof FrameBodyTIPL) {
                    for (Pair entry : ((FrameBodyTIPL)next).getPairing().getMapping()) {
                        if (!entry.getKey().equals(formatKey.getSubId())) continue;
                        filteredList.add(tagfield);
                    }
                    continue;
                }
                logger.severe("Need to implement getFields(FieldKey genericKey) for:" + formatKey + next.getClass());
            }
            return filteredList;
        }
        if (ID3NumberTotalFields.isNumber(genericKey)) {
            for (TagField tagfield : list) {
                AbstractTagFrameBody next = ((AbstractID3v2Frame)tagfield).getBody();
                if (!(next instanceof AbstractFrameBodyNumberTotal) || ((AbstractFrameBodyNumberTotal)next).getNumber() == null) continue;
                filteredList.add(tagfield);
            }
            return filteredList;
        }
        if (ID3NumberTotalFields.isTotal(genericKey)) {
            for (TagField tagfield : list) {
                AbstractTagFrameBody next = ((AbstractID3v2Frame)tagfield).getBody();
                if (!(next instanceof AbstractFrameBodyNumberTotal) || ((AbstractFrameBodyNumberTotal)next).getTotal() == null) continue;
                filteredList.add(tagfield);
            }
            return filteredList;
        }
        return list;
    }

    @Override
    public Artwork getFirstArtwork() {
        List<Artwork> artwork = this.getArtworkList();
        if (artwork.size() > 0) {
            return artwork.get(0);
        }
        return null;
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.setField(this.createField(artwork));
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.addField(this.createField(artwork));
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.deleteField(FieldKey.COVER_ART);
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Tag content:\n");
        Iterator<TagField> it = this.getFields();
        while (it.hasNext()) {
            TagField field = it.next();
            out.append("\t");
            out.append(field.getId());
            out.append(":");
            out.append(field.toString());
            out.append("\n");
        }
        return out.toString();
    }

    @Override
    public TagField createCompilationField(boolean value) throws KeyNotFoundException, FieldDataInvalidException {
        if (value) {
            return this.createField(FieldKey.IS_COMPILATION, "1");
        }
        return this.createField(FieldKey.IS_COMPILATION, "0");
    }

    public Long getStartLocationInFile() {
        return this.startLocationInFile;
    }

    public void setStartLocationInFile(long startLocationInFile) {
        this.startLocationInFile = startLocationInFile;
    }

    public Long getEndLocationInFile() {
        return this.endLocationInFile;
    }

    public void setEndLocationInFile(long endLocationInFile) {
        this.endLocationInFile = endLocationInFile;
    }

    class FrameAndSubId {
        private FieldKey genericKey;
        private String frameId;
        private String subId;

        public FrameAndSubId(FieldKey genericKey, String frameId, String subId) {
            this.genericKey = genericKey;
            this.frameId = frameId;
            this.subId = subId;
        }

        public FieldKey getGenericKey() {
            return this.genericKey;
        }

        public String getFrameId() {
            return this.frameId;
        }

        public String getSubId() {
            return this.subId;
        }

        public String toString() {
            return String.format("%s:%s:%s", this.genericKey.name(), this.frameId, this.subId);
        }
    }
}

