/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;

public class Mp4FreeBox
extends AbstractMp4Box {
    public Mp4FreeBox(int datasize) {
        try {
            this.header = new Mp4BoxHeader();
            ByteArrayOutputStream headerBaos = new ByteArrayOutputStream();
            headerBaos.write(Utils.getSizeBEInt32(8 + datasize));
            headerBaos.write(Mp4AtomIdentifier.FREE.getFieldName().getBytes(StandardCharsets.ISO_8859_1));
            this.header.update(ByteBuffer.wrap(headerBaos.toByteArray()));
            ByteArrayOutputStream freeBaos = new ByteArrayOutputStream();
            for (int i = 0; i < datasize; ++i) {
                freeBaos.write(0);
            }
            this.dataBuffer = ByteBuffer.wrap(freeBaos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

