/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public class MpegUtil {
    private MpegUtil() {
    }

    public static int getDurationFromMpeg(File f) throws IOException {
        block7: {
            try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
                Map<Integer, Integer> ptsEnd;
                Map<Integer, Integer> ptsStart;
                if (raf.length() < 500000L || (ptsStart = MpegUtil.checkRange(raf, 0L, 250000, false)) == null || (ptsEnd = MpegUtil.checkRange(raf, 0L, 250000, true)) == null) break block7;
                for (Map.Entry<Integer, Integer> entry : ptsStart.entrySet()) {
                    Integer id = entry.getKey();
                    if (ptsEnd.get(id) == null) continue;
                    int dur = ptsEnd.get(id) - entry.getValue();
                    int n = dur /= 90000;
                    return n;
                }
            }
        }
        return 0;
    }

    private static Map<Integer, Integer> checkRange(RandomAccessFile raf, long startingPos, int range, boolean end) throws IOException {
        int i;
        HashMap<Integer, Integer> pts = new HashMap<Integer, Integer>();
        byte[] buffer = new byte[range];
        if (end) {
            raf.seek(raf.length() - (long)range);
        } else {
            raf.seek(0L + startingPos);
        }
        raf.read(buffer, 0, buffer.length);
        int ps = 0;
        int start = 0;
        for (i = 0; i < 400; ++i) {
            if (buffer[i] == 71 && buffer[i + 188] == 71) {
                ps = 188;
                start = i;
                break;
            }
            if (buffer[i] != 71 || buffer[i + 192] != 71) continue;
            ps = 192;
            start = i;
            break;
        }
        if (ps == 0) {
            return null;
        }
        for (i = start; i < buffer.length - ps; i += ps) {
            int diff;
            Integer id = ((buffer[i + 1] + 256) % 256 - 64) * 256 + (buffer[i + 2] + 256) % 256;
            if (buffer[i + 7] != -32 || buffer[i + 6] != 1 || (buffer[diff = i + 7 + 4] & 0x80) != 128 || (buffer[diff + 2] & 0x20) != 32 || pts.get(id) != null && (pts.get(id) == null || !end)) continue;
            pts.put(id, MpegUtil.getTS(buffer, diff + 3));
        }
        return pts;
    }

    private static int getTS(byte[] buffer, int diff) {
        return (((buffer[diff + 0] & 0xFF) << 8) + (buffer[diff + 1] & 0xFF) >> 1 << 15) + (((buffer[diff + 2] & 0xFF) << 8) + (buffer[diff + 3] & 0xFF) >> 1);
    }

    public static long getPositionForTimeInMpeg(File f, int timeS) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        Map<Integer, Integer> ptsStart = MpegUtil.checkRange(raf, 0L, 250000, false);
        long currentPos = 0L;
        if (ptsStart != null && !ptsStart.isEmpty()) {
            long minRangePos = 0L;
            long maxRangePos = raf.length();
            boolean nextPosition = true;
            block0: while (maxRangePos - minRangePos > 250000L && nextPosition) {
                nextPosition = false;
                currentPos = minRangePos + (maxRangePos - minRangePos) / 2L;
                Map<Integer, Integer> ptsEnd = MpegUtil.checkRange(raf, currentPos, 250000, false);
                if (ptsEnd != null) {
                    for (Map.Entry<Integer, Integer> entry : ptsStart.entrySet()) {
                        Integer id = entry.getKey();
                        if (ptsEnd.get(id) == null) continue;
                        int time = (ptsEnd.get(id) - entry.getValue()) / 90000;
                        if (time == timeS) {
                            return currentPos;
                        }
                        nextPosition = true;
                        if (time > timeS) {
                            maxRangePos = currentPos;
                            continue block0;
                        }
                        minRangePos = currentPos;
                        continue block0;
                    }
                    continue;
                }
                return currentPos;
            }
        }
        return currentPos;
    }
}

