/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class LoggableOutputStream
extends OutputStream {
    protected final Charset logCharset;
    protected final OutputStream outputStream;
    protected final ByteArrayOutputStream logStream = new ByteArrayOutputStream();

    public LoggableOutputStream(OutputStream outputStream) {
        this(outputStream, null);
    }

    public LoggableOutputStream(OutputStream outputStream, Charset logCharset) {
        this.outputStream = outputStream;
        this.logCharset = logCharset == null ? StandardCharsets.ISO_8859_1 : logCharset;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.outputStream != null) {
            this.outputStream.write(b);
        }
        this.logStream.write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public byte[] getReadBytes() {
        return this.logStream.toByteArray();
    }

    public String toString() {
        try {
            return this.logStream.toString(this.logCharset.name());
        }
        catch (UnsupportedEncodingException e) {
            return "UnsupportedEncodingException: " + e.getMessage();
        }
    }
}

