/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.platform.PlatformUtils;
import net.pms.util.FileUtil;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.JaroWinklerSimilarity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImdbUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbUtil.class);
    private static final String FILENAME_HASH = "_os([^_]+)_";
    private static final String FILENAME_IMDB_ID = "_imdb([^_]+)_";
    private static final Pattern NFO_IMDB_ID = Pattern.compile("imdb\\.[^\\/]+\\/title\\/tt(\\d+)", 2);

    private ImdbUtil() {
    }

    public static String extractOSHash(Path file) {
        return ImdbUtil.extractFromFileName(file, FILENAME_HASH);
    }

    public static String extractImdbId(Path file, boolean scanNfo) {
        String imdbId = ImdbUtil.extractFromFileName(file, FILENAME_IMDB_ID);
        if (StringUtils.isNotBlank(imdbId)) {
            return ImdbUtil.removeTT(imdbId);
        }
        return scanNfo ? ImdbUtil.extractImdbIdFromNfo(file) : null;
    }

    private static String extractFromFileName(Path file, String regex) {
        String fileName;
        if (file == null || file.getFileName() == null || regex == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(fileName = file.getFileName().toString());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractImdbIdFromNfo(Path file) {
        if (file == null) {
            return null;
        }
        Path nfoFile = FileUtil.replaceExtension(file, "nfo", false, true);
        if (nfoFile == null) {
            return null;
        }
        if (!Files.exists(nfoFile, new LinkOption[0])) {
            Path nfoFileNamePath = nfoFile.getFileName();
            String nfoFileName = nfoFileNamePath == null ? null : nfoFileNamePath.toString();
            Path parent = nfoFile.getParent();
            if (StringUtils.isNotBlank(nfoFileName) && parent != null) {
                HashMap<Path, Double> candidates = new HashMap<Path, Double>();
                try (DirectoryStream<Path> nfoFiles = Files.newDirectoryStream(parent, entry -> {
                    String extension = FileUtil.getExtension(entry.getFileName());
                    return "nfo".equals(extension) || "NFO".equals(extension);
                });){
                    for (Path entry2 : nfoFiles) {
                        double score;
                        Path entryFileNamePath = entry2.getFileName();
                        String entryName = entryFileNamePath == null ? null : entryFileNamePath.toString();
                        if (StringUtils.isBlank(entryName) || !((score = new JaroWinklerSimilarity().apply(nfoFileName, entryName).doubleValue()) >= 0.85)) continue;
                        candidates.put(entry2, score);
                    }
                    if (!candidates.isEmpty()) {
                        ArrayList candidatesList = new ArrayList(candidates.entrySet());
                        if (candidatesList.size() > 1) {
                            Collections.sort(candidatesList, (o1, o2) -> ((Double)o2.getValue()).compareTo((Double)o1.getValue()));
                        }
                        nfoFile = (Path)candidatesList.get(0).getKey();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("An error occurred when trying to scan for nfo files belonging to \"{}\": {}", (Object)file, (Object)e.getMessage());
                    LOGGER.trace("", e);
                }
            }
        }
        if (!Files.exists(nfoFile, new LinkOption[0])) {
            LOGGER.debug("Didn't find a matching nfo file for \"{}\" to search for IMDb ID", (Object)file);
            return null;
        }
        try {
            if (Files.size(nfoFile) > 100000L) {
                LOGGER.debug("Skipping search for IMDb ID in \"{}\" since it's too large ({})", (Object)nfoFile, (Object)StringUtil.formatBytes(Files.size(nfoFile), true));
                return null;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to get size of \"{}\", skipping search for IMDb ID: {}", (Object)nfoFile, (Object)e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
        Charset charset = null;
        try {
            charset = FileUtil.detectCharset(nfoFile, 70);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while trying to detect the character encoding of \"{}\": {}", (Object)nfoFile, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        if (charset == null) {
            charset = PlatformUtils.INSTANCE.getDefaultCharset();
            LOGGER.debug("Failed to detect the character encoding of \"{}\", falling back to the default charset \"{}\"", (Object)nfoFile, (Object)charset);
        }
        LOGGER.trace("Scanning \"{}\" for IMDb ID for \"{}\"", (Object)nfoFile, (Object)file);
        try (BufferedReader reader = Files.newBufferedReader(nfoFile, charset);){
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher = NFO_IMDB_ID.matcher(line);
                if (matcher.find()) {
                    LOGGER.trace("Found IMDb ID {} for \"{}\" in \"{}\"", matcher.group(1), file, nfoFile);
                    String string = matcher.group(1);
                    return string;
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while scanning \"{}\" for IMDb ID: {}", (Object)nfoFile, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        LOGGER.trace("Failed to find IMDb ID for \"{}\" in \"{}\"", (Object)file, (Object)nfoFile);
        return null;
    }

    public static String ensureTT(String imdbId) {
        if (StringUtils.isBlank(imdbId)) {
            return imdbId;
        }
        return (imdbId = imdbId.trim().toLowerCase(Locale.ROOT)).startsWith("tt") ? imdbId : "tt" + imdbId;
    }

    public static String removeTT(String imdbId) {
        if (StringUtils.isBlank(imdbId)) {
            return imdbId;
        }
        return (imdbId = imdbId.trim().toLowerCase(Locale.ROOT)).startsWith("tt") ? imdbId.substring(2) : imdbId;
    }
}

