/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H264AnnexBInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(H264AnnexBInputStream.class);
    private final InputStream source;
    private final byte[] header;
    private int nextTarget;
    private boolean firstHeader;

    public H264AnnexBInputStream(InputStream source, byte[] header) {
        this.source = source;
        this.header = header;
        this.firstHeader = true;
        this.nextTarget = -1;
    }

    @Override
    public int read() throws IOException {
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        byte[] h = null;
        boolean insertHeader = false;
        if (this.nextTarget == -1) {
            h = this.getArray(4);
            if (h == null) {
                return -1;
            }
            this.nextTarget = 0x1000000 * (h[0] & 0xFF) + 65536 * (h[1] & 0xFF) + 256 * (h[2] & 0xFF) + (h[3] & 0xFF);
            h = this.getArray(3);
            if (h == null) {
                return -1;
            }
            boolean bl = insertHeader = (h[0] & 0x25) == 37 && (h[1] & 0xFFFFFF88) == -120;
            if (!insertHeader) {
                System.arraycopy(new byte[]{0, 0, 0, 1}, 0, b, off, 4);
                off += 4;
            }
            this.nextTarget -= 3;
        }
        if (this.nextTarget == -1) {
            return -1;
        }
        if (insertHeader) {
            byte[] defHeader = this.header;
            if (!this.firstHeader) {
                defHeader = new byte[this.header.length + 1];
                System.arraycopy(this.header, 0, defHeader, 0, this.header.length);
                defHeader[defHeader.length - 1] = 1;
                defHeader[defHeader.length - 2] = 0;
            }
            if (defHeader.length < len - off) {
                System.arraycopy(defHeader, 0, b, off, defHeader.length);
                off += defHeader.length;
            } else {
                System.arraycopy(defHeader, 0, b, off, len - off);
                off = len;
            }
            this.firstHeader = false;
        }
        if (h != null) {
            System.arraycopy(h, 0, b, off, 3);
            off += 3;
        }
        if (this.nextTarget < len - off) {
            h = this.getArray(this.nextTarget);
            if (h == null) {
                return -1;
            }
            System.arraycopy(h, 0, b, off, this.nextTarget);
            off += this.nextTarget;
            this.nextTarget = -1;
        } else {
            h = this.getArray(len - off);
            if (h == null) {
                return -1;
            }
            System.arraycopy(h, 0, b, off, len - off);
            this.nextTarget -= len - off;
            off = len;
        }
        return off;
    }

    private byte[] getArray(int length) throws IOException {
        int u;
        if (length < 0) {
            LOGGER.trace("Negative array ?");
            return null;
        }
        byte[] bb = new byte[length];
        int n = this.source.read(bb);
        if (n == -1) {
            return null;
        }
        while (n < length && (u = this.source.read(bb, n, length - n)) != -1) {
            n += u;
        }
        return bb;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.source != null) {
            this.source.close();
        }
    }
}

