/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.File;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.PMS;
import net.pms.store.StoreResource;
import net.pms.store.item.RealFile;
import net.pms.util.FileUtil;
import net.pms.util.VideoClassification;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class FileNamePrettifier {
    public static final String COMMON_FILE_ENDS = "[\\s\\.]AC3.*|[\\s\\.]REPACK.*|[\\s\\.]480p.*|[\\s\\.]720p.*|[\\s\\.]m-720p.*|[\\s\\.]900p.*|[\\s\\.]1080p.*|[\\s\\.]2160p.*|[\\s\\.]WEB-DL.*|[\\s\\.]HDTV.*|[\\s\\.]DSR.*|[\\s\\.]PDTV.*|[\\s\\.]SDTV.*|[\\s\\.]WS.*|[\\s\\.]HQ.*|[\\s\\.]DVDRip.*|[\\s\\.]TVRiP.*|[\\s\\.]BDRip.*|[\\s\\.]BRRip.*|[\\s\\.]WEBRip.*|[\\s\\.]BluRay.*|[\\s\\.]Blu-ray.*|[\\s\\.]SUBBED.*|[\\s\\.]x264.*|[\\s\\.]Dual[\\s\\.]Audio.*|[\\s\\.]HSBS.*|[\\s\\.]H-SBS.*|[\\s\\.]RERiP.*|[\\s\\.]DIRFIX.*|[\\s\\.]READNFO.*|[\\s\\.]60FPS.*|[\\s\\.]Xvid.*|[\\s\\.]DivX.*|[\\s\\.]DVB.*";
    protected static final Pattern COMMON_FILE_ENDS_PATTERN = Pattern.compile("[\\s\\.]AC3.*|[\\s\\.]REPACK.*|[\\s\\.]480p.*|[\\s\\.]720p.*|[\\s\\.]m-720p.*|[\\s\\.]900p.*|[\\s\\.]1080p.*|[\\s\\.]2160p.*|[\\s\\.]WEB-DL.*|[\\s\\.]HDTV.*|[\\s\\.]DSR.*|[\\s\\.]PDTV.*|[\\s\\.]SDTV.*|[\\s\\.]WS.*|[\\s\\.]HQ.*|[\\s\\.]DVDRip.*|[\\s\\.]TVRiP.*|[\\s\\.]BDRip.*|[\\s\\.]BRRip.*|[\\s\\.]WEBRip.*|[\\s\\.]BluRay.*|[\\s\\.]Blu-ray.*|[\\s\\.]SUBBED.*|[\\s\\.]x264.*|[\\s\\.]Dual[\\s\\.]Audio.*|[\\s\\.]HSBS.*|[\\s\\.]H-SBS.*|[\\s\\.]RERiP.*|[\\s\\.]DIRFIX.*|[\\s\\.]READNFO.*|[\\s\\.]60FPS.*|[\\s\\.]Xvid.*|[\\s\\.]DivX.*|[\\s\\.]DVB.*");
    public static final String COMMON_FILE_ENDS_CASE_SENSITIVE = "[\\s\\.]PROPER[\\s\\.].*|[\\s\\.]iNTERNAL[\\s\\.].*|[\\s\\.]LIMITED[\\s\\.].*|[\\s\\.]LiMiTED[\\s\\.].*|[\\s\\.]FESTiVAL[\\s\\.].*|[\\s\\.]NORDIC[\\s\\.].*|[\\s\\.]REAL[\\s\\.].*|[\\s\\.]SUBBED[\\s\\.].*|[\\s\\.]RETAIL[\\s\\.].*|[\\s\\.]EXTENDED[\\s\\.].*|[\\s\\.]NEWEDIT[\\s\\.].*|[\\s\\.]WEB[\\s\\.].*|[\\s\\.]NORDiC[\\s\\.].*|\\[shareprovider[\\s\\.]com\\].*|\\[sharethefiles[\\s\\.]com\\].*";
    private static final Pattern COMMON_FILE_EDITIONS = Pattern.compile("(?i)(?:\\s+-\\s+)?(?!\\()(Special[\\s\\.]Edition|Unrated|Final[\\s\\.]Cut|Remastered|Extended[\\s\\.]Cut|IMAX[\\s\\.]Edition|Uncensored|Directors[\\s\\.]Cut|Uncut)(?!\\))");
    private static final Pattern SERIES_EPISODE_EPISODE = Pattern.compile("[sS](\\d{1,3})-?[eE](\\d{1,4})-?[eE](\\d{1,4})");
    private static final Pattern SERIES_EPISODE = Pattern.compile("[sS](\\d{1,3})-?[eE](\\d{1,4})");
    private static final Pattern SERIES_DATE = Pattern.compile("([19|20]\\d{2})[\\s\\.]([0-1]\\d)[\\s\\.]([0-3]\\d)");
    private static final Pattern MOVIE_YEAR = Pattern.compile("[\\(\\[]((?:19|20)\\d{2})[\\)\\]]|((?<![\\d\\(\\[])(?:19|20)\\d{2}(?![\\d\\)\\]]))");
    private static final Pattern ANIME_SERIES_EPISODE = Pattern.compile("(?:[\\s\\.']|S(\\d{1,2})[\\s\\.]?EP)(\\d{1,3})(?:[\\s\\.']|v\\d)", 2);
    private static final Pattern ANIME_SERIES_EPISODE_EPISODE = Pattern.compile("(?:[\\s\\.']|S(\\d{1,2})[\\s\\.]?EP)(\\d{1,3})-(\\d{1,3})(?:[\\s\\.']|v\\d)", 2);
    private static final Pattern LEADING_TRAILING_HYPHEN = Pattern.compile("^-\\s*|\\s*-$");
    private static final Pattern ANIME_HASH = Pattern.compile("\\[[0-9a-zA-Z]{8}\\]$");
    private final String fileName;
    private final String fileNameWithoutExtension;
    private final Locale locale;
    private VideoClassification classification;
    private String name;
    private int year = -1;
    private String edition;
    private int season = -1;
    private int episode = -1;
    private String episodeName;

    public FileNamePrettifier(StoreResource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        String tmpName = null;
        if (resource instanceof RealFile) {
            RealFile realFile = (RealFile)resource;
            tmpName = realFile.getFile().getName();
        }
        if (StringUtils.isBlank(tmpName)) {
            tmpName = resource.getFileName();
        }
        if (StringUtils.isBlank(tmpName)) {
            tmpName = resource.getName();
        }
        this.fileName = tmpName;
        this.fileNameWithoutExtension = FileUtil.getFileNameWithoutExtension(tmpName);
        this.locale = PMS.getLocale();
        this.parse();
    }

    public FileNamePrettifier(File file) {
        this(file.getName(), null);
    }

    public FileNamePrettifier(File file, Locale locale) {
        this(file.getName(), locale);
    }

    public FileNamePrettifier(String fileName) {
        this(fileName, null);
    }

    public FileNamePrettifier(String fileName, Locale locale) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName cannot be null");
        }
        if (locale == null) {
            locale = Locale.ROOT;
        }
        this.fileName = fileName;
        this.fileNameWithoutExtension = FileUtil.getFileNameWithoutExtension(fileName);
        this.locale = locale;
        this.parse();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameWithoutExtension() {
        return this.fileNameWithoutExtension;
    }

    public VideoClassification getClassification() {
        return this.classification;
    }

    public String getName() {
        return this.name;
    }

    public int getYear() {
        return this.year;
    }

    public String getEdition() {
        return this.edition;
    }

    public int getSeason() {
        return this.season;
    }

    public int getEpisode() {
        return this.episode;
    }

    public String getEpisodeName() {
        return this.episodeName;
    }

    public String getPrettifiedName() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank(this.name)) {
            sb.append("Unknown");
        } else {
            sb.append(this.name);
        }
        if (this.season > 0 && this.episode > 0) {
            sb.append(" ").append(this.season).append("-").append(this.episode);
        } else if (this.episode > 0) {
            sb.append(" ").append(this.episode);
        }
        if (this.episode > 0 && StringUtils.isNotBlank(this.episodeName)) {
            sb.append(" ").append(this.episodeName);
        }
        if (this.year > 0 && this.year != this.season) {
            sb.append(" (").append(this.year).append(")");
        }
        if (StringUtils.isNotBlank(this.edition)) {
            sb.append(" ").append(this.edition);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getPrettifiedName();
    }

    protected void parse() {
        if (StringUtils.isBlank(this.fileNameWithoutExtension)) {
            return;
        }
        String tmpName = this.removeGroupNameFromBeginning(this.fileNameWithoutExtension);
        tmpName = this.removeFilenameEndMetadata(tmpName);
        tmpName = tmpName.replaceAll("_", " ");
        if (StringUtils.isBlank(this.fileName)) {
            return;
        }
        Matcher matcher = ANIME_HASH.matcher(tmpName);
        if (matcher.find()) {
            tmpName = matcher.replaceAll("");
        }
        if ((matcher = SERIES_EPISODE_EPISODE.matcher(tmpName)).find()) {
            this.classification = VideoClassification.SERIES;
            this.season = Integer.parseInt(matcher.group(1));
            this.episode = Integer.parseInt(matcher.group(2));
            String[] splitName = SERIES_EPISODE_EPISODE.split(tmpName);
            if (splitName.length > 1) {
                String tmpEpisodeName = splitName[1];
                if ((tmpEpisodeName = this.normalizeSpaces(tmpEpisodeName)).length() > 0) {
                    this.episodeName = this.convertFormattedNameToTitleCase(tmpEpisodeName);
                }
            }
            this.name = this.convertFormattedNameToTitleCase(this.normalizeSpaces(this.removeFilenameEndMetadata(splitName[0])));
            return;
        }
        matcher = SERIES_EPISODE.matcher(tmpName);
        if (matcher.find()) {
            this.classification = VideoClassification.SERIES;
            this.season = Integer.parseInt(matcher.group(1));
            this.episode = Integer.parseInt(matcher.group(2));
            String[] splitName = SERIES_EPISODE.split(tmpName);
            if (splitName.length > 1) {
                String tmpEpisodeName = splitName[1];
                if ((tmpEpisodeName = this.normalizeSpaces(tmpEpisodeName)).length() > 0) {
                    this.episodeName = this.convertFormattedNameToTitleCase(tmpEpisodeName);
                }
            }
            this.name = this.convertFormattedNameToTitleCase(this.normalizeSpaces(this.removeFilenameEndMetadata(splitName[0])));
            return;
        }
        matcher = ANIME_SERIES_EPISODE.matcher(tmpName);
        matcher = SERIES_DATE.matcher(tmpName);
        if (matcher.find()) {
            this.classification = VideoClassification.SERIES;
            this.year = this.season = Integer.parseInt(matcher.group(1));
            this.episode = Integer.parseInt(matcher.group(2) + matcher.group(3));
            String[] splitName = SERIES_DATE.split(tmpName);
            if (splitName.length > 1) {
                String tmpEpisodeName = splitName[1];
                if ((tmpEpisodeName = this.normalizeSpaces(tmpEpisodeName)).length() > 0) {
                    this.episodeName = this.convertFormattedNameToTitleCase(tmpEpisodeName);
                }
            }
            this.name = this.convertFormattedNameToTitleCase(this.normalizeSpaces(this.removeFilenameEndMetadata(splitName[0])));
            return;
        }
        matcher = MOVIE_YEAR.matcher(tmpName);
        if (matcher.find()) {
            this.classification = VideoClassification.MOVIE;
            tmpName = this.extractEdition(tmpName);
            String yearString = matcher.group(2);
            if (StringUtils.isBlank(yearString)) {
                yearString = matcher.group(1);
            }
            this.year = Integer.parseInt(yearString);
            this.name = this.convertFormattedNameToTitleCase(this.splitClean(MOVIE_YEAR, tmpName));
            return;
        }
        matcher = ANIME_SERIES_EPISODE_EPISODE.matcher(tmpName);
        if (matcher.find()) {
            this.classification = VideoClassification.SERIES;
            this.season = StringUtils.isBlank(matcher.group(1)) ? 1 : Integer.parseInt(matcher.group(1));
            this.episode = Integer.parseInt(matcher.group(2));
            String[] splitName = ANIME_SERIES_EPISODE_EPISODE.split(tmpName);
            if (splitName.length > 1) {
                String tmpEpisodeName = splitName[1];
                if ((tmpEpisodeName = this.normalizeSpaces(tmpEpisodeName)).length() > 0) {
                    this.episodeName = this.convertFormattedNameToTitleCase(tmpEpisodeName);
                }
            }
            this.name = this.convertFormattedNameToTitleCase(this.normalizeSpaces(this.removeFilenameEndMetadata(splitName[0])));
            return;
        }
        if (matcher.find()) {
            this.classification = VideoClassification.SERIES;
            this.season = StringUtils.isBlank(matcher.group(1)) ? 1 : Integer.parseInt(matcher.group(1));
            this.episode = Integer.parseInt(matcher.group(2));
            String[] splitName = ANIME_SERIES_EPISODE.split(tmpName);
            if (splitName.length > 1) {
                String tmpEpisodeName = splitName[1];
                if ((tmpEpisodeName = this.normalizeSpaces(tmpEpisodeName)).length() > 0) {
                    this.episodeName = this.convertFormattedNameToTitleCase(tmpEpisodeName);
                }
            }
            this.name = this.convertFormattedNameToTitleCase(this.normalizeSpaces(this.removeFilenameEndMetadata(splitName[0])));
            return;
        }
        this.classification = VideoClassification.MOVIE;
        tmpName = this.extractEdition(tmpName);
        this.name = this.convertFormattedNameToTitleCase(this.normalizeSpaces(this.removeFilenameEndMetadata(tmpName)));
    }

    protected String normalizeSpaces(String name) {
        if (StringUtils.isEmpty(name)) {
            return name;
        }
        String result = name.replaceAll("\\.", " ").replaceAll("\\s+", " ").trim();
        Matcher matcher = LEADING_TRAILING_HYPHEN.matcher(result);
        if (matcher.find()) {
            result = matcher.replaceAll("");
        }
        return result;
    }

    protected String extractEdition(String name) {
        Matcher matcher = COMMON_FILE_EDITIONS.matcher(name);
        if (matcher.find()) {
            Object tmpEdition = matcher.group().replaceAll("\\.", " ");
            if (StringUtils.isNotBlank((CharSequence)(tmpEdition = "(" + WordUtils.capitalizeFully((String)tmpEdition) + ")"))) {
                this.edition = tmpEdition;
            }
            return matcher.replaceAll("");
        }
        return name;
    }

    protected String removeFilenameEndMetadata(String name) {
        return name.replaceAll(COMMON_FILE_ENDS_CASE_SENSITIVE, "").replaceAll("(?i)[\\s\\.]AC3.*|[\\s\\.]REPACK.*|[\\s\\.]480p.*|[\\s\\.]720p.*|[\\s\\.]m-720p.*|[\\s\\.]900p.*|[\\s\\.]1080p.*|[\\s\\.]2160p.*|[\\s\\.]WEB-DL.*|[\\s\\.]HDTV.*|[\\s\\.]DSR.*|[\\s\\.]PDTV.*|[\\s\\.]SDTV.*|[\\s\\.]WS.*|[\\s\\.]HQ.*|[\\s\\.]DVDRip.*|[\\s\\.]TVRiP.*|[\\s\\.]BDRip.*|[\\s\\.]BRRip.*|[\\s\\.]WEBRip.*|[\\s\\.]BluRay.*|[\\s\\.]Blu-ray.*|[\\s\\.]SUBBED.*|[\\s\\.]x264.*|[\\s\\.]Dual[\\s\\.]Audio.*|[\\s\\.]HSBS.*|[\\s\\.]H-SBS.*|[\\s\\.]RERiP.*|[\\s\\.]DIRFIX.*|[\\s\\.]READNFO.*|[\\s\\.]60FPS.*|[\\s\\.]Xvid.*|[\\s\\.]DivX.*|[\\s\\.]DVB.*", "");
    }

    protected String removeGroupNameFromBeginning(String name) {
        if (StringUtils.isBlank(name)) {
            return name;
        }
        if (name.startsWith("[")) {
            Pattern pattern = Pattern.compile("^\\[[^\\]]{0,20}\\][^\\w]*(\\w.*?)\\s*$");
            Matcher matcher = pattern.matcher(name);
            if (matcher.find()) {
                name = matcher.group(1);
            } else if (name.endsWith("]") && (matcher = (pattern = Pattern.compile("^\\[([^\\[\\]]+)\\]\\s*$")).matcher(name)).find()) {
                name = matcher.group(1);
            }
        }
        return name;
    }

    protected String convertFormattedNameToTitleCase(String name) {
        if (StringUtils.isBlank(name)) {
            return name;
        }
        if (name.equals(name.toLowerCase(this.locale))) {
            return FileUtil.convertLowerCaseStringToTitleCase(name);
        }
        return name;
    }

    protected String splitClean(Pattern pattern, String name) {
        if (pattern == null || StringUtils.isBlank(name)) {
            return name;
        }
        String[] splitName = pattern.split(name);
        for (int i = 0; i < splitName.length; ++i) {
            splitName[i] = this.normalizeSpaces(this.removeFilenameEndMetadata(splitName[i]));
        }
        if (splitName[0].length() < 3 && splitName[1].length() > 3) {
            return splitName[1];
        }
        return splitName[0];
    }
}

