/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import net.pms.util.FileUtil;

public class FileNameMetadata {
    private final String movieOrShowName;
    private final Integer year;
    private final String extraInformation;
    private final Integer tvSeasonNumber;
    private final String tvEpisodeName;
    private final String tvEpisodeNumber;
    private final boolean isSample;

    public FileNameMetadata() {
        this(null, null, null, null, null, null, false);
    }

    public FileNameMetadata(String movieOrShowName, String year, String extraInformation, String tvSeason, String tvEpisodeNumbers, String tvEpisodeName, boolean isSample) {
        this.movieOrShowName = movieOrShowName;
        this.year = FileUtil.getYearFromYearString(year);
        this.extraInformation = extraInformation;
        this.tvSeasonNumber = FileUtil.getIntegerFromString(tvSeason);
        this.tvEpisodeNumber = tvEpisodeNumbers;
        this.tvEpisodeName = tvEpisodeName;
        this.isSample = isSample;
    }

    public String getMovieOrShowName() {
        return this.movieOrShowName;
    }

    public Integer getYear() {
        return this.year;
    }

    public String getExtraInformation() {
        return this.extraInformation;
    }

    public boolean isTvEpisode() {
        return this.tvSeasonNumber != null;
    }

    public Integer getTvSeasonNumber() {
        return this.tvSeasonNumber;
    }

    public String getTvEpisodeNumber() {
        return this.tvEpisodeNumber;
    }

    public String getTvEpisodeName() {
        return this.tvEpisodeName;
    }

    public boolean isSample() {
        return this.isSample;
    }
}

