/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Debouncer {
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentHashMap<Object, Future<?>> delayedMap = new ConcurrentHashMap();

    public void debounce(Object key, Runnable runnable, long delay, TimeUnit unit) {
        Future prev = this.delayedMap.put(key, this.scheduler.schedule(() -> {
            try {
                runnable.run();
            }
            finally {
                this.delayedMap.remove(key);
            }
        }, delay, unit));
        if (prev != null) {
            prev.cancel(true);
        }
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
    }
}

