/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeadNodeList
extends ArrayList<Node>
implements NodeList {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DeadNodeList.class);

    public DeadNodeList() {
    }

    public DeadNodeList(int initialCapacity) {
        super(initialCapacity);
    }

    public DeadNodeList(Object nodeList) {
        if (nodeList instanceof Collection) {
            Collection collection = (Collection)nodeList;
            for (Object object : collection) {
                if (object instanceof Node) {
                    Node node = (Node)object;
                    this.add(node);
                    continue;
                }
                LOGGER.error("Can't add \"{}\" to DeadNodeList since {} doesn't implement Node - skipping", object, (Object)(object != null ? object.getClass().getSimpleName() : "null"));
            }
        } else if (nodeList instanceof NodeList || nodeList instanceof Node) {
            Node newNnode;
            Node node = nodeList instanceof Node ? (newNnode = (Node)nodeList) : ((NodeList)nodeList).item(0);
            if (node == null) {
                return;
            }
            do {
                this.add(node.cloneNode(true));
            } while ((node = node.getNextSibling()) != null);
        } else if (nodeList != null) {
            throw new IllegalArgumentException("nodeList must either be a Collection of Nodes or a NodeList");
        }
    }

    @Override
    public Node item(int index) {
        return (Node)this.get(index);
    }

    @Override
    public int getLength() {
        return this.size();
    }
}

