/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import com.github.junrar.volume.FileVolumeManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveFileInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveFileInputStream.class);
    protected final File file;
    protected final String name;
    protected final InputStream inputStream;
    protected final Closeable closeable;

    protected ArchiveFileInputStream(File file, String name, InputStream inputStream, Closeable closeable) {
        this.file = file;
        this.name = name;
        this.inputStream = inputStream;
        this.closeable = closeable;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.closeable != null) {
            this.closeable.close();
        }
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.inputStream.readAllBytes();
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return this.inputStream.readNBytes(len);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.inputStream.readNBytes(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        this.inputStream.skipNBytes(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return this.inputStream.transferTo(out);
    }

    public static ArchiveFileInputStream getZipEntryInputStream(File file, String name) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry ze = zipFile.getEntry(name);
            if (ze != null) {
                return new ArchiveFileInputStream(file, name, zipFile.getInputStream(ze), zipFile);
            }
            LOGGER.error("Zip entry '{}' not found.", (Object)name);
        }
        catch (IOException e) {
            LOGGER.error("ZipEntryInputStream error.", e);
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ArchiveFileInputStream getSevenZipEntryInputStream(File file, String name) {
        IInArchive arc = null;
        try {
            RandomAccessFile rf = new RandomAccessFile(file, "r");
            arc = SevenZip.openInArchive(null, new RandomAccessFileInStream(rf));
            ISimpleInArchive simpleInArchive = arc.getSimpleInterface();
            ISimpleInArchiveItem realItem = null;
            for (ISimpleInArchiveItem item : simpleInArchive.getArchiveItems()) {
                if (!item.getPath().equals(name)) continue;
                realItem = item;
                break;
            }
            if (realItem != null) {
                ISimpleInArchiveItem archiveItem = realItem;
                int bufferSize = (int)Math.max(Math.min(realItem.getSize(), 65536L), 1L);
                PipedInputStream in = new PipedInputStream(bufferSize);
                Runnable r = () -> {
                    try (PipedOutputStream out = new PipedOutputStream(in);){
                        archiveItem.extractSlow(data -> {
                            try {
                                out.write(data);
                            }
                            catch (IOException e) {
                                LOGGER.debug("Caught exception", e);
                                throw new SevenZipException();
                            }
                            return data.length;
                        });
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                };
                new Thread(r).start();
                return new ArchiveFileInputStream(file, name, in, arc);
            }
            LOGGER.error("SevenZip entry '{}' not found.", (Object)name);
        }
        catch (FileNotFoundException | SevenZipException e) {
            LOGGER.debug("Unpack error. Possibly harmless.", (Object)e.getMessage());
        }
        if (arc != null) {
            try {
                arc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ArchiveFileInputStream getRarEntryInputStream(File file, String name) {
        Archive rarFile = null;
        try {
            rarFile = new Archive(new FileVolumeManager(file), null, null);
            FileHeader header = null;
            for (FileHeader fh : rarFile.getFileHeaders()) {
                if (!fh.getFileName().equals(name)) continue;
                header = fh;
                break;
            }
            if (header != null) {
                return new ArchiveFileInputStream(file, name, rarFile.getInputStream(header), rarFile);
            }
            LOGGER.error("Rar entry '{}' not found.", (Object)name);
        }
        catch (RarException | IOException e) {
            LOGGER.error("RarEntryInputStream error: " + e.getMessage());
        }
        if (rarFile != null) {
            try {
                rarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

