/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.transcoding;

import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.ComponentOrientation;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.swing.SwingUtil;
import net.pms.swing.gui.FormLayoutUtil;
import net.pms.swing.gui.UmsFormBuilder;

public class VLCVideo {
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final String COL_SPEC = "left:pref, 3dlu, p, 3dlu, 0:grow";
    private static final String ROW_SPEC = "p, 3dlu, p, 3dlu, p";
    protected static JTextField scale;
    protected static JCheckBox experimentalCodecs;
    protected static JCheckBox audioSyncEnabled;
    protected static JTextField sampleRate;
    protected static JCheckBox sampleRateOverride;

    private VLCVideo() {
    }

    public static JComponent config() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(PMS.getLocale());
        String colSpec = FormLayoutUtil.getColSpec(COL_SPEC, orientation);
        FormLayout layout = new FormLayout(colSpec, ROW_SPEC);
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.EMPTY);
        builder.opaque(false);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Messages.getGuiString("GeneralSettings_SentenceCase"), new Object[0]).at(FormLayoutUtil.flip(cc.xyw(1, 1, 5), colSpec, orientation));
        experimentalCodecs = new JCheckBox(Messages.getGuiString("EnableExperimentalCodecs"), CONFIGURATION.isVlcExperimentalCodecs());
        experimentalCodecs.setContentAreaFilled(false);
        experimentalCodecs.addItemListener(e -> CONFIGURATION.setVlcExperimentalCodecs(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(experimentalCodecs)).at(FormLayoutUtil.flip(cc.xy(1, 3), colSpec, orientation));
        audioSyncEnabled = new JCheckBox(Messages.getGuiString("AvSyncAlternativeMethod"), CONFIGURATION.isVlcAudioSyncEnabled());
        audioSyncEnabled.setContentAreaFilled(false);
        audioSyncEnabled.addItemListener(e -> CONFIGURATION.setVlcAudioSyncEnabled(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(audioSyncEnabled)).at(FormLayoutUtil.flip(cc.xy(1, 5), colSpec, orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(orientation);
        return panel;
    }
}

