/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.transcoding;

import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.swing.SwingUtil;
import net.pms.swing.gui.UmsFormBuilder;

public class AviSynthMEncoder {
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static JTextArea textArea;

    private AviSynthMEncoder() {
    }

    public static JComponent config() {
        FormLayout layout = new FormLayout("left:pref, 0:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 12dlu, p, 3dlu, 0:grow");
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.border(Paddings.EMPTY);
        builder.opaque(false);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Messages.getGuiString("GeneralSettings_SentenceCase"), new Object[0]).at(cc.xyw(2, 1, 1));
        JCheckBox multithreading = new JCheckBox(Messages.getGuiString("EnableMultithreading"), CONFIGURATION.getAvisynthMultiThreading());
        multithreading.setContentAreaFilled(false);
        multithreading.addItemListener(e -> CONFIGURATION.setAvisynthMultiThreading(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(multithreading)).at(cc.xy(2, 3));
        JCheckBox interframe = new JCheckBox(Messages.getGuiString("EnableTrueMotion"), CONFIGURATION.getAvisynthInterFrame());
        interframe.setContentAreaFilled(false);
        interframe.addActionListener(e -> {
            CONFIGURATION.setAvisynthInterFrame(interframe.isSelected());
            if (CONFIGURATION.getAvisynthInterFrame()) {
                JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(interframe), Messages.getGuiString("ThisFeatureVeryCpuintensive"), Messages.getGuiString("Information"), 1);
            }
        });
        builder.add(SwingUtil.getPreferredSizeComponent(interframe)).at(cc.xy(2, 5));
        JCheckBox interframegpu = new JCheckBox(Messages.getGuiString("EnableGpuUseTrueMotion"), CONFIGURATION.getAvisynthInterFrameGPU());
        interframegpu.setContentAreaFilled(false);
        interframegpu.addItemListener(e -> CONFIGURATION.setAvisynthInterFrameGPU(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(interframegpu)).at(cc.xy(2, 7));
        JCheckBox convertfps = new JCheckBox(Messages.getGuiString("EnableAvisynthVariableFramerate"), CONFIGURATION.getAvisynthConvertFps());
        convertfps.setContentAreaFilled(false);
        convertfps.addItemListener(e -> CONFIGURATION.setAvisynthConvertFps(e.getStateChange() == 1));
        builder.add(SwingUtil.getPreferredSizeComponent(convertfps)).at(cc.xy(2, 9));
        String aviSynthScriptInstructions = Messages.getGuiString("AvisynthScriptFullyCustomizable") + Messages.getGuiString("TheFollowingVariablesAvailable") + Messages.getGuiString("MovieCompleteDirectshowsource") + Messages.getGuiString("SubCompleteSubtitlesInstruction") + Messages.getGuiString("MoviefilenameVideoFilename");
        JTextArea aviSynthScriptInstructionsContainer = new JTextArea(aviSynthScriptInstructions);
        aviSynthScriptInstructionsContainer.setEditable(false);
        aviSynthScriptInstructionsContainer.setBorder(BorderFactory.createEtchedBorder());
        aviSynthScriptInstructionsContainer.setBackground(new Color(255, 255, 192));
        aviSynthScriptInstructionsContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(130, 135, 144)), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
        builder.add(aviSynthScriptInstructionsContainer).at(cc.xy(2, 11));
        String clip = CONFIGURATION.getAvisynthScript();
        if (clip == null) {
            clip = "";
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(clip, "\u0001");
        int i = 0;
        while (st.hasMoreTokens()) {
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(st.nextToken());
            ++i;
        }
        textArea = new JTextArea(sb.toString());
        textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                StringBuilder sb = new StringBuilder();
                StringTokenizer st = new StringTokenizer(textArea.getText(), "\n");
                int i = 0;
                while (st.hasMoreTokens()) {
                    if (i > 0) {
                        sb.append("\u0001");
                    }
                    sb.append(st.nextToken());
                    ++i;
                }
                CONFIGURATION.setAvisynthScript(sb.toString());
            }
        });
        JScrollPane pane = new JScrollPane(textArea, 20, 30);
        pane.setPreferredSize(new Dimension(500, 350));
        builder.add(pane).at(cc.xy(2, 13));
        CONFIGURATION.addConfigurationListener(event -> {
            if (event.getPropertyName() == null) {
                return;
            }
            if (!event.isBeforeUpdate() && interframegpu.isEnabled() != CONFIGURATION.isGPUAcceleration()) {
                interframegpu.setEnabled(CONFIGURATION.isGPUAcceleration());
            }
        });
        return builder.getPanel();
    }
}

