/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing;

import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.pms.Messages;
import net.pms.configuration.UmsConfiguration;
import net.pms.configuration.sharedcontent.SharedContentConfiguration;
import net.pms.swing.SwingUtil;
import net.pms.swing.components.RestrictedFileSystemView;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wizard {
    private static final Logger LOGGER = LoggerFactory.getLogger(Wizard.class);

    private Wizard() {
    }

    public static void run(UmsConfiguration configuration) {
        ImageIcon icon = new ImageIcon(SwingUtil.getAppIconImage());
        int numberOfQuestions = 5;
        int currentQuestionNumber = 0;
        String status = Messages.getGuiString("ConfigurationWizardQuestion") + " %d " + Messages.getGuiString("Of") + " " + numberOfQuestions;
        Object[] okOptions = new Object[]{Messages.getGuiString("OK")};
        Object[] yesNoOptions = new Object[]{Messages.getGuiString("Yes"), Messages.getGuiString("No")};
        Object[] defaultOptions = new Object[]{Messages.getGuiString("YesRunTheWizard"), Messages.getGuiString("NoUseTheDefaults")};
        int whetherToSelectDefaultOptions = JOptionPane.showOptionDialog(null, Messages.getGuiString("WouldYouLikeRunWizard"), String.format(status, ++currentQuestionNumber), 0, 3, icon, defaultOptions, defaultOptions[1]);
        if (whetherToSelectDefaultOptions == 1 || whetherToSelectDefaultOptions == -1) {
            configuration.setAutomaticMaximumBitrate(true);
            configuration.setMPEG2MainSettings("Automatic (Wired)");
            configuration.setx264ConstantRateFactor("Automatic (Wired)");
            configuration.setHideAdvancedOptions(true);
            configuration.setScanSharedFoldersOnStartup(true);
        } else {
            int whetherToHideAdvancedOptions = JOptionPane.showOptionDialog(null, Messages.getGuiString("ShouldUmsHideAdvancedOptions"), String.format(status, ++currentQuestionNumber), 0, 3, icon, yesNoOptions, yesNoOptions[0]);
            if (whetherToHideAdvancedOptions == 0) {
                configuration.setHideAdvancedOptions(true);
            } else if (whetherToHideAdvancedOptions == 1) {
                configuration.setHideAdvancedOptions(false);
            }
            int whetherToScanSharedFolders = JOptionPane.showOptionDialog(null, Messages.getGuiString("ShouldUmsScanFoldersStartup"), String.format(status, ++currentQuestionNumber), 0, 3, icon, yesNoOptions, yesNoOptions[0]);
            if (whetherToScanSharedFolders == 0) {
                configuration.setScanSharedFoldersOnStartup(true);
            } else if (whetherToScanSharedFolders == 1) {
                configuration.setScanSharedFoldersOnStartup(false);
            }
            JOptionPane.showOptionDialog(null, Messages.getGuiString("FinallyChooseFolderShare"), String.format(status, ++currentQuestionNumber), 0, 1, icon, okOptions, okOptions[0]);
            try {
                SwingUtilities.invokeAndWait(() -> {
                    JFileChooser chooser;
                    try {
                        chooser = new JFileChooser();
                    }
                    catch (Exception ee) {
                        chooser = new JFileChooser(new RestrictedFileSystemView());
                    }
                    chooser.setFileSelectionMode(1);
                    chooser.setDialogTitle(Messages.getGuiString("FinallyChooseFolderShare"));
                    chooser.setMultiSelectionEnabled(false);
                    if (chooser.showSaveDialog(null) == 0) {
                        SharedContentConfiguration.addFolderShared(chooser.getSelectedFile());
                    }
                });
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Error when saving folders: ", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        configuration.setRunWizard(false);
        try {
            configuration.save();
        }
        catch (ConfigurationException e) {
            LOGGER.error("Error when saving changed configuration: ", e);
        }
    }
}

