/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.StyleSheet;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.platform.PlatformUtils;
import net.pms.swing.SwingUtil;
import net.pms.swing.components.CustomHTMLEditorKit;
import net.pms.swing.components.KeyedComboBoxModel;
import net.pms.util.Languages;
import net.pms.util.ProcessUtil;
import net.pms.util.StringUtil;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageSelection {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageSelection.class);
    private final Component parentComponent;
    private final JPanel rootPanel = new JPanel();
    private final JPanel selectionPanel = new JPanel();
    private final JPanel languagePanel = new JPanel();
    private final JButton selectButton = new JButton();
    private final JButton applyButton = new JButton();
    private final TitledBorder selectionPanelBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1));
    private final TitledBorder infoTextBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1));
    private final JTextArea descriptionText = new JTextArea();
    private final JTextArea warningText = new JTextArea();
    private final JEditorPane infoText = new JEditorPane();
    private final KeyedComboBoxModel<String, String> keyedModel = new KeyedComboBoxModel();
    private JOptionPane pane;
    private Locale locale;
    private JDialog dialog;
    private boolean aborted = false;
    private boolean rebootOnChange;

    public LanguageSelection(Component parentComponent, Locale initialLocale, boolean rebootOnChange) {
        this.parentComponent = parentComponent;
        if (initialLocale == null) {
            throw new IllegalArgumentException("initialLocale cannot be null");
        }
        this.locale = initialLocale;
        this.rebootOnChange = rebootOnChange;
    }

    public void show() {
        if (PMS.isHeadless()) {
            LOGGER.info("No language is configured and the language selection dialog is unavailable in headless mode");
            LOGGER.info("Defaulting to OS locale {}", (Object)Locale.getDefault().getDisplayName());
            PMS.setLocale(Locale.getDefault());
        } else {
            this.pane = new JOptionPane(this.buildComponent(), -1, 1, null, new JButton[]{this.applyButton, this.selectButton}, this.selectButton);
            this.pane.setComponentOrientation(ComponentOrientation.getOrientation(this.locale));
            this.dialog = this.pane.createDialog(this.parentComponent, PMS.NAME);
            this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.dialog.setIconImage(SwingUtil.getAppIconImage());
            this.setStrings();
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(this.parentComponent);
            this.dialog.setVisible(true);
            this.dialog.dispose();
            if (this.pane.getValue() == null) {
                this.aborted = true;
            } else if (!((String)this.pane.getValue()).equals(PMS.getConfiguration().getLanguageRawString())) {
                if (this.rebootOnChange) {
                    int response = JOptionPane.showConfirmDialog(this.parentComponent, String.format(this.buildString("XNeedsRestartedApplyChanges", true), PMS.NAME, PMS.NAME), this.buildString("Confirm"), 1);
                    if (response != 2) {
                        PMS.getConfiguration().setLanguage((String)this.pane.getValue());
                        if (response == 0) {
                            try {
                                PMS.getConfiguration().save();
                            }
                            catch (ConfigurationException e) {
                                LOGGER.error("Error while saving configuration: {}", (Object)e.getMessage());
                                LOGGER.trace("", e);
                            }
                            ProcessUtil.reboot();
                        }
                    }
                } else {
                    PMS.getConfiguration().setLanguage((String)this.pane.getValue());
                }
            }
        }
    }

    private String buildString(String key, boolean paragraph, boolean html) {
        String rootString;
        Object result = Messages.getString(key, this.locale);
        if (!((String)result).equals(rootString = Messages.getRootString(key))) {
            result = paragraph && html ? (String)result + "<br><br>" + rootString : (paragraph ? (String)result + "\n\n" + rootString : (String)result + String.format(" (%s)", rootString));
        }
        return (html ? "<html>" : "") + (String)result + (html ? "</html>" : "");
    }

    private String buildString(String key, boolean paragraph) {
        return this.buildString(key, paragraph, false);
    }

    private String buildString(String key) {
        return this.buildString(key, false, false);
    }

    private void setStrings() {
        String descriptionMessage;
        this.dialog.setLocale(this.locale);
        this.dialog.applyComponentOrientation(ComponentOrientation.getOrientation(this.locale));
        this.selectionPanelBorder.setTitle(this.buildString("SelectLanguage"));
        this.selectionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(this.selectionPanelBorder, BorderFactory.createEmptyBorder(10, 5, 10, 5))));
        String string = descriptionMessage = this.parentComponent != null ? "PleaseSelectLanguageForX" : "PleaseSelectLanguageX";
        if (Messages.getString(descriptionMessage, this.locale).equals(Messages.getRootString(descriptionMessage))) {
            if (this.parentComponent != null) {
                this.descriptionText.setText(String.format(Messages.getString(descriptionMessage, this.locale), PMS.NAME));
            } else {
                this.descriptionText.setText(String.format(Messages.getString(descriptionMessage, this.locale), PMS.NAME, Messages.getString("GeneralSettings", this.locale)));
            }
        } else if (this.parentComponent != null) {
            this.descriptionText.setText(String.format(this.buildString(descriptionMessage, true), PMS.NAME, PMS.NAME));
        } else {
            this.descriptionText.setText(String.format(this.buildString(descriptionMessage, true), PMS.NAME, Messages.getString("GeneralSettings", this.locale), PMS.NAME, Messages.getRootString("GeneralSettings")));
        }
        float avgCharWidth = SwingUtil.getComponentAverageCharacterWidth(this.descriptionText);
        int textWidth = Math.round(avgCharWidth * 100.0f);
        this.selectButton.setMargin(new Insets(Math.round(0.5f * avgCharWidth), Math.round(4.0f * avgCharWidth), Math.round(0.5f * avgCharWidth), Math.round(4.0f * avgCharWidth)));
        this.applyButton.setMargin(new Insets(Math.round(0.5f * avgCharWidth), Math.round(4.0f * avgCharWidth), Math.round(0.5f * avgCharWidth), Math.round(4.0f * avgCharWidth)));
        this.descriptionText.setPreferredSize(SwingUtil.getWordWrappedTextDimension(this.descriptionText, textWidth));
        this.keyedModel.setData((String[])Languages.getLanguageTags(this.locale), (String[])Languages.getLanguageNames(this.locale));
        String languageTag = Languages.toLanguageTag(this.locale);
        int idx = languageTag != null ? this.keyedModel.findKeyIndex(languageTag) : -1;
        if (idx < 0) {
            Locale tmpLocale = Languages.toLocale(this.locale);
            if (tmpLocale == null && (tmpLocale = Languages.toLocale(new Locale.Builder().setLanguage(this.locale.getLanguage()).setRegion(this.locale.getCountry()).build())) == null && (tmpLocale = Languages.toLocale(new Locale.Builder().setLanguage(this.locale.getLanguage()).build())) == null) {
                tmpLocale = Languages.toLocale("en-US");
            }
            languageTag = Languages.toLanguageTag(tmpLocale);
        }
        this.keyedModel.setSelectedKey(languageTag);
        if (this.keyedModel.getSelectedKey() != null && Languages.warnCoverage(this.keyedModel.getSelectedKey())) {
            String localizedLanguageName = Messages.getString("Language." + this.keyedModel.getSelectedKey(), this.locale);
            if (Messages.getString("XIsOnlyPercentTranslated", this.locale).equals(Messages.getRootString("XIsOnlyPercentTranslated"))) {
                this.warningText.setText(String.format(Messages.getString("XIsOnlyPercentTranslated", this.locale), localizedLanguageName, Languages.getLanguageCoverage(this.keyedModel.getSelectedKey()), localizedLanguageName));
            } else {
                int coverage = Languages.getLanguageCoverage(this.keyedModel.getSelectedKey());
                String rootLanguageName = Messages.getRootString("Language." + this.keyedModel.getSelectedKey());
                this.warningText.setText(String.format(this.buildString("XIsOnlyPercentTranslated", true), localizedLanguageName, coverage, localizedLanguageName, rootLanguageName, coverage, rootLanguageName));
            }
        } else {
            this.warningText.setText("");
        }
        this.warningText.setPreferredSize(SwingUtil.getWordWrappedTextDimension(this.warningText, textWidth));
        this.infoTextBorder.setTitle(this.buildString("AboutTranslations"));
        this.infoText.setText(String.format(this.buildString("IfYourLanguageMissingIncomplete", true, true), "https://crowdin.com/project/universalmediaserver", "https://crowdin.com/project/universalmediaserver"));
        this.infoText.setPreferredSize(SwingUtil.getWordWrappedTextDimension(this.infoText, textWidth, StringUtil.stripHTML(this.infoText.getText())));
        this.selectButton.setText(this.buildString("Select"));
        this.applyButton.setText(this.buildString("Apply"));
    }

    private JComponent buildComponent() {
        Color backgroundColor = UIManager.getColor("Panel.background");
        this.rootPanel.setLayout(new BoxLayout(this.rootPanel, 3));
        this.selectionPanelBorder.setTitle(" ");
        this.selectionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(this.selectionPanelBorder, BorderFactory.createEmptyBorder(10, 5, 10, 5))));
        this.selectionPanel.setLayout(new BoxLayout(this.selectionPanel, 3));
        this.descriptionText.setEditable(false);
        this.descriptionText.setBackground(backgroundColor);
        this.descriptionText.setFocusable(false);
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setWrapStyleWord(true);
        this.descriptionText.setBorder(BorderFactory.createEmptyBorder(5, 15, 10, 15));
        this.selectionPanel.add(this.descriptionText);
        JComboBox jLanguage = new JComboBox(this.keyedModel);
        jLanguage.setEditable(false);
        jLanguage.setPreferredSize(new Dimension(50, jLanguage.getPreferredSize().height));
        jLanguage.addActionListener(new LanguageComboBoxActionListener());
        this.languagePanel.setLayout(new BoxLayout(this.languagePanel, 3));
        this.languagePanel.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        this.languagePanel.add(jLanguage);
        this.selectionPanel.add(this.languagePanel);
        this.warningText.setEditable(false);
        this.warningText.setFocusable(false);
        this.warningText.setBackground(backgroundColor);
        this.warningText.setFont(this.warningText.getFont().deriveFont(1));
        this.warningText.setLineWrap(true);
        this.warningText.setWrapStyleWord(true);
        this.warningText.setBorder(BorderFactory.createEmptyBorder(5, 15, 0, 15));
        this.selectionPanel.add(this.warningText);
        this.infoTextBorder.setTitle(" ");
        this.infoText.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(this.infoTextBorder, BorderFactory.createEmptyBorder(15, 20, 20, 20))));
        this.infoText.setEditable(false);
        this.infoText.setFocusable(false);
        this.infoText.setBackground(backgroundColor);
        this.infoText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        CustomHTMLEditorKit editorKit = new CustomHTMLEditorKit();
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule("a { color: #0000EE; text-decoration:underline; }");
        editorKit.setStyleSheet(styleSheet);
        this.infoText.setEditorKit(editorKit);
        this.infoText.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                boolean error;
                if (Desktop.isDesktopSupported()) {
                    error = !PlatformUtils.INSTANCE.browseURI(e.getDescription());
                } else {
                    LOGGER.warn("Desktop is not supported, the clicked translation page link can't be opened");
                    error = true;
                }
                if (error) {
                    JOptionPane.showOptionDialog(this.dialog, String.format(this.buildString("CouldNotOpenHyperlink", true), "https://crowdin.com/project/universalmediaserver"), this.buildString("Error"), -1, 0, null, null, null);
                }
            }
        });
        this.rootPanel.add(this.selectionPanel);
        this.rootPanel.add(this.infoText);
        this.applyButton.addActionListener(new ApplyButtonActionListener());
        this.applyButton.setActionCommand("apply");
        this.selectButton.addActionListener(new SelectButtonActionListener());
        this.selectButton.setActionCommand("select");
        return this.rootPanel;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    private class LanguageComboBoxActionListener
    implements ActionListener {
        private LanguageComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("comboBoxChanged") && LanguageSelection.this.keyedModel.getSelectedKey() != null) {
                if (Languages.toLocale(LanguageSelection.this.keyedModel.getSelectedKey()).equals(LanguageSelection.this.locale)) {
                    LanguageSelection.this.applyButton.setEnabled(false);
                    LanguageSelection.this.rootPanel.getRootPane().setDefaultButton(LanguageSelection.this.selectButton);
                } else {
                    LanguageSelection.this.applyButton.setEnabled(true);
                    LanguageSelection.this.rootPanel.getRootPane().setDefaultButton(LanguageSelection.this.applyButton);
                }
            }
        }
    }

    private class ApplyButtonActionListener
    implements ActionListener {
        private ApplyButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("apply") && LanguageSelection.this.keyedModel.getSelectedKey() != null) {
                LanguageSelection.this.locale = Languages.toLocale(LanguageSelection.this.keyedModel.getSelectedKey());
                LanguageSelection.this.setStrings();
                LanguageSelection.this.dialog.pack();
                LanguageSelection.this.dialog.setLocationRelativeTo(LanguageSelection.this.parentComponent);
                LanguageSelection.this.dialog.repaint();
                LanguageSelection.this.applyButton.setEnabled(false);
                LanguageSelection.this.rootPanel.getRootPane().setDefaultButton(LanguageSelection.this.selectButton);
            }
        }
    }

    private class SelectButtonActionListener
    implements ActionListener {
        private SelectButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("select") && LanguageSelection.this.keyedModel.getSelectedKey() != null) {
                LanguageSelection.this.pane.setValue(LanguageSelection.this.keyedModel.getSelectedKey());
            }
        }
    }
}

