/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.item;

import net.pms.Messages;
import net.pms.renderers.Renderer;
import net.pms.store.item.VirtualVideoAction;

public abstract class VirtualVideoActionLocalized
extends VirtualVideoAction {
    private final String i18nName;
    private final String[] formatStrings;

    protected VirtualVideoActionLocalized(Renderer renderer, String i18nName, boolean enabled, String enabledIconOverride) {
        this(renderer, i18nName, enabled, enabledIconOverride, (String[])null);
    }

    protected VirtualVideoActionLocalized(Renderer renderer, String i18nName, boolean enabled, String enabledIconOverride, String formatString) {
        this(renderer, i18nName, enabled, enabledIconOverride, new String[]{formatString});
    }

    protected VirtualVideoActionLocalized(Renderer renderer, String i18nName, boolean enabled, String enabledIconOverride, String[] formatStrings) {
        super(renderer, null, enabled, enabledIconOverride);
        this.i18nName = i18nName;
        this.formatStrings = formatStrings != null && formatStrings.length != 0 && formatStrings[0] != null ? formatStrings : null;
        if (i18nName != null) {
            this.name = String.format(Messages.getString(i18nName), this.formatStrings);
        }
    }

    @Override
    public String getSystemName() {
        if (this.i18nName != null) {
            if (this.formatStrings != null && this.formatStrings.length > 0 && this.formatStrings[0] != null) {
                return this.i18nName + "|" + String.join((CharSequence)"|", this.formatStrings);
            }
            return this.i18nName;
        }
        return this.getName();
    }

    @Override
    public String getLocalizedDisplayName(String lang) {
        if (this.i18nName != null) {
            return "i18n@" + this.getSystemName();
        }
        return this.getDisplayName();
    }
}

