/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.item;

import java.io.IOException;
import java.io.InputStream;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.media.MediaInfo;
import net.pms.network.HTTPResource;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;

public class FeedItem
extends StoreItem {
    private final String title;
    private final String itemURL;
    private final String thumbURL;
    private long length;

    public FeedItem(Renderer renderer, String title, String itemURL, String thumbURL, MediaInfo media, int type) {
        super(renderer, type);
        this.title = title;
        this.itemURL = itemURL;
        this.thumbURL = thumbURL;
        this.setMediaInfo(media);
    }

    @Override
    public String getThumbnailURL(DLNAImageProfile profile) {
        if (this.thumbURL == null) {
            return null;
        }
        return super.getThumbnailURL(profile);
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        return DLNAThumbnailInputStream.toThumbnailInputStream(HTTPResource.downloadAndSend(this.thumbURL, true));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream i = HTTPResource.downloadAndSend(this.itemURL, true);
        if (i != null) {
            this.length = i.available();
        }
        return i;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public String getSystemName() {
        return this.itemURL;
    }

    @Override
    public boolean isValid() {
        this.resolveFormat();
        return this.getFormat() != null;
    }
}

