/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import net.pms.database.MediaDatabase;
import net.pms.media.audio.metadata.DoubleRecordFilter;
import net.pms.media.audio.metadata.MusicBrainzAlbum;
import net.pms.renderers.Renderer;
import net.pms.store.DbIdMediaType;
import net.pms.store.DbIdResourceLocator;
import net.pms.store.DbIdTypeAndIdent;
import net.pms.store.StoreResource;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.container.MusicBrainzAlbumFolder;
import net.pms.store.container.MusicBrainzPersonFolder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualFolderDbId
extends LocalizedStoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualFolderDbId.class);
    private final DbIdTypeAndIdent typeIdent;

    public VirtualFolderDbId(Renderer renderer, String i18nName, DbIdTypeAndIdent typeIdent) {
        super(renderer, i18nName, null);
        this.typeIdent = typeIdent;
        this.setId(typeIdent.toString());
    }

    @Override
    public boolean isDiscovered() {
        return false;
    }

    @Override
    public String getSystemName() {
        return this.typeIdent.toString();
    }

    public String getMediaIdent() {
        return this.typeIdent.ident;
    }

    public DbIdMediaType getMediaType() {
        return this.typeIdent.type;
    }

    public DbIdTypeAndIdent getMediaTypeIdent() {
        return this.typeIdent;
    }

    public String getMediaTypeUclass() {
        return this.typeIdent.type.uclass;
    }

    @Override
    public void discoverChildren() {
        this.doRefreshChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void doRefreshChildren() {
        block98: {
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    try (Statement statement = connection.createStatement();){
                        ArrayList<File> filesListFromDb = null;
                        this.getChildren().clear();
                        switch (this.typeIdent.type) {
                            case TYPE_ALBUM: {
                                String sql = String.format("SELECT FILES.FILENAME, FILES.ID, FILES.MODIFIED FROM FILES LEFT OUTER JOIN AUDIO_METADATA ON FILES.ID = AUDIO_METADATA.FILEID WHERE ( FILES.FORMAT_TYPE = 1  AND  AUDIO_METADATA.ALBUM = '%s')", StringEscapeUtils.escapeSql(this.typeIdent.ident));
                                if (LOGGER.isTraceEnabled()) {
                                    LOGGER.trace(String.format("SQL AUDIO-ALBUM : %s", sql));
                                }
                                try (ResultSet resultSet = statement.executeQuery(sql);){
                                    filesListFromDb = new ArrayList();
                                    while (resultSet.next()) {
                                        filesListFromDb.add(new File(resultSet.getString("FILENAME")));
                                    }
                                    break;
                                }
                            }
                            case TYPE_MUSICBRAINZ_RECORDID: {
                                ResultSet resultSet;
                                String sql;
                                if (StringUtils.isAllBlank(this.typeIdent.ident)) {
                                    LOGGER.debug("collecting all music albums having a musicBrainzId identifier ...");
                                    sql = "SELECT DISTINCT ON (MBID_RECORD) MBID_RECORD, AUDIO_METADATA.ALBUM, AUDIO_METADATA.GENRE, AUDIO_METADATA.ARTIST, AUDIO_METADATA.MEDIA_YEAR FROM AUDIO_METADATA WHERE MBID_RECORD IS NOT NULL";
                                    if (LOGGER.isTraceEnabled()) {
                                        LOGGER.trace(String.format("SQL TYPE_MUSICBRAINZ_RECORDID : %s", sql));
                                    }
                                    try {
                                        resultSet = statement.executeQuery(sql);
                                        try {
                                            while (resultSet.next()) {
                                                MusicBrainzAlbum mbAlbum = new MusicBrainzAlbum(resultSet.getString("MBID_RECORD"), resultSet.getString("ALBUM"), resultSet.getString("ARTIST"), Integer.toString(resultSet.getInt("MEDIA_YEAR")), resultSet.getString("GENRE"));
                                                this.addChild(new MusicBrainzAlbumFolder(this.renderer, mbAlbum));
                                            }
                                        }
                                        finally {
                                            if (resultSet != null) {
                                                resultSet.close();
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        LOGGER.error("Error in SQL : " + sql, e);
                                    }
                                    break;
                                }
                                LOGGER.debug("collecting musicBrainz album {}", (Object)this.typeIdent.toString());
                                sql = String.format("SELECT FILES.FILENAME, AUDIO_METADATA.MBID_TRACK, FILES.ID, AUDIO_METADATA.ALBUM FROM FILES LEFT OUTER JOIN AUDIO_METADATA ON FILES.ID = AUDIO_METADATA.FILEID WHERE ( FILES.FORMAT_TYPE = 1 and AUDIO_METADATA.MBID_RECORD = '%s' ) ORDER BY AUDIO_METADATA.MBID_TRACK", StringEscapeUtils.escapeSql(this.typeIdent.ident));
                                if (LOGGER.isTraceEnabled()) {
                                    LOGGER.trace(String.format("SQL TYPE_MUSICBRAINZ_RECORDID : %s", sql));
                                }
                                try {
                                    resultSet = statement.executeQuery(sql);
                                    try {
                                        filesListFromDb = new ArrayList();
                                        Object lastUuidTrack = "";
                                        while (resultSet.next()) {
                                            this.setName(resultSet.getString("AUDIO_METADATA.ALBUM"));
                                            String currentUuidTrack = resultSet.getString("MBID_TRACK");
                                            if (currentUuidTrack.equals(lastUuidTrack)) continue;
                                            lastUuidTrack = currentUuidTrack;
                                            filesListFromDb.add(new File(resultSet.getString("FILENAME")));
                                        }
                                    }
                                    finally {
                                        if (resultSet != null) {
                                            resultSet.close();
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Error in SQL : " + sql, e);
                                }
                                break;
                            }
                            case TYPE_MYMUSIC_ALBUM: {
                                this.clearChildren();
                                String sql = "SELECT DISTINCT ON (MBID_RELEASE) MUSIC_BRAINZ_RELEASE_LIKE.MBID_RELEASE, AUDIO_METADATA.ALBUM, AUDIO_METADATA.GENRE, AUDIO_METADATA.ARTIST, AUDIO_METADATA.MEDIA_YEAR FROM MUSIC_BRAINZ_RELEASE_LIKE JOIN AUDIO_METADATA ON MUSIC_BRAINZ_RELEASE_LIKE.MBID_RELEASE = AUDIO_METADATA.MBID_RECORD;";
                                if (LOGGER.isTraceEnabled()) {
                                    LOGGER.trace(String.format("SQL TYPE_MYMUSIC_ALBUM : %s", sql));
                                }
                                DoubleRecordFilter filter = new DoubleRecordFilter();
                                try (ResultSet resultSet = statement.executeQuery(sql);){
                                    while (resultSet.next()) {
                                        filter.addAlbum(this.generateMusicBrainzAlbum(resultSet));
                                    }
                                    for (MusicBrainzAlbum album : filter.getUniqueAlbumSet()) {
                                        MusicBrainzAlbumFolder albumFolder = new MusicBrainzAlbumFolder(this.renderer, album);
                                        this.addChild(albumFolder);
                                    }
                                    break;
                                }
                            }
                            case TYPE_PERSON_ALL_FILES: {
                                String sql = VirtualFolderDbId.personAllFilesSql(this.typeIdent);
                                if (LOGGER.isTraceEnabled()) {
                                    LOGGER.trace(String.format("SQL PERSON : %s", sql));
                                }
                                try (ResultSet resultSet = statement.executeQuery(sql);){
                                    filesListFromDb = new ArrayList();
                                    while (resultSet.next()) {
                                        filesListFromDb.add(new File(resultSet.getString("FILENAME")));
                                    }
                                    break;
                                }
                            }
                            case TYPE_PERSON_ALBUM: {
                                String sql = VirtualFolderDbId.personAlbumSql(this.typeIdent);
                                try (ResultSet resultSet = statement.executeQuery(sql);){
                                    while (resultSet.next()) {
                                        if (resultSet.getString("MBID_RECORD") != null) {
                                            this.addChild(new MusicBrainzAlbumFolder(this.renderer, this.generateMusicBrainzAlbum(resultSet)));
                                            continue;
                                        }
                                        StoreResource sr = DbIdResourceLocator.getAlbumFromMediaLibrary(this.renderer, this.typeIdent.ident);
                                        if (sr == null) continue;
                                        this.addChild(sr);
                                    }
                                    break;
                                }
                            }
                            case TYPE_PERSON_ALBUM_FILES: {
                                String sql = VirtualFolderDbId.personAlbumFileSql(this.typeIdent);
                                try (ResultSet resultSet = statement.executeQuery(sql);){
                                    filesListFromDb = new ArrayList<File>();
                                    while (resultSet.next()) {
                                        filesListFromDb.add(new File(resultSet.getString("FILENAME")));
                                    }
                                    break;
                                }
                            }
                            case TYPE_PERSON: 
                            case TYPE_PERSON_COMPOSER: 
                            case TYPE_PERSON_CONDUCTOR: 
                            case TYPE_PERSON_ALBUMARTIST: {
                                Object name;
                                ResultSet resultSet;
                                String sql;
                                if (StringUtils.isAllBlank(this.typeIdent.ident)) {
                                    sql = String.format("SELECT ID, NAME FROM STORE_IDS WHERE PARENT_ID = %s AND name like '%s%s%%'", this.getLongId(), "$DBID$", this.typeIdent.type.dbidPrefix);
                                    LOGGER.debug("All person Folder sql : {}", (Object)sql);
                                    try {
                                        resultSet = statement.executeQuery(sql);
                                        try {
                                            while (resultSet.next()) {
                                                name = resultSet.getString("NAME");
                                                LOGGER.debug("person name is : {}", name);
                                                DbIdTypeAndIdent tiPerson = new DbIdTypeAndIdent(this.typeIdent.type, ((String)name).substring(((String)name).lastIndexOf("$") + 1));
                                                MusicBrainzPersonFolder person = new MusicBrainzPersonFolder(this.renderer, tiPerson.getIdentUnprefixed(), tiPerson);
                                                this.addChild(person);
                                                person.discoverChildren();
                                            }
                                        }
                                        finally {
                                            if (resultSet != null) {
                                                resultSet.close();
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        LOGGER.error("TYPE_PERSON, TYPE_PERSON_COMPOSER, TYPE_PERSON_CONDUCTOR, TYPE_PERSON_ALBUMARTIST", e);
                                    }
                                    break;
                                }
                                LOGGER.debug("Person {}", (Object)this.typeIdent.ident);
                                name = this;
                                if (name instanceof MusicBrainzPersonFolder) {
                                    MusicBrainzPersonFolder person = (MusicBrainzPersonFolder)name;
                                    person.discoverChildren();
                                    break;
                                }
                                LOGGER.warn("unknown folder type.");
                                break;
                            }
                            case TYPE_FOLDER: {
                                StoreResource res = DbIdResourceLocator.getLibraryResourceFolder(this.renderer, this.typeIdent.toString());
                                if (res == null) break;
                                this.addChild(res);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown Type");
                            }
                        }
                        if (filesListFromDb != null) {
                            for (File file : filesListFromDb) {
                                if (this.renderer.hasShareAccess(file)) {
                                    StoreResource sr = this.renderer.getMediaStore().createResourceFromFile(file);
                                    if (sr != null) {
                                        this.addChild(sr);
                                        continue;
                                    }
                                    LOGGER.trace("createResourceFromFile has failed for {}", (Object)file);
                                    continue;
                                }
                                LOGGER.debug("renderer has no share access to resource {}", (Object)file.getAbsolutePath());
                            }
                        }
                        break block98;
                    }
                }
                LOGGER.error("database not available !");
            }
            catch (SQLException e) {
                LOGGER.warn("getLibraryResourceByDBID", e);
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
        this.sortChildrenIfNeeded();
    }

    private MusicBrainzAlbum generateMusicBrainzAlbum(ResultSet resultSet) throws SQLException {
        return new MusicBrainzAlbum(resultSet.getString("MBID_RELEASE"), resultSet.getString("ALBUM"), resultSet.getString("ARTIST"), Integer.toString(resultSet.getInt("MEDIA_YEAR")), resultSet.getString("GENRE"));
    }

    private static String personAlbumFileSql(DbIdTypeAndIdent typeAndIdent) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append("FILES.FILENAME").append(", ").append("FILES.ID").append(", ").append("FILES.MODIFIED").append(" FROM ").append("FILES").append(" LEFT OUTER JOIN ").append("AUDIO_METADATA").append(" ON ").append("FILES.ID").append(" = ").append("AUDIO_METADATA.FILEID").append(" ").append("WHERE (").append("AUDIO_METADATA.ALBUM").append(" = '").append(StringEscapeUtils.escapeSql(typeAndIdent.getIdentUnprefixed())).append("') AND ( ");
        VirtualFolderDbId.wherePartPersonByType(typeAndIdent, sb);
        sb.append(")");
        LOGGER.debug("personAlbumFilesSql : {}", (Object)sb.toString());
        return sb.toString();
    }

    private static String personAlbumSql(DbIdTypeAndIdent typeAndIdent) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT ON (").append("AUDIO_METADATA.ALBUM").append(")AUDIO_METADATA.ALBUM, MBID_RECORD as MBID_RELEASE, AUDIO_METADATA.GENRE, AUDIO_METADATA.ARTIST, AUDIO_METADATA.MEDIA_YEAR FROM ").append("AUDIO_METADATA").append(" WHERE (");
        VirtualFolderDbId.wherePartPersonByType(typeAndIdent, sb);
        sb.append(")");
        LOGGER.debug("personAlbumSql : {}", (Object)sb.toString());
        return sb.toString();
    }

    private static void wherePartPersonByType(DbIdTypeAndIdent typeAndIdent, StringBuilder sb) {
        String ident = StringEscapeUtils.escapeSql(typeAndIdent.getIdentUnprefixed());
        if (typeAndIdent.ident.startsWith("COMP_")) {
            sb.append("AUDIO_METADATA.COMPOSER");
            LOGGER.trace("WHERE PERSON COMPOSER");
        } else if (typeAndIdent.ident.startsWith("COND_")) {
            sb.append("AUDIO_METADATA.CONDUCTOR");
            LOGGER.trace("WHERE PERSON CONDUCTOR");
        } else if (typeAndIdent.ident.startsWith("AART_")) {
            sb.append("AUDIO_METADATA.ALBUMARTIST");
            LOGGER.trace("WHERE PERSON ALBUMARTIST");
        } else {
            sb.append("AUDIO_METADATA.ARTIST");
            LOGGER.trace("WHERE PERSON ARTIST");
        }
        sb.append(" = '").append(ident).append("'");
    }

    private static String personAllFilesSql(DbIdTypeAndIdent typeAndIdent) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append("FILES.FILENAME").append(", ").append("FILES.ID").append(", ").append("FILES.MODIFIED").append(" FROM ").append("FILES").append(" LEFT OUTER JOIN ").append("AUDIO_METADATA").append(" ON ").append("FILES.ID").append(" = ").append("AUDIO_METADATA.FILEID").append(" WHERE ( ");
        VirtualFolderDbId.wherePartPersonByType(typeAndIdent, sb);
        sb.append(")");
        LOGGER.debug("personAllFilesSql : {}", (Object)sb.toString());
        return sb.toString();
    }
}

