/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.io.IOException;
import net.pms.io.StreamGobbler;
import net.pms.renderers.Renderer;
import net.pms.store.ResumeObj;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.container.VideoSettingsFolder;
import net.pms.store.item.VirtualVideoAction;
import net.pms.store.item.VirtualVideoActionLocalized;
import net.pms.util.FileUtil;
import net.pms.util.ProcessUtil;

public class ServerSettingsFolder
extends LocalizedStoreContainer {
    public ServerSettingsFolder(Renderer renderer) {
        super(renderer, "ServerSettings");
    }

    public static ServerSettingsFolder getServerSettingsFolder(Renderer renderer) {
        File scriptDir;
        ServerSettingsFolder res = new ServerSettingsFolder(renderer);
        VideoSettingsFolder vsf = VideoSettingsFolder.getVideoSettingsFolder(renderer);
        if (vsf != null) {
            res.addChild(vsf);
        }
        if (renderer.getUmsConfiguration().getScriptDir() != null && (scriptDir = new File(renderer.getUmsConfiguration().getScriptDir())).exists()) {
            res.addChild(new LocalizedStoreContainer(renderer, "Scripts"){

                @Override
                public void discoverChildren() {
                    File[] files = scriptDir.listFiles();
                    if (files != null) {
                        for (File file : files) {
                            String childrenName = file.getName().replace("_", " ");
                            int pos = childrenName.lastIndexOf(46);
                            if (pos != -1) {
                                childrenName = childrenName.substring(0, pos);
                            }
                            final File f = file;
                            this.addChild(new VirtualVideoAction(this.renderer, childrenName, true, null){

                                @Override
                                public boolean enable() {
                                    try {
                                        ProcessBuilder pb = new ProcessBuilder(f.getAbsolutePath());
                                        pb.redirectErrorStream(true);
                                        Process pid = pb.start();
                                        StreamGobbler.consume(pid.getInputStream());
                                        pid.waitFor();
                                    }
                                    catch (IOException pb) {
                                    }
                                    catch (InterruptedException e) {
                                        Thread.currentThread().interrupt();
                                    }
                                    return true;
                                }
                            });
                        }
                    }
                }
            });
        }
        if (renderer.getUmsConfiguration().isResumeEnabled()) {
            res.addChild(new LocalizedStoreContainer(renderer, "ManageResumeFiles"){

                @Override
                public void discoverChildren() {
                    final File[] files = ResumeObj.resumeFiles();
                    this.addChild(new VirtualVideoActionLocalized(this.renderer, "DeleteAllFiles", true, null){

                        @Override
                        public boolean enable() {
                            for (File f : files) {
                                f.delete();
                            }
                            this.getParent().getChildren().remove(this);
                            return false;
                        }
                    });
                    for (final File f : files) {
                        String childrenName = FileUtil.getFileNameWithoutExtension(f.getName());
                        childrenName = childrenName.replaceAll("_hash_(\\d+)", "");
                        this.addChild(new VirtualVideoAction(this.renderer, childrenName, false, null){

                            @Override
                            public boolean enable() {
                                f.delete();
                                this.getParent().getChildren().remove(this);
                                return false;
                            }
                        });
                    }
                }
            });
        }
        res.addChild(new VirtualVideoActionLocalized(renderer, "RestartUms", true, "images/store/action-restart.png"){

            @Override
            public boolean enable() {
                ProcessUtil.reboot();
                return false;
            }
        });
        res.addChild(new VirtualVideoActionLocalized(renderer, "ShutDownComputer", true, "images/store/action-shutdown.png"){

            @Override
            public boolean enable() {
                ProcessUtil.shutDownComputer();
                return false;
            }
        });
        return res;
    }
}

