/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import com.github.junrar.volume.FileVolumeManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.container.SevenZipFolder;
import net.pms.store.item.RarredEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RarredFolder
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RarredFolder.class);
    protected final File file;
    private final String entryName;

    public RarredFolder(Renderer renderer, File file, String entryName) {
        super(renderer, null, null);
        this.file = file;
        if (entryName == null || "".equals(entryName)) {
            this.entryName = "";
        } else {
            this.entryName = entryName;
            this.name = entryName;
            if (this.name.endsWith("/")) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
            if (this.name.contains("/")) {
                this.name = this.name.substring(this.name.lastIndexOf("/"));
            }
        }
    }

    @Override
    public String getSystemName() {
        return this.file.getAbsolutePath() + "#" + this.entryName;
    }

    @Override
    public boolean isValid() {
        return this.file.exists();
    }

    @Override
    public void discoverChildren() {
        this.getChildren().clear();
        try (Archive rarFile = new Archive(new FileVolumeManager(this.file), null, null);){
            List<FileHeader> headers = rarFile.getFileHeaders();
            for (FileHeader fh : headers) {
                if (fh.getFileName().equals(this.entryName) && fh.getCreationTime() != null) {
                    this.setLastModified(fh.getCreationTime().toMillis());
                    continue;
                }
                if (!this.isDirectChild(fh)) continue;
                if (fh.isDirectory()) {
                    this.addChild(new SevenZipFolder(this.renderer, this.file, fh.getFileName()));
                    continue;
                }
                RarredEntry child = new RarredEntry(this.renderer, this.file, fh.getFileName(), fh.getFullUnpackSize());
                if (!child.isValid()) continue;
                this.addChild(child);
            }
        }
        catch (RarException | IOException e) {
            LOGGER.error("Error reading archive file", e);
        }
    }

    private boolean isDirectChild(FileHeader fh) {
        if (fh.getFileName().startsWith(this.entryName)) {
            String childName = fh.getFileName().substring(this.entryName.length() + 1);
            return !childName.contains("/") && !childName.contains("\\");
        }
        return false;
    }
}

