/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pms.PMS;
import net.pms.database.MediaTableContainerFiles;
import net.pms.database.MediaTableFiles;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.formats.Format;
import net.pms.formats.FormatFactory;
import net.pms.parsers.WebStreamParser;
import net.pms.renderers.Renderer;
import net.pms.store.PlaylistManager;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.item.FeedItem;
import net.pms.store.item.RealFile;
import net.pms.store.item.WebAudioStream;
import net.pms.store.item.WebVideoStream;
import net.pms.util.FileUtil;
import net.pms.util.ProcessUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlaylistFolder
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlaylistFolder.class);
    private final String uri;
    private final boolean isweb;
    private final int defaultContent;

    public PlaylistFolder(Renderer renderer, String name, String uri, int type) {
        super(renderer, name, null);
        this.uri = uri;
        this.isweb = FileUtil.isUrl(uri);
        super.setLastModified(this.isweb ? 0L : new File(uri).lastModified());
        this.defaultContent = type != 0 && type != 8 ? type : 4;
    }

    public PlaylistFolder(Renderer renderer, File f) {
        super(renderer, f.getName(), null);
        this.uri = f.getAbsolutePath();
        this.isweb = false;
        super.setLastModified(f.lastModified());
        this.defaultContent = 4;
    }

    public File getPlaylistfile() {
        return this.isweb ? null : new File(this.uri);
    }

    @Override
    public boolean allowScan() {
        return true;
    }

    @Override
    public String getSystemName() {
        return this.isweb ? this.uri : ProcessUtil.getSystemPathName(this.uri);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void discoverChildren() {
        this.resolve();
    }

    private BufferedReader getBufferedReader() throws IOException {
        String extension = FileUtil.isUrl(this.uri) ? FileUtil.getUrlExtension(this.uri) : FileUtil.getExtension(this.uri);
        if (extension != null) {
            extension = extension.toLowerCase(PMS.getLocale());
        }
        Charset charset = extension != null && (extension.equals("m3u8") || extension.equals(".cue")) ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        if (FileUtil.isUrl(this.uri)) {
            BOMInputStream bi = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(URI.create(this.uri).toURL().openStream())).get();
            return new BufferedReader(new InputStreamReader((InputStream)bi, charset));
        }
        File playlistfile = new File(this.uri);
        if (playlistfile.length() < 10000000L) {
            FileInputStream inputStream = new FileInputStream(playlistfile);
            BOMInputStream bi = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(inputStream)).get();
            return new BufferedReader(new InputStreamReader((InputStream)bi, charset));
        }
        return null;
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        if (!this.isweb) {
            File thumbnailImage = new File(FilenameUtils.removeExtension(this.uri) + ".png");
            if (!thumbnailImage.exists() || thumbnailImage.isDirectory()) {
                thumbnailImage = new File(FilenameUtils.removeExtension(this.uri) + ".jpg");
            }
            if (!thumbnailImage.exists() || thumbnailImage.isDirectory()) {
                thumbnailImage = new File(FilenameUtils.getFullPath(this.uri) + "folder.png");
            }
            if (!thumbnailImage.exists() || thumbnailImage.isDirectory()) {
                thumbnailImage = new File(FilenameUtils.getFullPath(this.uri) + "folder.jpg");
            }
            if (!thumbnailImage.exists() || thumbnailImage.isDirectory()) {
                return super.getThumbnailInputStream();
            }
            DLNAThumbnailInputStream result = null;
            try {
                LOGGER.debug("PlaylistFolder albumart path : " + thumbnailImage.getAbsolutePath());
                result = DLNAThumbnailInputStream.toThumbnailInputStream(new FileInputStream(thumbnailImage));
            }
            catch (IOException e) {
                LOGGER.debug("An error occurred while getting thumbnail for \"{}\", using generic thumbnail instead: {}", (Object)this.getName(), (Object)e.getMessage());
                LOGGER.trace("", e);
            }
            return result != null ? result : super.getThumbnailInputStream();
        }
        return null;
    }

    @Override
    public void resolve() {
        this.getChildren().clear();
        File playlistFile = this.getPlaylistfile();
        if (playlistFile != null) {
            this.setLastModified(playlistFile.lastModified());
        }
        this.resolveOnce();
    }

    @Override
    protected void resolveOnce() {
        Long containerId = MediaTableFiles.getOrInsertFileId(this.uri, this.getLastModified(), 16);
        List<Entry> entries = this.getPlaylistEntries();
        for (Entry entry : entries) {
            Long entryId;
            StoreItem d;
            if (entry == null) continue;
            LOGGER.debug("Adding playlist entry: {}", (Object)entry);
            if (!this.isweb && !FileUtil.isUrl(entry.fileName)) {
                File en;
                Format f;
                int type = this.defaultContent;
                Object ext = FileUtil.getUrlExtension(entry.fileName);
                if (ext != null && (f = FormatFactory.getAssociatedFormat((String)(ext = "." + (String)ext))) != null) {
                    type = f.getType();
                }
                if (!(en = new File(FilenameUtils.concat(new File(this.uri).getParent(), entry.fileName))).exists()) continue;
                if (type == 16) {
                    this.addChild(new PlaylistFolder(this.renderer, en));
                    continue;
                }
                this.addChild(new RealFile(this.renderer, en, entry.title));
                continue;
            }
            String u = FileUtil.urlJoin(this.uri, entry.fileName);
            Integer type = MediaTableFiles.getFormatType(u);
            if (type == null || type == 0) {
                type = WebStreamParser.getWebStreamType(entry.fileName, this.defaultContent);
            }
            if ((d = (switch (type) {
                case 4 -> new WebVideoStream(this.renderer, entry.title, u, null, entry.directives);
                case 1 -> new WebAudioStream(this.renderer, entry.title, u, null, entry.directives);
                case 2 -> new FeedItem(this.renderer, entry.title, u, null, null, 2);
                case 16 -> PlaylistManager.getPlaylist(this.renderer, entry.title, u, 0);
                default -> null;
            })) == null) continue;
            this.addChild(d);
            if (d instanceof StoreContainer) {
                StoreContainer storeContainer = (StoreContainer)((Object)d);
                entryId = MediaTableFiles.getOrInsertFileId(u, storeContainer.getLastModified(), type);
            } else {
                entryId = MediaTableFiles.getOrInsertFileId(u, 0L, type);
            }
            MediaTableContainerFiles.addContainerEntry(containerId, entryId);
        }
        if (this.renderer.getUmsConfiguration().getSortMethod(this.getPlaylistfile()) == 5) {
            Collections.shuffle(this.getChildren());
        }
        for (StoreResource r : this.getChildren()) {
            r.syncResolve();
        }
    }

    private List<Entry> getPlaylistEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        boolean m3u = false;
        boolean pls = false;
        try (BufferedReader br = this.getBufferedReader();){
            String line;
            while (!m3u && !pls && br != null && (line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#EXTM3U")) {
                    m3u = true;
                    LOGGER.debug("Reading m3u playlist: " + this.getName());
                    continue;
                }
                if (line.length() <= 0 || !line.equals("[playlist]")) continue;
                pls = true;
                LOGGER.debug("Reading PLS playlist: " + this.getName());
            }
            String title = null;
            HashMap<String, String> directives = new HashMap<String, String>();
            while (br != null && (line = br.readLine()) != null) {
                String fileName;
                line = line.trim();
                if (pls) {
                    int eq;
                    if (line.length() <= 0 || line.startsWith("#") || (eq = line.indexOf(61)) == -1) continue;
                    String value = line.substring(eq + 1);
                    String valueType = line.substring(0, eq).toLowerCase();
                    fileName = null;
                    title = null;
                    int index = 0;
                    if (valueType.startsWith("file")) {
                        index = Integer.parseInt(valueType.substring(4));
                        fileName = value;
                    } else if (valueType.startsWith("title")) {
                        index = Integer.parseInt(valueType.substring(5));
                        title = value;
                    }
                    if (index <= 0) continue;
                    while (entries.size() < index) {
                        entries.add(null);
                    }
                    Entry entry = (Entry)entries.get(index - 1);
                    if (entry == null) {
                        entry = new Entry();
                        entries.set(index - 1, entry);
                    }
                    if (fileName != null) {
                        entry.fileName = fileName;
                    }
                    if (title == null) continue;
                    entry.title = title;
                    continue;
                }
                if (!m3u) continue;
                if (line.startsWith("#EXTINF:")) {
                    if ((line = line.substring(8).trim()).matches("^-?\\d+,.+")) {
                        title = line.substring(line.indexOf(44) + 1).trim();
                        continue;
                    }
                    title = line;
                    continue;
                }
                if (line.startsWith("#RADIOBROWSERUUID:")) {
                    directives.put("RADIOBROWSERUUID", line.substring(18));
                    continue;
                }
                if (line.startsWith("#") || line.matches("^\\s*$")) continue;
                fileName = line;
                Entry entry = new Entry();
                entry.fileName = fileName;
                entry.title = title;
                entry.directives = directives;
                entries.add(entry);
                title = null;
                directives = new HashMap();
            }
        }
        catch (IOException | NumberFormatException e) {
            LOGGER.error(null, e);
        }
        return entries;
    }

    @Override
    public String getDisplayName(boolean withSuffix) {
        String displayName = super.getDisplayNameBase();
        if (displayName.contains(".")) {
            displayName = displayName.substring(0, displayName.lastIndexOf("."));
        }
        return displayName;
    }

    private static class Entry {
        private String fileName;
        private String title;
        private Map<String, String> directives;

        private Entry() {
        }

        public String toString() {
            return "[" + this.fileName + "," + this.title + "]";
        }
    }
}

