/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.IOException;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.media.MediaInfo;
import net.pms.renderers.Renderer;
import net.pms.store.MediaInfoStore;
import net.pms.store.ThumbnailStore;
import net.pms.store.container.MediaLibraryFolder;

public class MediaLibraryMovieFolder
extends MediaLibraryFolder {
    private final String filename;

    public MediaLibraryMovieFolder(Renderer renderer, String name, String filename, String[] sql, int[] expectedOutput) {
        super(renderer, null, sql, expectedOutput);
        this.setName(name);
        this.filename = filename;
    }

    @Override
    public String getSystemName() {
        return "movie_" + this.getName();
    }

    @Override
    public String getLocalizedDisplayName(String lang) {
        if (this.getMediaInfo() != null && this.mediaInfo.hasVideoMetadata()) {
            this.mediaInfo.getVideoMetadata().ensureHavingTranslation(lang);
            return this.mediaInfo.getVideoMetadata().getTitle(lang);
        }
        return super.getDisplayNameBase();
    }

    @Override
    public String getDisplayNameBase() {
        return this.getLocalizedDisplayName(null);
    }

    @Override
    public MediaInfo getMediaInfo() {
        if (this.mediaInfo == null && this.filename != null) {
            this.mediaInfo = MediaInfoStore.getMediaInfo(this.filename);
        }
        return this.mediaInfo;
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        if (this.getMediaInfo() != null && this.mediaInfo.getThumbnailId() != null) {
            return ThumbnailStore.getThumbnailInputStream(this.mediaInfo.getThumbnailId());
        }
        return super.getThumbnailInputStream();
    }
}

