/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import net.pms.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemFilesHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemFilesHelper.class);
    public static final Set<String> THUMBNAIL_EXTENSIONS = Set.of("jpeg", "jpg", "png");
    public static final Set<String> EXTENSIONS_DENYLIST = Set.of("!qB", "!ut", "1", "dmg", "exe");

    private SystemFilesHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getFolderThumbnail(File folder) {
        if (folder == null) return null;
        if (!folder.isDirectory()) {
            return null;
        }
        try (DirectoryStream<Path> folderThumbnails = Files.newDirectoryStream(folder.toPath(), entry -> {
            Path fileNamePath = entry.getFileName();
            if (fileNamePath == null) {
                return false;
            }
            String fileName = fileNamePath.toString().toLowerCase(Locale.ROOT);
            if (fileName.startsWith("folder.") || fileName.contains("albumart")) {
                return SystemFilesHelper.isPotentialThumbnail(fileName);
            }
            return false;
        });){
            Iterator<Path> iterator = folderThumbnails.iterator();
            if (!iterator.hasNext()) return null;
            Path folderThumbnail = iterator.next();
            File file = folderThumbnail.toFile();
            return file;
        }
        catch (IOException e) {
            LOGGER.warn("An error occurred while trying to browse folder \"{}\": {}", (Object)folder.getAbsolutePath(), (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static boolean isFolderThumbnail(File file, boolean evaluateExtension) {
        if (file == null || !file.isFile()) {
            return false;
        }
        String fileName = file.getName();
        if (StringUtils.isBlank(fileName)) {
            return false;
        }
        if (evaluateExtension && !SystemFilesHelper.isPotentialThumbnail(fileName)) {
            return false;
        }
        return (fileName = fileName.toLowerCase(Locale.ROOT)).startsWith("folder.") || fileName.contains("albumart");
    }

    public static Set<File> getPotentialFileThumbnails(File audioVideoFile, boolean existingOnly) {
        HashSet<File> potentialMatches = new HashSet<File>(THUMBNAIL_EXTENSIONS.size() * 2);
        for (String extension : THUMBNAIL_EXTENSIONS) {
            File file = FileUtil.replaceExtension(audioVideoFile, extension, false, true);
            if (!existingOnly || file.exists()) {
                potentialMatches.add(file);
            }
            file = new File(audioVideoFile.toString() + ".cover." + extension);
            if (existingOnly && !file.exists()) continue;
            potentialMatches.add(file);
        }
        return potentialMatches;
    }

    public static boolean isPotentialThumbnail(File file) {
        return file != null && file.isFile() && SystemFilesHelper.isPotentialThumbnail(file.getName());
    }

    public static boolean isPotentialThumbnail(String fileName) {
        return THUMBNAIL_EXTENSIONS.contains(FileUtil.getExtension(fileName));
    }

    public static boolean isPotentialMediaFile(String fileName) {
        String ext = FileUtil.getExtension(fileName);
        if (ext == null) {
            return false;
        }
        return !EXTENSIONS_DENYLIST.contains(ext);
    }
}

