/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableStoreIds;
import net.pms.store.MediaStoreId;
import net.pms.store.StoreContainer;
import net.pms.store.StoreResource;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaStoreIds {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaStoreIds.class);
    private static final Map<Long, UnsignedIntegerFourBytes> UPDATE_IDS = new HashMap<Long, UnsignedIntegerFourBytes>();

    private MediaStoreIds() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Long getMediaStoreResourceId(StoreResource resource) {
        if (resource == null) {
            return null;
        }
        Connection connection = null;
        try {
            MediaStoreId mediaStoreId;
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null && (mediaStoreId = MediaTableStoreIds.getResourceMediaStoreId(connection, resource)) != null) {
                long id = mediaStoreId.getId();
                resource.setLongId(id);
                if (mediaStoreId.getUpdateId() == 0L) {
                    long updateId = MediaStoreIds.incrementUpdateId(id);
                    mediaStoreId.setUpdateId(updateId);
                }
                UPDATE_IDS.put(id, new UnsignedIntegerFourBytes(mediaStoreId.getUpdateId()));
                Long l = id;
                return l;
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MediaStoreId> getMediaStoreResourceTree(long id) {
        ArrayList<MediaStoreId> mediaStoreIds = new ArrayList<MediaStoreId>();
        Connection connection = null;
        try {
            MediaStoreId mediaStoreId;
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null && (mediaStoreId = MediaTableStoreIds.getMediaStoreId(connection, id)) != null) {
                mediaStoreIds.add(mediaStoreId);
                while (mediaStoreId.getParentId() != 0L) {
                    mediaStoreId = MediaTableStoreIds.getMediaStoreId(connection, mediaStoreId.getParentId());
                    mediaStoreIds.add(mediaStoreId);
                    if (mediaStoreIds.size() <= 100) continue;
                    LOGGER.trace("MediaStore path is more than 100 entries, something was wrong");
                    ArrayList<MediaStoreId> arrayList = new ArrayList<MediaStoreId>();
                    return arrayList;
                }
                Collections.reverse(mediaStoreIds);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        return mediaStoreIds;
    }

    public static List<Long> getMediaStoreIdsForName(String name) {
        ArrayList<Long> ids = new ArrayList();
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                ids = MediaTableStoreIds.getMediaStoreIdsForName(connection, name);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        return ids;
    }

    public static String getMediaStoreNameForId(String id) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                String string = MediaTableStoreIds.getMediaStoreNameForId(connection, id);
                return string;
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getMediaStoreIdsForName(String name, String objectType) {
        List<Long> ids = new ArrayList<Long>();
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                ids = MediaTableStoreIds.getMediaStoreIdsForName(connection, name, objectType);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        return ids;
    }

    public static List<Long> getMediaStoreIdsForName(String name, Class<? extends StoreResource> storeResourceClass) {
        return MediaStoreIds.getMediaStoreIdsForName(name, storeResourceClass.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getMediaStoreIdsForName(String name, String objectType, String parentType) {
        List<Long> ids = new ArrayList<Long>();
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                ids = MediaTableStoreIds.getMediaStoreIdsForName(connection, name, objectType, parentType);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        return ids;
    }

    public static List<Long> getMediaStoreIdsForName(String name, Class<? extends StoreResource> storeResourceClass, Class<? extends StoreContainer> parentResourceClass) {
        return MediaStoreIds.getMediaStoreIdsForName(name, storeResourceClass.getSimpleName(), parentResourceClass.getSimpleName());
    }

    public static void incrementUpdateIdForFilename(Connection connection, String filename) {
        List<Long> ids = MediaTableStoreIds.getMediaStoreIdsForName(connection, filename);
        for (Long id : ids) {
            MediaStoreIds.incrementUpdateId(connection, id);
        }
    }

    public static void incrementUpdateIdForFilename(String filename) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                MediaStoreIds.incrementUpdateIdForFilename(connection, filename);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    public static synchronized UnsignedIntegerFourBytes getSystemUpdateId() {
        if (!UPDATE_IDS.containsKey(-1L)) {
            UnsignedIntegerFourBytes value = null;
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    MediaStoreId mediaStoreId = MediaTableStoreIds.getMediaStoreId(connection, -1L);
                    value = mediaStoreId != null ? new UnsignedIntegerFourBytes(mediaStoreId.getUpdateId()) : new UnsignedIntegerFourBytes(0L);
                }
                if (value == null) {
                    value = new UnsignedIntegerFourBytes(0L);
                }
                UPDATE_IDS.put(-1L, value);
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
        return UPDATE_IDS.get(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized UnsignedIntegerFourBytes getObjectUpdateId(Long id) {
        if (id == null || id == -1L) {
            return MediaStoreIds.getSystemUpdateId();
        }
        if (!UPDATE_IDS.containsKey(id)) {
            UnsignedIntegerFourBytes value = null;
            Connection connection = null;
            try {
                MediaStoreId mediaStoreId;
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null && (mediaStoreId = MediaTableStoreIds.getMediaStoreId(connection, id)) != null && mediaStoreId.getUpdateId() != 0L) {
                    value = new UnsignedIntegerFourBytes(mediaStoreId.getUpdateId());
                }
                if (value == null) {
                    value = MediaStoreIds.getSystemUpdateId();
                }
                UPDATE_IDS.put(id, value);
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
        return UPDATE_IDS.get(id);
    }

    public static String getObjectUpdateIdAsString(Long id) {
        UnsignedIntegerFourBytes result = MediaStoreIds.getObjectUpdateId(id);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public static synchronized void incrementSystemUpdateId() {
        MediaStoreIds.incrementUpdateId(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Long incrementUpdateId(Long id) {
        long updateId = MediaStoreIds.getSystemUpdateId().increment(false).getValue();
        if (id != null && id != -1L && UPDATE_IDS.containsKey(id)) {
            UPDATE_IDS.put(id, new UnsignedIntegerFourBytes(updateId));
        }
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                MediaTableStoreIds.setMediaStoreUpdateId(connection, -1L, updateId);
                if (id != null && id != -1L) {
                    MediaTableStoreIds.setMediaStoreUpdateId(connection, id, updateId);
                }
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
        return updateId;
    }

    private static synchronized void incrementUpdateId(Connection connection, Long id) {
        if (id != null && id != -1L) {
            long updateId = MediaStoreIds.getSystemUpdateId().increment(false).getValue();
            if (UPDATE_IDS.containsKey(id)) {
                UPDATE_IDS.put(id, new UnsignedIntegerFourBytes(updateId));
            }
            if (connection != null) {
                MediaTableStoreIds.setMediaStoreUpdateId(connection, -1L, updateId);
                MediaTableStoreIds.setMediaStoreUpdateId(connection, id, updateId);
            }
        }
    }
}

