/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import net.pms.store.DbIdTypeAndIdent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DbIdMediaType {
    TYPE_AUDIO("FID$", "object.item.audioItem"),
    TYPE_FOLDER("FOLDER$", "object.container.storageFolder"),
    TYPE_ALBUM("ALBUM$", "object.container.album.musicAlbum"),
    TYPE_MUSICBRAINZ_RECORDID("MUSICBRAINZALBUM$", "object.container.album.musicAlbum"),
    TYPE_MYMUSIC_ALBUM("MYMUSIC$", "object.container.storageFolder"),
    TYPE_PERSON("PERSON$", "object.container.person.musicArtist"),
    TYPE_PERSON_COMPOSER("PERSON_COMPOSER$", "object.container.person.musicArtist"),
    TYPE_PERSON_CONDUCTOR("PERSON_CONDUCTOR$", "object.container.person.musicArtist"),
    TYPE_PERSON_ALBUMARTIST("PERSON_ALBUMARTIST$", "object.container.person.musicArtist"),
    TYPE_PERSON_ALBUM_FILES("PERSON_ALBUM_FILES$", "object.container.storageFolder"),
    TYPE_PERSON_ALBUM("PERSON_ALBUM$", "object.container.storageFolder"),
    TYPE_PERSON_ALL_FILES("PERSON_ALL_FILES$", "object.container.storageFolder"),
    TYPE_PLAYLIST("PLAYLIST$", "object.container.playlistContainer"),
    TYPE_VIDEO("VIDEO$", "object.item.videoItem"),
    TYPE_IMAGE("IMAGE$", "object.item.imageItem");

    private static final Logger LOGGER;
    public static final String GENERAL_PREFIX = "$DBID$";
    public static final String PERSON_COMPOSER_PREFIX = "COMP_";
    public static final String PERSON_CONDUCTOR_PREFIX = "COND_";
    public static final String PERSON_ALBUMARTIST_PREFIX = "AART_";
    public final String dbidPrefix;
    public final String uclass;

    private DbIdMediaType(String dbidPrefix, String uclass) {
        this.dbidPrefix = dbidPrefix;
        this.uclass = uclass;
    }

    public String toString() {
        return GENERAL_PREFIX + this.dbidPrefix;
    }

    public static DbIdTypeAndIdent getTypeIdentByDbid(String id) {
        String strType = id.substring(GENERAL_PREFIX.length());
        for (DbIdMediaType type : DbIdMediaType.values()) {
            if (!strType.startsWith(type.dbidPrefix)) continue;
            String ident = strType.substring(type.dbidPrefix.length());
            try {
                return new DbIdTypeAndIdent(type, URLDecoder.decode(ident, StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("decode error", e);
                return new DbIdTypeAndIdent(type, ident);
            }
        }
        throw new RuntimeException("Unknown DBID type : " + id);
    }

    static {
        LOGGER = LoggerFactory.getLogger(DbIdMediaType.class);
    }
}

