/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.util.List;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaTableMusicBrainzReleases;
import net.pms.media.audio.metadata.MusicBrainzAlbum;
import net.pms.renderers.Renderer;
import net.pms.store.DbIdMediaType;
import net.pms.store.DbIdResourceLocator;
import net.pms.store.DbIdTypeAndIdent;
import net.pms.store.StoreResource;
import net.pms.store.container.MediaLibrary;
import net.pms.store.container.MusicBrainzAlbumFolder;
import net.pms.store.container.MusicBrainzPersonFolder;
import net.pms.store.container.VirtualFolderDbId;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbIdLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbIdLibrary.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private final Renderer renderer;
    private VirtualFolderDbId audioLikesFolder;
    private VirtualFolderDbId mbidFolder;
    private VirtualFolderDbId personArtistFolder;
    private VirtualFolderDbId personAlbumArtistFolder;
    private VirtualFolderDbId personComposerFolder;
    private VirtualFolderDbId personConductorFolder;

    public DbIdLibrary(Renderer renderer) {
        this.renderer = renderer;
    }

    public VirtualFolderDbId getAudioLikesFolder() {
        return this.audioLikesFolder;
    }

    public VirtualFolderDbId getMbidFolder() {
        return this.mbidFolder;
    }

    public VirtualFolderDbId getPersonArtistFolder() {
        return this.personArtistFolder;
    }

    public VirtualFolderDbId getPersonAlbumArtistFolder() {
        return this.personAlbumArtistFolder;
    }

    public VirtualFolderDbId getPersonConductorFolder() {
        return this.personConductorFolder;
    }

    public VirtualFolderDbId getPersonComposerFolder() {
        return this.personComposerFolder;
    }

    protected final void reset(List<StoreResource> backupChildren) {
        if (CONFIGURATION.useNextcpApi()) {
            this.setAudioLikesFolder(backupChildren);
            this.setPersonFolder();
        }
    }

    private void addChildToMediaLibraryAudioFolder(VirtualFolderDbId dbIdFolder) {
        MediaLibrary mediaLibrary;
        if (this.renderer.getUmsConfiguration().isShowMediaLibraryFolder() && (mediaLibrary = this.renderer.getMediaStore().getMediaLibrary()) != null && mediaLibrary.getAudioFolder() != null && mediaLibrary.getAudioFolder().getChildren() != null && !mediaLibrary.getAudioFolder().getChildren().contains(dbIdFolder)) {
            mediaLibrary.getAudioFolder().addChild(dbIdFolder);
            LOGGER.debug("adding '{}' folder to the 'Audio' folder of MediaLibrary", (Object)dbIdFolder.getDisplayName());
        }
    }

    private void setAudioLikesFolder(List<StoreResource> backupChildren) {
        if (this.audioLikesFolder == null) {
            this.audioLikesFolder = new VirtualFolderDbId(this.renderer, "MyAlbums", new DbIdTypeAndIdent(DbIdMediaType.TYPE_MYMUSIC_ALBUM, null));
        }
        if (PMS.getConfiguration().displayAudioLikesInRootFolder()) {
            if (backupChildren.contains(this.audioLikesFolder)) {
                this.renderer.getMediaStore().addChildInternal(this.audioLikesFolder, false);
            } else {
                this.renderer.getMediaStore().addChild(this.audioLikesFolder);
            }
            LOGGER.debug("adding My Albums folder to the root of MediaStore");
        } else {
            this.addChildToMediaLibraryAudioFolder(this.audioLikesFolder);
        }
        if (backupChildren.contains(this.audioLikesFolder)) {
            backupChildren.remove(this.audioLikesFolder);
        }
    }

    private void setPersonFolder() {
        if (this.personArtistFolder == null) {
            this.personArtistFolder = new VirtualFolderDbId(this.renderer, "BrowseByArtist", new DbIdTypeAndIdent(DbIdMediaType.TYPE_PERSON, null));
        }
        this.addChildToMediaLibraryAudioFolder(this.personArtistFolder);
        if (this.personComposerFolder == null) {
            this.personComposerFolder = new VirtualFolderDbId(this.renderer, "BrowseByComposer", new DbIdTypeAndIdent(DbIdMediaType.TYPE_PERSON_COMPOSER, null));
        }
        this.addChildToMediaLibraryAudioFolder(this.personComposerFolder);
        if (this.personConductorFolder == null) {
            this.personConductorFolder = new VirtualFolderDbId(this.renderer, "BrowseByConductor", new DbIdTypeAndIdent(DbIdMediaType.TYPE_PERSON_CONDUCTOR, null));
        }
        this.addChildToMediaLibraryAudioFolder(this.personConductorFolder);
        if (this.personAlbumArtistFolder == null) {
            this.personAlbumArtistFolder = new VirtualFolderDbId(this.renderer, "BrowseByAlbumArtist", new DbIdTypeAndIdent(DbIdMediaType.TYPE_PERSON_ALBUMARTIST, null));
        }
        this.addChildToMediaLibraryAudioFolder(this.personAlbumArtistFolder);
    }

    public static MusicBrainzPersonFolder addLibraryResourcePerson(Renderer renderer, DbIdTypeAndIdent typeIdent) {
        if (StringUtils.isAllBlank(typeIdent.ident)) {
            LOGGER.warn("no person name given.");
            return null;
        }
        MusicBrainzPersonFolder personFolder = new MusicBrainzPersonFolder(renderer, typeIdent.ident, typeIdent);
        personFolder.getPersonFolder(renderer).addChild(personFolder);
        personFolder.discoverChildren();
        return personFolder;
    }

    public static MusicBrainzAlbumFolder addLibraryResourceMusicBrainzAlbum(Renderer renderer, MusicBrainzAlbum album) {
        try {
            DbIdTypeAndIdent typeIdent = new DbIdTypeAndIdent(DbIdMediaType.TYPE_MUSICBRAINZ_RECORDID, album.getMbReleaseid());
            MusicBrainzAlbumFolder mbFolder = DbIdResourceLocator.getLibraryResourceMusicBrainzFolder(renderer, typeIdent);
            if (mbFolder == null) {
                LOGGER.debug("musicBrainz album not in database : {} ", (Object)typeIdent.toString());
                MusicBrainzAlbum persistentAlbum = MediaTableMusicBrainzReleases.getMusicBrainzAlbum(album.getMbReleaseid());
                if (persistentAlbum == null) {
                    MediaTableMusicBrainzReleases.storeMusicBrainzAlbum(album);
                }
                mbFolder = new MusicBrainzAlbumFolder(renderer, album);
                DbIdTypeAndIdent tiPerson = new DbIdTypeAndIdent(DbIdMediaType.TYPE_PERSON, album.getArtist());
                MusicBrainzPersonFolder person = DbIdResourceLocator.getLibraryResourcePersonFolder(renderer, tiPerson);
                if (person == null) {
                    person = DbIdLibrary.addLibraryResourcePerson(renderer, tiPerson);
                }
                person.getAlbumFolder().addChild(mbFolder);
            }
            return mbFolder;
        }
        catch (Exception e) {
            LOGGER.error("cannot add MusicBrainzAlbumFolder.", e);
            return null;
        }
    }
}

