/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices.players;

import java.awt.event.ActionEvent;
import java.util.Map;
import net.pms.renderers.JUPnPDeviceHelper;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.players.LogicalPlayer;
import net.pms.renderers.devices.players.PlaylistItem;
import net.pms.store.StoreItem;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.model.meta.Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UPNPPlayer
extends LogicalPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UPNPPlayer.class);
    protected Device dev;
    protected String uuid;
    protected String instanceID;
    protected Map<String, String> data;
    protected String lastUri;
    private boolean ignoreUpnpDuration;

    public UPNPPlayer(Renderer renderer) {
        super(renderer);
        this.uuid = renderer.getUUID();
        this.dev = JUPnPDeviceHelper.getDevice(this.uuid);
        this.data = renderer.connect(this);
        this.lastUri = null;
        this.ignoreUpnpDuration = false;
        LOGGER.debug("Created upnp player for " + renderer.getRendererName());
        this.refresh();
    }

    @Override
    public void setURI(String uri, String metadata) {
        PlaylistItem item = this.resolveURI(uri, metadata);
        if (item != null) {
            if (item.getName() != null) {
                this.state.setName(item.getName());
            }
            JUPnPDeviceHelper.setAVTransportURI(this.dev, item.getUri(), this.renderer.isPushMetadata() ? item.getMetadata() : null);
        }
    }

    @Override
    public void play() {
        JUPnPDeviceHelper.play(this.dev);
    }

    @Override
    public void pause() {
        JUPnPDeviceHelper.pause(this.dev);
    }

    @Override
    public void stop() {
        JUPnPDeviceHelper.stop(this.dev);
    }

    @Override
    public void forward() {
        JUPnPDeviceHelper.seek(this.dev, "REL_TIME", this.jump(60.0));
    }

    @Override
    public void rewind() {
        JUPnPDeviceHelper.seek(this.dev, "REL_TIME", this.jump(-60.0));
    }

    @Override
    public void mute() {
        JUPnPDeviceHelper.setMute(this.dev, !this.state.isMuted());
    }

    @Override
    public void setVolume(int volume) {
        JUPnPDeviceHelper.setVolume(this.dev, volume * this.maxVol / 100);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.renderer.isUpnpConnected()) {
            this.refresh();
        } else if (!this.state.isStopped()) {
            this.reset();
        }
    }

    public void refresh() {
        String s;
        this.state.setPlayback(switch (s = this.data.get("TransportState")) {
            case "STOPPED" -> 0;
            case "PLAYING" -> 1;
            case "PAUSED_PLAYBACK" -> 2;
            default -> -1;
        });
        this.state.setMuted(!"0".equals(this.data.get("Mute")));
        s = this.data.get("Volume");
        this.state.setVolume(s == null ? 0 : Integer.parseInt(s) * 100 / this.maxVol);
        this.state.setPosition(this.data.get("RelTime"));
        if (!this.ignoreUpnpDuration) {
            this.state.setDuration(this.data.get("CurrentMediaDuration"));
        }
        this.state.setUri(this.data.get("AVTransportURI"));
        this.state.setMetadata(this.data.get("AVTransportURIMetaData"));
        if (!StringUtils.isBlank(this.state.getUri()) && !this.state.getUri().equals(this.lastUri)) {
            this.playlist.set(this.state.getUri(), null, this.state.getMetadata());
        }
        this.lastUri = this.state.getUri();
        this.alert();
    }

    @Override
    public void start() {
        StoreItem d = this.renderer.getPlayingRes();
        this.state.setName(d.getDisplayName());
        if (d.getMediaInfo() != null) {
            String duration = d.getMediaInfo().getDurationString();
            boolean bl = this.ignoreUpnpDuration = !StringUtil.isZeroTime(duration);
            if (this.ignoreUpnpDuration) {
                this.state.setDuration(StringUtil.shortTime(d.getMediaInfo().getDurationString(), 4));
            }
        }
    }

    @Override
    public void close() {
        this.renderer.disconnect(this);
        super.close();
    }

    public String jump(double seconds) {
        double t = StringUtil.convertStringToTime(this.state.getPosition()) + seconds;
        return t > 0.0 ? StringUtil.convertTimeToString(t, "%02d:%02d:%02.0f") : "00:00:00";
    }
}

