/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices;

import com.google.gson.JsonObject;
import java.util.Map;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.image.ImageFormat;
import net.pms.network.webguiserver.WebSocketSession;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.players.BasicPlayer;
import net.pms.renderers.devices.players.WebGuiPlayer;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;

public class WebGuiRenderer
extends Renderer {
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final int CHROME = 1;
    private static final int MSIE = 2;
    private static final int FIREFOX = 3;
    private static final int SAFARI = 4;
    private static final int PS4 = 5;
    private static final int XBOX1 = 6;
    private static final int OPERA = 7;
    private static final int EDGE = 8;
    private static final int CHROMIUM = 9;
    private static final int VIVALDI = 10;
    private final int browser;
    private final String subLang;
    private WebSocketSession ws;

    public WebGuiRenderer(String uuid, int userId, String userAgent, String subLang) throws ConfigurationException, InterruptedException {
        super(uuid);
        this.setUserId(userId);
        this.browser = WebGuiRenderer.getBrowser(userAgent);
        this.subLang = subLang;
        this.setFileless(true);
        this.configuration.setProperty("MediaInfo", true);
        this.configuration.setProperty("MediaParserV2_ThumbnailGeneration", false);
        this.configuration.setProperty("TranscodeAudio", "MP3");
        this.configuration.setProperty("TranscodeVideo", "HLS-MPEGTS-H264-AAC,MP4-H264-AAC");
        this.configuration.setProperty("HlsMultiVideoQuality", true);
        this.configuration.setProperty("HlsVersion", 6);
        this.configuration.setProperty("AutoPlayTmo", 0);
        this.configuration.setProperty("LimitFolders", false);
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    public boolean havePermission(int permission) {
        return this.account.havePermission(permission);
    }

    public boolean isImageFormatSupported(ImageFormat format) {
        if (format == null) {
            return false;
        }
        if (format == ImageFormat.GIF || format == ImageFormat.JPEG || format == ImageFormat.PNG) {
            return true;
        }
        return switch (format) {
            case ImageFormat.BMP -> {
                if (this.browser == 3 || this.browser == 1 || this.browser == 9 || this.browser == 7 || this.browser == 2 || this.browser == 8 || this.browser == 4) {
                    yield true;
                }
                yield false;
            }
            case ImageFormat.TIFF -> {
                if (this.browser == 8 || this.browser == 9 || this.browser == 4 || this.browser == 2) {
                    yield true;
                }
                yield false;
            }
            case ImageFormat.WEBP -> {
                if (this.browser == 8 || this.browser == 3 || this.browser == 1 || this.browser == 9 || this.browser == 7) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public String getRendererName() {
        String username = this.getUserName();
        if (username != null) {
            return username + "@" + WebGuiRenderer.getBrowserName(this.browser);
        }
        return WebGuiRenderer.getBrowserName(this.browser);
    }

    @Override
    public String getConfName() {
        return WebGuiRenderer.getBrowserName(this.browser);
    }

    public String getUserName() {
        if (this.account.getUser() != null && this.account.getUser().getId() != Integer.MAX_VALUE) {
            if (StringUtils.isNotEmpty(this.account.getUser().getDisplayName())) {
                return this.account.getUser().getDisplayName();
            }
            if (StringUtils.isNotEmpty(this.account.getUser().getUsername())) {
                return this.account.getUser().getUsername();
            }
        }
        return null;
    }

    @Override
    public String getRendererIcon() {
        return switch (this.browser) {
            case 1 -> "chrome.svg";
            case 2 -> "internetexplorer.svg";
            case 3 -> "firefox.svg";
            case 4 -> "safari.svg";
            case 5 -> "ps4.png";
            case 6 -> "xbox-one.png";
            case 7 -> "opera.svg";
            case 8 -> "edge.svg";
            case 9 -> "chromium.svg";
            case 10 -> "vivaldi.svg";
            default -> super.getRendererIcon();
        };
    }

    @Override
    public boolean isNoDynPlsFolder() {
        return true;
    }

    @Override
    public boolean nox264() {
        return true;
    }

    @Override
    public int getControls() {
        return CONFIGURATION.isWebPlayerControllable() ? 3 : 0;
    }

    @Override
    public BasicPlayer getPlayer() {
        if (this.player == null) {
            this.player = new WebGuiPlayer(this);
        }
        return this.player;
    }

    @Override
    public String getSubLanguage() {
        if (!CONFIGURATION.useWebPlayerSubLang() || StringUtils.isEmpty(this.subLang)) {
            return super.getSubLanguage();
        }
        return this.subLang;
    }

    @Override
    public boolean isAllowed() {
        return true;
    }

    @Override
    public void setAllowed(boolean b) {
    }

    public void setPlayerStatus(Map<String, String> status) {
        ((WebGuiPlayer)this.getPlayer()).updateStatus(status);
    }

    public void sendMessage(String ... args) {
        JsonObject jObject = new JsonObject();
        jObject.addProperty("action", "player");
        JsonObject jData = new JsonObject();
        if (args.length > 0) {
            jData.addProperty("request", args[0]);
            if (args.length > 1) {
                jObject.addProperty("arg0", args[1]);
                if (args.length > 2) {
                    jObject.addProperty("arg1", args[2]);
                }
            }
        }
        jObject.add("data", jData);
        if (this.ws != null && this.ws.isPlayerOpen()) {
            this.ws.sendMessage(jObject.toString());
        }
        this.updateWebSocketPlayer();
    }

    public void setWebSocketSession(WebSocketSession session) {
        this.ws = session;
    }

    public void updateWebSocketPlayer() {
        boolean isPlayerOpen;
        boolean bl = isPlayerOpen = this.ws != null && this.ws.isPlayerOpen();
        if (isPlayerOpen != this.isActive()) {
            this.setActive(isPlayerOpen);
        }
    }

    private static String getBrowserName(int browser) {
        return switch (browser) {
            case 1 -> "Chrome";
            case 2 -> "Internet Explorer";
            case 3 -> "Firefox";
            case 4 -> "Safari";
            case 5 -> "Playstation 4";
            case 6 -> "Xbox One";
            case 7 -> "Opera";
            case 8 -> "Edge";
            case 9 -> "Chromium";
            case 10 -> "Vivaldi";
            default -> Messages.getString("WebGuiClient");
        };
    }

    private static int getBrowser(String userAgent) {
        String ua = userAgent.toLowerCase();
        return ua.contains("edg") ? 8 : (ua.contains("chrome") ? 1 : (ua.contains("msie") || ua.contains("trident") ? 2 : (ua.contains("firefox") ? 3 : (ua.contains("safari") ? 4 : (ua.contains("playstation 4") ? 5 : (ua.contains("xbox one") ? 6 : (ua.contains("opera") ? 7 : (ua.contains("chromium") ? 9 : (ua.contains("vivaldi") ? 10 : 0)))))))));
    }
}

