/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.Renderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RendererFilter.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final List<String> FILTER = new ArrayList<String>();
    private static final Set<String> LOGGED = new HashSet<String>();

    private RendererFilter() {
    }

    public static synchronized void reset() {
        FILTER.clear();
        LOGGED.clear();
        String rendererFilter = CONFIGURATION.getRenderersFilter();
        if (rendererFilter != null) {
            String[] uuids;
            for (String uuid : uuids = rendererFilter.split(",")) {
                if (!StringUtils.isNotBlank(uuid)) continue;
                FILTER.add(uuid.toLowerCase());
            }
        }
        for (String uuid : FILTER) {
            Renderer renderer = ConnectedRenderers.getRendererByUUID(uuid);
            if (renderer == null) continue;
            renderer.setAllowed(RendererFilter.isAllowed(uuid, false));
        }
    }

    public static boolean isAllowed(String uuid) {
        return RendererFilter.isAllowed(uuid, true);
    }

    public static synchronized void setAllowed(String uuid, boolean isAllowed) {
        if (StringUtils.isBlank(uuid)) {
            return;
        }
        String uuidLowerCase = uuid.toLowerCase();
        if (isAllowed == RendererFilter.isAllowed(uuidLowerCase, false)) {
            LOGGER.trace("Renderer Filter: No change made, {} is already {}", (Object)uuidLowerCase, (Object)(isAllowed ? "allowed" : "blocked"));
            return;
        }
        if (CONFIGURATION.isRenderersBlockedByDefault()) {
            if (isAllowed) {
                FILTER.add(uuidLowerCase);
            } else {
                FILTER.remove(uuidLowerCase);
            }
        } else if (isAllowed) {
            FILTER.remove(uuidLowerCase);
        } else {
            FILTER.add(uuidLowerCase);
        }
        Renderer renderer = ConnectedRenderers.getRendererByUUID(uuidLowerCase);
        if (renderer != null) {
            renderer.setAllowed(isAllowed);
        }
        LOGGED.remove(uuidLowerCase);
        CONFIGURATION.setRenderersFilter(RendererFilter.getNormalizedFilter());
    }

    private static synchronized boolean isAllowed(String uuid, boolean logging) {
        if (StringUtils.isBlank(uuid)) {
            return !CONFIGURATION.isRenderersBlockedByDefault();
        }
        String uuidLowerCase = uuid.toLowerCase();
        boolean log = logging && RendererFilter.isFirstDecision(uuidLowerCase);
        boolean inFilter = FILTER.contains(uuidLowerCase);
        if (inFilter == CONFIGURATION.isRenderersBlockedByDefault()) {
            if (log) {
                LOGGER.trace("Renderer Filter: Access granted to {}", (Object)uuidLowerCase);
            }
            return true;
        }
        if (log) {
            LOGGER.trace("Renderer Filter: Access denied to {}", (Object)uuidLowerCase);
        }
        return false;
    }

    public static synchronized boolean getBlockedByDefault() {
        return CONFIGURATION.isRenderersBlockedByDefault();
    }

    public static synchronized void setBlockedByDefault(boolean value) {
        if (value != CONFIGURATION.isRenderersBlockedByDefault()) {
            CONFIGURATION.setRenderersFilter("");
            CONFIGURATION.setRenderersBlockedByDefault(value);
            RendererFilter.reset();
        }
    }

    private static synchronized String getNormalizedFilter() {
        StringBuilder b = new StringBuilder();
        if (!FILTER.isEmpty()) {
            for (String r : FILTER) {
                if (StringUtils.isBlank(r)) continue;
                b.append(r).append(",");
            }
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }

    private static synchronized boolean isFirstDecision(String uuid) {
        if (!LOGGED.contains(uuid)) {
            LOGGED.add(uuid);
            return true;
        }
        return false;
    }
}

