/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.windows;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import net.pms.platform.PlatformProgramPaths;
import net.pms.service.process.AbstractProcessTerminator;
import net.pms.service.process.ProcessInfo;
import net.pms.service.process.ProcessManager;
import net.pms.service.process.ProcessState;

public class WindowsProcessTerminator
extends AbstractProcessTerminator {
    public static final int CTRL_C_EVENT = 0;
    public static final int CTRL_BREAK_EVENT = 1;

    public WindowsProcessTerminator(@Nonnull ProcessManager owner) {
        super(owner);
    }

    @Override
    public void stopPlatformProcess(@Nullable ProcessInfo processInfo) throws InterruptedException {
        if (processInfo == null) {
            return;
        }
        if (processInfo.getState() == ProcessState.RUNNING) {
            if (this.stopWindowsProcessWMClosed(processInfo)) {
                processInfo.setState(ProcessState.WM_CLOSED);
                this.processes.put(this.getSchedule(processInfo.getTerminateTimeoutMS()), processInfo);
                return;
            }
            if (this.stopWindowsProcessCtrlEvent(processInfo, 0)) {
                processInfo.setState(ProcessState.CTRL_C);
                this.processes.put(this.getSchedule(processInfo.getTerminateTimeoutMS()), processInfo);
                return;
            }
        }
        if ((processInfo.getState() == ProcessState.RUNNING || processInfo.getState() == ProcessState.WM_CLOSED || processInfo.getState() == ProcessState.CTRL_C) && PlatformProgramPaths.get().getTaskKill() != null && this.stopWindowsProcessTaskKill(processInfo)) {
            processInfo.setState(ProcessState.TASKKILL);
            this.processes.put(this.getSchedule(processInfo.getTerminateTimeoutMS()), processInfo);
            return;
        }
        if (this.stopWindowsProcessTerminateProcess(processInfo)) {
            processInfo.setState(ProcessState.TERMINATEPROCESS);
            this.processes.put(this.getSchedule(Math.max(500L, processInfo.getTerminateTimeoutMS())), processInfo);
            return;
        }
        LOGGER.warn("All previous attempts to terminate process \"{}\" ({}) has failed, leaving it to the JVM and hoping for the best", (Object)processInfo.getName(), (Object)processInfo.getPID());
        this.destroyProcess(processInfo.getProcess());
    }

    protected boolean stopWindowsProcessTaskKill(@Nonnull ProcessInfo processInfo) throws InterruptedException {
        if (PlatformProgramPaths.get().getTaskKill() == null) {
            return false;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Attempting to stop timed out process \"{}\" ({}) with TaskKill", (Object)processInfo.getName(), (Object)processInfo.getPID());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(String.valueOf(PlatformProgramPaths.get().getTaskKill()), "/PID", Long.toString(processInfo.getPID()));
        processBuilder.redirectErrorStream(true);
        try {
            Process process = processBuilder.start();
            this.gobbleStream(process.getInputStream());
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                LOGGER.debug("TaskKill failed for process \"{}\" ({}) with exit code {}", processInfo.getName(), processInfo.getPID(), exitCode);
                return false;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Taskkill performed for process \"{}\" ({})", (Object)processInfo.getName(), (Object)processInfo.getPID());
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("TaskkKill for process \"{}\" ({}) failed with: {}", processInfo.getName(), processInfo.getPID(), e.getMessage());
            LOGGER.trace("", e);
            return false;
        }
    }

    protected boolean stopWindowsProcessCtrlEvent(@Nonnull ProcessInfo processInfo, int ctrlEvent) throws InterruptedException {
        if (PlatformProgramPaths.get().getCtrlSender() == null) {
            return false;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Attempting to stop timed out process \"{}\" ({}) with CtrlSender", (Object)processInfo.getName(), (Object)processInfo.getPID());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(String.valueOf(PlatformProgramPaths.get().getCtrlSender()), Long.toString(processInfo.getPID()), Integer.toString(ctrlEvent));
        processBuilder.redirectErrorStream(true);
        try {
            Process process = processBuilder.start();
            this.gobbleStream(process.getInputStream());
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                if (exitCode == 1) {
                    LOGGER.trace("CtrlSender could not attach to PID {} for process \"{}\"", (Object)processInfo.getPID(), (Object)processInfo.getName());
                } else {
                    LOGGER.warn("An internal error caused CtrlSender to exit with code {}", (Object)exitCode);
                }
                return false;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Ctrl + {} sent to process \"{}\" ({}) with CtrlSender", ctrlEvent == 0 ? "C" : (ctrlEvent == 1 ? "BREAK" : "?"), processInfo.getName(), processInfo.getPID());
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("CtrlSender for process \"{}\" ({}) failed with: {}", processInfo.getName(), processInfo.getPID(), e.getMessage());
            LOGGER.trace("", e);
            return false;
        }
    }

    protected boolean stopWindowsProcessWMClosed(@Nonnull ProcessInfo processInfo) {
        WinNT.HANDLE hProc;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Attempting to stop timed out process \"{}\" ({}) with WM_CLOSE", (Object)processInfo.getName(), (Object)processInfo.getPID());
        }
        if ((hProc = Kernel32.INSTANCE.OpenProcess(0x100001, false, (int)processInfo.getPID())) == null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Failed to get Windows handle for process \"{}\" ({}) during WM_CLOSE", (Object)processInfo.getName(), (Object)processInfo.getPID());
            }
            return false;
        }
        try (Memory posted = new Memory(1L);){
            posted.setByte(0L, (byte)0);
            Memory dwPID = new Memory(4L);
            dwPID.setInt(0L, (int)processInfo.getPID());
            User32.INSTANCE.EnumWindows((hWnd, data) -> {
                IntByReference dwID = new IntByReference();
                User32.INSTANCE.GetWindowThreadProcessId(hWnd, dwID);
                if (dwID.getValue() == data.getInt(0L)) {
                    User32.INSTANCE.PostMessage(hWnd, 16, new WinDef.WPARAM(0L), new WinDef.LPARAM(0L));
                    posted.setByte(0L, (byte)1);
                }
                return true;
            }, dwPID);
            Kernel32.INSTANCE.CloseHandle(hProc);
            if (LOGGER.isTraceEnabled()) {
                if (posted.getByte(0L) > 0) {
                    LOGGER.trace("WM_CLOSE sent to process \"{}\" ({}) with PostMessage", (Object)processInfo.getName(), (Object)processInfo.getPID());
                } else {
                    LOGGER.trace("Can't find any Windows belonging to process \"{}\" ({}), unable to send WM_CLOSE", (Object)processInfo.getName(), (Object)processInfo.getPID());
                }
            }
            boolean bl = posted.getByte(0L) > 0;
            return bl;
        }
    }

    protected boolean stopWindowsProcessTerminateProcess(@Nonnull ProcessInfo processInfo) {
        WinNT.HANDLE hProc;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Attempting to stop timed out process \"{}\" ({}) with TerminateProcess", (Object)processInfo.getName(), (Object)processInfo.getPID());
        }
        if ((hProc = Kernel32.INSTANCE.OpenProcess(1, false, (int)processInfo.getPID())) == null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Failed to get Windows handle for process \"{}\" ({}) during TerminateProcess", (Object)processInfo.getName(), (Object)processInfo.getPID());
            }
            return false;
        }
        boolean result = Kernel32.INSTANCE.TerminateProcess(hProc, 1);
        Kernel32.INSTANCE.CloseHandle(hProc);
        if (LOGGER.isTraceEnabled()) {
            if (result) {
                LOGGER.trace("TerminateProcess performed for process \"{}\" ({})", (Object)processInfo.getName(), (Object)processInfo.getPID());
            } else {
                LOGGER.trace("TerminateProcess failed for process \"{}\" ({})", (Object)processInfo.getName(), (Object)processInfo.getPID());
            }
        }
        return result;
    }
}

