/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StringByReference
extends PointerType {
    public StringByReference() {
    }

    public StringByReference(long dataSize) {
        super(dataSize < 1L ? Pointer.NULL : new Memory(dataSize + 1L));
    }

    public StringByReference(String value) {
        this(value, Charset.forName(Native.getDefaultStringEncoding()));
    }

    public StringByReference(String value, Charset charset) {
        if (value != null) {
            this.setValue(value, charset);
        }
    }

    public StringByReference(String value, String charsetName) {
        if (value != null) {
            this.setValue(value, charsetName);
        }
    }

    public void setValue(String value) {
        this.setValue(value, Native.getDefaultStringEncoding());
    }

    public final void setValue(String value, Charset charset) {
        this.setValue(value, charset.name());
    }

    public final void setValue(String value, String charsetName) {
        if (value == null) {
            this.setPointer(Pointer.NULL);
            return;
        }
        try {
            int length = value.getBytes(charsetName).length;
            if ((long)length > this.getAllocatedSize()) {
                this.setPointer(new Memory(length + 1));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding: " + charsetName, e);
        }
        this.getPointer().setString(0L, value, charsetName);
    }

    public String getValue() {
        return this.getValue(Native.getDefaultStringEncoding());
    }

    public String getValue(Charset charset) {
        return this.getValue(charset.name());
    }

    public String getValue(String charsetName) {
        return this.getPointer() == null ? null : this.getPointer().getString(0L, charsetName);
    }

    public long getAllocatedSize() {
        Pointer pointer = this.getPointer();
        if (pointer instanceof Memory) {
            Memory memory = (Memory)pointer;
            return Math.max(memory.size() - 1L, 0L);
        }
        return -1L;
    }

    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        if (nativeValue == null) {
            return null;
        }
        this.setPointer((Pointer)nativeValue);
        return this;
    }

    @Override
    public String toString() {
        if (this.getPointer() == null) {
            return "null";
        }
        return this.getValue();
    }
}

