/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;

public abstract class ArrayByReference<E>
extends PointerType {
    protected long size;

    protected ArrayByReference() {
    }

    public abstract int getElementSize();

    protected abstract E[] getElements();

    protected abstract void setElements(E[] var1);

    public void setSize(long size, long reAllocateThreshold) {
        if (size < 1L) {
            super.setPointer(Pointer.NULL);
            this.size = 0L;
        } else if (this.getPointer() instanceof Memory && (long)this.getElementSize() * size < ((Memory)this.getPointer()).size() && Math.abs(((Memory)this.getPointer()).size() - (long)this.getElementSize() * size) <= reAllocateThreshold) {
            this.size = size;
        } else {
            super.setPointer(new Memory((long)this.getElementSize() * size));
            this.size = size;
        }
    }

    public long getSize() {
        return this.size;
    }

    public boolean isGarbageCollected() {
        return this.getPointer() == null || this.getPointer() instanceof Memory;
    }

    public void setArray(E[] array, long reAllocateThreshold) {
        if (array == null) {
            throw new NullPointerException("array cannot be null");
        }
        this.setSize(array.length, reAllocateThreshold);
        if (array.length > 0) {
            this.setElements(array);
        }
    }

    public E[] getArray() {
        if (this.getPointer() == null) {
            return null;
        }
        if (this.size > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Array to big, please read it \"manually\" using getPointer.readX");
        }
        return this.getElements();
    }

    @Override
    public void setPointer(Pointer p) {
        if (!this.isGarbageCollected()) {
            throw new UnsupportedOperationException("The internal pointer points to native memory, setting it could lead to memory leak and is not supported");
        }
        super.setPointer(p);
    }

    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        if (nativeValue == null) {
            return null;
        }
        super.setPointer((Pointer)nativeValue);
        return this;
    }
}

