/*
 * Decompiled with CFR 0.152.
 */
package net.pms.parsers.mediainfo;

import java.io.File;
import net.pms.parsers.MediaInfoParser;
import net.pms.parsers.mediainfo.MediaInfoHelper;
import net.pms.parsers.mediainfo.StreamKind;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class MediaInfoParseLogger {
    private final StringBuilder sb = new StringBuilder();
    private final Columns generalColumns = new Columns(false, 2, 32, 62, 92);
    private final Columns streamColumns = new Columns(false, 4, 34, 64, 94);
    private final MediaInfoHelper mi;

    public MediaInfoParseLogger(MediaInfoHelper mi) {
        this.mi = mi;
    }

    private boolean appendStringNextColumn(Columns columns, String label, String value, boolean quote, boolean notBlank) {
        if (notBlank && StringUtils.isBlank(value)) {
            return false;
        }
        this.sb.append(columns.toNextColumnRelative(this.sb));
        this.appendString(label, value, true, quote, false);
        return true;
    }

    private boolean appendStringColumn(Columns columns, int column, String label, String value, boolean quote, boolean notBlank) {
        if (notBlank && StringUtils.isBlank(value)) {
            return false;
        }
        this.sb.append(columns.toColumn(this.sb, column));
        this.appendString(label, value, true, quote, false);
        return true;
    }

    private boolean appendString(String label, String value, boolean first, boolean quote, boolean notBlank) {
        if (notBlank && StringUtils.isBlank(value)) {
            return false;
        }
        if (!first) {
            this.sb.append(", ");
        }
        this.sb.append(label);
        if (quote) {
            this.sb.append(": \"");
        } else {
            this.sb.append(": ");
        }
        this.sb.append(quote ? value : value.trim());
        if (quote) {
            this.sb.append("\"");
        }
        return true;
    }

    private boolean appendExistsNextColumn(Columns columns, String label, String value, boolean booleanValues) {
        this.sb.append(columns.toNextColumnRelative(this.sb));
        this.appendExists(label, value, true, booleanValues);
        return true;
    }

    private boolean appendExistsColumn(Columns columns, int column, String label, String value, boolean booleanValues) {
        this.sb.append(columns.toColumn(this.sb, column));
        this.appendExists(label, value, true, booleanValues);
        return true;
    }

    private boolean appendExists(String label, String value, boolean first, boolean booleanValues) {
        if (!first) {
            this.sb.append(", ");
        }
        this.sb.append(label).append(": ");
        if (StringUtils.isBlank(value)) {
            this.sb.append(booleanValues ? "False" : "No");
        } else {
            this.sb.append(booleanValues ? "True" : "Yes");
        }
        return true;
    }

    public void logGeneral(File file) {
        if (file == null) {
            this.sb.append("MediaInfo parsing results for null:\n");
        } else {
            this.sb.append("MediaInfo parsing results for \"").append(file.getAbsolutePath()).append("\":\n");
        }
        if (this.mi == null) {
            this.sb.append("ERROR: LibMediaInfo instance is null");
            return;
        }
        if (!this.mi.isValid()) {
            this.sb.append("ERROR: LibMediaInfo instance not valid");
            return;
        }
        this.sb.append("  ");
        boolean first = true;
        first &= !this.appendString("CodecID", this.mi.get(StreamKind.GENERAL, 0, "CodecID"), first &= !this.appendString("Format", this.mi.get(StreamKind.GENERAL, 0, "Format"), first &= !this.appendString("Title", this.mi.get(StreamKind.GENERAL, 0, "Title"), first, true, true), true, false), true, true);
        Double durationSec = MediaInfoParser.parseDuration(this.mi.get(StreamKind.GENERAL, 0, "Duration"));
        if (durationSec != null) {
            first &= !this.appendString("Duration", StringUtil.formatDLNADuration(durationSec), first, false, true);
        }
        this.appendExists("Cover", this.mi.get(StreamKind.GENERAL, 0, "Cover_Data"), first &= !this.appendString("Stereoscopic", this.mi.get(StreamKind.GENERAL, 0, "StereoscopicLayout"), first &= !this.appendString("Overall Bitrate Max.", this.mi.get(StreamKind.GENERAL, 0, "OverallBitRate_Maximum"), first &= !this.appendString("Overall Bitrate Nom.", this.mi.get(StreamKind.GENERAL, 0, "OverallBitRate_Nominal"), first &= !this.appendString("Overall Bitrate", this.mi.get(StreamKind.GENERAL, 0, "OverallBitRate"), first &= !this.appendString("Overall Bitrate Mode", this.mi.get(StreamKind.GENERAL, 0, "OverallBitRate_Mode"), first, false, true), false, true), false, true), false, true), true, true), false);
        first = false;
        this.appendString("FPS", this.mi.get(StreamKind.GENERAL, 0, "FrameRate"), first, false, true);
        this.appendString("Track", this.mi.get(StreamKind.GENERAL, 0, "Track"), first, true, true);
        this.appendString("Album", this.mi.get(StreamKind.GENERAL, 0, "Album"), first, true, true);
        this.appendString("Performer", this.mi.get(StreamKind.GENERAL, 0, "Performer"), first, true, true);
        this.appendString("Genre", this.mi.get(StreamKind.GENERAL, 0, "Genre"), first, true, true);
        this.appendString("Rec Date", this.mi.get(StreamKind.GENERAL, 0, "Recorded_Date"), first, true, true);
    }

    public void logGeneralColumns(File file) {
        if (file == null) {
            this.sb.append("MediaInfo parsing results for null:\n");
        } else {
            this.sb.append("MediaInfo parsing results for \"").append(file.getAbsolutePath()).append("\":\n");
        }
        if (this.mi == null) {
            this.sb.append("ERROR: LibMediaInfo instance is null");
            return;
        }
        if (!this.mi.isValid()) {
            this.sb.append("ERROR: LibMediaInfo instance not valid");
            return;
        }
        this.generalColumns.reset();
        this.appendStringNextColumn(this.generalColumns, "Title", this.mi.get(StreamKind.GENERAL, 0, "Title"), true, true);
        this.appendStringNextColumn(this.generalColumns, "Format", this.mi.get(StreamKind.GENERAL, 0, "Format"), true, false);
        this.appendStringNextColumn(this.generalColumns, "CodecID", this.mi.get(StreamKind.GENERAL, 0, "CodecID"), true, true);
        Double durationSec = MediaInfoParser.parseDuration(this.mi.get(StreamKind.GENERAL, 0, "Duration"));
        if (durationSec != null) {
            this.appendStringNextColumn(this.generalColumns, "Duration", StringUtil.formatDLNADuration(durationSec), false, true);
        }
        this.appendStringNextColumn(this.generalColumns, "Overall Bitrate Mode", this.mi.get(StreamKind.GENERAL, 0, "OverallBitRate_Mode"), false, true);
        this.appendStringNextColumn(this.generalColumns, "Overall Bitrate", this.mi.get(StreamKind.GENERAL, 0, "OverallBitRate"), false, true);
        this.appendStringNextColumn(this.generalColumns, "Overall Bitrate Nom.", this.mi.get(StreamKind.GENERAL, 0, "OverallBitRate_Nominal"), false, true);
        this.appendStringNextColumn(this.generalColumns, "Overall Bitrate Max.", this.mi.get(StreamKind.GENERAL, 0, "OverallBitRate_Maximum"), false, true);
        this.appendStringNextColumn(this.generalColumns, "Stereoscopic", this.mi.get(StreamKind.GENERAL, 0, "StereoscopicLayout"), true, true);
        this.appendExistsNextColumn(this.generalColumns, "Cover", this.mi.get(StreamKind.GENERAL, 0, "Cover_Data"), false);
        this.appendStringNextColumn(this.generalColumns, "FPS", this.mi.get(StreamKind.GENERAL, 0, "FrameRate"), false, true);
        this.appendStringNextColumn(this.generalColumns, "Track", this.mi.get(StreamKind.GENERAL, 0, "Track"), true, true);
        this.appendStringNextColumn(this.generalColumns, "Album", this.mi.get(StreamKind.GENERAL, 0, "Album"), true, true);
        this.appendStringNextColumn(this.generalColumns, "Performer", this.mi.get(StreamKind.GENERAL, 0, "Performer"), true, true);
        this.appendStringNextColumn(this.generalColumns, "Genre", this.mi.get(StreamKind.GENERAL, 0, "Genre"), true, true);
        this.appendStringNextColumn(this.generalColumns, "Rec Date", this.mi.get(StreamKind.GENERAL, 0, "Recorded_Date"), true, true);
    }

    public void logVideoTrack(int idx) {
        if (this.mi == null || !this.mi.isValid()) {
            return;
        }
        this.sb.append("\n    - Video - ");
        boolean first = true;
        first &= !this.appendString("CodecID", this.mi.get(StreamKind.VIDEO, idx, "CodecID"), first &= !this.appendString("ID", this.mi.get(StreamKind.VIDEO, idx, "ID"), first &= !this.appendString("Profile", this.mi.get(StreamKind.VIDEO, idx, "Format_Profile"), first &= !this.appendString("Version", this.mi.get(StreamKind.VIDEO, idx, "Format_Version"), first &= !this.appendString("Format", this.mi.get(StreamKind.VIDEO, idx, "Format"), first, true, true), true, true), true, true), false, true), true, true);
        Double durationSec = MediaInfoParser.parseDuration(this.mi.get(StreamKind.VIDEO, 0, "Duration"));
        if (durationSec != null) {
            first &= !this.appendString("Duration", StringUtil.formatDLNADuration(durationSec), first, false, true);
        }
        this.appendString("TimeStamp_FirstFrame", this.mi.get(StreamKind.VIDEO, idx, "TimeStamp_FirstFrame"), first &= !this.appendString("Delay O. Source", this.mi.get(StreamKind.VIDEO, idx, "Delay_Original_Source"), first &= !this.appendString("Delay Original", this.mi.get(StreamKind.VIDEO, idx, "Delay_Original"), first &= !this.appendString("Delay Source", this.mi.get(StreamKind.VIDEO, idx, "Delay_Source"), first &= !this.appendString("Delay", this.mi.get(StreamKind.VIDEO, idx, "Delay"), first &= !this.appendString("Bit Depth", this.mi.get(StreamKind.VIDEO, idx, "BitDepth"), first &= !this.appendString("Encrypt", this.mi.get(StreamKind.VIDEO, idx, "Encryption"), first &= !this.appendString("Muxing Mode", this.mi.get(StreamKind.VIDEO, idx, "MuxingMode"), first &= !this.appendString("GOP", this.mi.get(StreamKind.VIDEO, idx, "Format_Settings_GOP"), first &= !this.appendString("GMC", this.mi.get(StreamKind.VIDEO, idx, "Format_Settings_GMC"), first &= !this.appendString("QPel", this.mi.get(StreamKind.VIDEO, idx, "Format_Settings_QPel"), first &= !this.appendString("RefFrames", this.mi.get(StreamKind.VIDEO, idx, "Format_Settings_RefFrames"), first &= !this.appendString("Framerate Mode", this.mi.get(StreamKind.VIDEO, idx, "FrameRate_Mode"), first &= !this.appendString("FPS Orig", this.mi.get(StreamKind.VIDEO, idx, "FrameRate_Original"), first &= !this.appendString("FPS", this.mi.get(StreamKind.VIDEO, idx, "FrameRate"), first &= !this.appendString("Scan Order", this.mi.get(StreamKind.VIDEO, idx, "ScanOrder"), first &= !this.appendString("Scan Type", this.mi.get(StreamKind.VIDEO, idx, "ScanType"), first &= !this.appendString("DAR Orig", this.mi.get(StreamKind.VIDEO, idx, "DisplayAspectRatio_Original/String"), first &= !this.appendString("DAR", this.mi.get(StreamKind.VIDEO, idx, "DisplayAspectRatio/String"), first &= !this.appendString("PAR", this.mi.get(StreamKind.VIDEO, idx, "PixelAspectRatio"), first &= !this.appendString("MultiView Layout", this.mi.get(StreamKind.VIDEO, idx, "MultiView_Layout"), first &= !this.appendString("Matrix Co", this.mi.get(StreamKind.VIDEO, idx, "matrix_coefficients"), first &= !this.appendString("Chroma", this.mi.get(StreamKind.VIDEO, idx, "ChromaSubsampling"), first &= !this.appendString("Colorimetry", this.mi.get(StreamKind.VIDEO, idx, "Colorimetry"), first &= !this.appendString("Height", this.mi.get(StreamKind.VIDEO, idx, "Height"), first &= !this.appendString("Width", this.mi.get(StreamKind.VIDEO, idx, "Width"), first &= !this.appendString("Bitrate Encoded", this.mi.get(StreamKind.VIDEO, idx, "BitRate_Encoded"), first &= !this.appendString("BitRate Maximum", this.mi.get(StreamKind.VIDEO, idx, "BitRate_Maximum"), first &= !this.appendString("Bitrate Nominal", this.mi.get(StreamKind.VIDEO, idx, "BitRate_Nominal"), first &= !this.appendString("Bitrate", this.mi.get(StreamKind.VIDEO, idx, "BitRate"), first &= !this.appendString("BitRate Mode", this.mi.get(StreamKind.VIDEO, idx, "BitRate_Mode"), first, false, true), false, true), false, true), false, true), false, true), false, true), false, true), false, true), false, true), false, true), true, true), false, true), false, true), false, true), false, true), false, true), false, true), false, true), false, true), false, true), true, true), true, true), true, true), true, true), true, true), false, true), false, true), false, true), false, true), false, true), false, true);
    }

    public void logVideoTrackColumns(int idx) {
        if (this.mi == null || !this.mi.isValid()) {
            return;
        }
        this.sb.append("\n  - Video track ");
        this.appendString("ID", this.mi.get(StreamKind.VIDEO, idx, "ID"), true, false, false);
        this.streamColumns.reset();
        this.sb.append("\n");
        this.appendStringNextColumn(this.streamColumns, "Format", this.mi.get(StreamKind.VIDEO, idx, "Format"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Version", this.mi.get(StreamKind.VIDEO, idx, "Format_Version"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Profile", this.mi.get(StreamKind.VIDEO, idx, "Format_Profile"), true, true);
        this.appendStringNextColumn(this.streamColumns, "CodecID", this.mi.get(StreamKind.VIDEO, idx, "CodecID"), true, true);
        Double durationSec = MediaInfoParser.parseDuration(this.mi.get(StreamKind.VIDEO, 0, "Duration"));
        if (durationSec != null) {
            this.appendStringNextColumn(this.streamColumns, "Duration", StringUtil.formatDLNADuration(durationSec), false, true);
        }
        this.appendStringNextColumn(this.streamColumns, "BitRate Mode", this.mi.get(StreamKind.VIDEO, idx, "BitRate_Mode"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Bitrate", this.mi.get(StreamKind.VIDEO, idx, "BitRate"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Bitrate Nominal", this.mi.get(StreamKind.VIDEO, idx, "BitRate_Nominal"), false, true);
        this.appendStringNextColumn(this.streamColumns, "BitRate Maximum", this.mi.get(StreamKind.VIDEO, idx, "BitRate_Maximum"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Bitrate Encoded", this.mi.get(StreamKind.VIDEO, idx, "BitRate_Encoded"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Width", this.mi.get(StreamKind.VIDEO, idx, "Width"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Height", this.mi.get(StreamKind.VIDEO, idx, "Height"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Colorimetry", this.mi.get(StreamKind.VIDEO, idx, "Colorimetry"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Chroma", this.mi.get(StreamKind.VIDEO, idx, "ChromaSubsampling"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Matrix Co", this.mi.get(StreamKind.VIDEO, idx, "matrix_coefficients"), false, true);
        this.appendStringNextColumn(this.streamColumns, "MultiView Layout", this.mi.get(StreamKind.VIDEO, idx, "MultiView_Layout"), true, true);
        this.appendStringNextColumn(this.streamColumns, "PAR", this.mi.get(StreamKind.VIDEO, idx, "PixelAspectRatio"), false, true);
        this.appendStringNextColumn(this.streamColumns, "DAR", this.mi.get(StreamKind.VIDEO, idx, "DisplayAspectRatio/String"), false, true);
        this.appendStringNextColumn(this.streamColumns, "DAR Orig", this.mi.get(StreamKind.VIDEO, idx, "DisplayAspectRatio_Original/String"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Scan Type", this.mi.get(StreamKind.VIDEO, idx, "ScanType"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Scan Order", this.mi.get(StreamKind.VIDEO, idx, "ScanOrder"), false, true);
        this.appendStringNextColumn(this.streamColumns, "FPS", this.mi.get(StreamKind.VIDEO, idx, "FrameRate"), false, true);
        this.appendStringNextColumn(this.streamColumns, "FPS Orig", this.mi.get(StreamKind.VIDEO, idx, "FrameRate_Original"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Framerate Mode", this.mi.get(StreamKind.VIDEO, idx, "FrameRate_Mode"), false, true);
        this.appendStringNextColumn(this.streamColumns, "RefFrames", this.mi.get(StreamKind.VIDEO, idx, "Format_Settings_RefFrames"), false, true);
        this.appendStringNextColumn(this.streamColumns, "QPel", this.mi.get(StreamKind.VIDEO, idx, "Format_Settings_QPel"), true, true);
        this.appendStringNextColumn(this.streamColumns, "GMC", this.mi.get(StreamKind.VIDEO, idx, "Format_Settings_GMC"), true, true);
        this.appendStringNextColumn(this.streamColumns, "GOP", this.mi.get(StreamKind.VIDEO, idx, "Format_Settings_GOP"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Muxing Mode", this.mi.get(StreamKind.VIDEO, idx, "MuxingMode"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Encrypt", this.mi.get(StreamKind.VIDEO, idx, "Encryption"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Bit Depth", this.mi.get(StreamKind.VIDEO, idx, "BitDepth"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Delay", this.mi.get(StreamKind.VIDEO, idx, "Delay"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Delay Source", this.mi.get(StreamKind.VIDEO, idx, "Delay_Source"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Delay Original", this.mi.get(StreamKind.VIDEO, idx, "Delay_Original"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Delay O. Source", this.mi.get(StreamKind.VIDEO, idx, "Delay_Original_Source"), false, true);
        this.appendStringNextColumn(this.streamColumns, "TimeStamp_FirstFrame", this.mi.get(StreamKind.VIDEO, idx, "TimeStamp_FirstFrame"), false, true);
    }

    public void logAudioTrack(int idx) {
        if (this.mi == null || !this.mi.isValid()) {
            return;
        }
        this.sb.append("\n    - Audio - ");
        boolean first = true;
        first &= !this.appendString("CodecID Desc", this.mi.get(StreamKind.AUDIO, idx, "CodecID_Description"), first &= !this.appendString("CodecID", this.mi.get(StreamKind.AUDIO, idx, "CodecID"), first &= !this.appendString("ID", this.mi.get(StreamKind.AUDIO, idx, "ID"), first &= !this.appendString("Profile", this.mi.get(StreamKind.AUDIO, idx, "Format_Profile"), first &= !this.appendString("Version", this.mi.get(StreamKind.AUDIO, idx, "Format_Version"), first &= !this.appendString("Format", this.mi.get(StreamKind.AUDIO, idx, "Format"), first &= !this.appendString("Title", this.mi.get(StreamKind.AUDIO, idx, "Title"), first, true, true), true, true), true, true), true, true), false, true), true, true), true, true);
        Double durationSec = MediaInfoParser.parseDuration(this.mi.get(StreamKind.AUDIO, 0, "Duration"));
        if (durationSec != null) {
            first &= !this.appendString("Duration", StringUtil.formatDLNADuration(durationSec), first, false, true);
        }
        this.appendString("Delay O. Source", this.mi.get(StreamKind.AUDIO, idx, "Delay_Original_Source"), first &= !this.appendString("Delay Original", this.mi.get(StreamKind.AUDIO, idx, "Delay_Original"), first &= !this.appendString("Delay Source", this.mi.get(StreamKind.AUDIO, idx, "Delay_Source"), first &= !this.appendString("Delay", this.mi.get(StreamKind.AUDIO, idx, "Delay"), first &= !this.appendString("Bit Depth", this.mi.get(StreamKind.AUDIO, idx, "BitDepth"), first &= !this.appendString("Track", this.mi.get(StreamKind.GENERAL, idx, "Track/Position"), first &= !this.appendString("Samplerate", this.mi.get(StreamKind.AUDIO, idx, "SamplingRate"), first &= !this.appendString("Channel(s)", this.mi.get(StreamKind.AUDIO, idx, "Channel(s)_Original"), first &= !this.appendString("Language", this.mi.get(StreamKind.AUDIO, idx, "Language"), first &= !this.appendString("Bitrate Encoded", this.mi.get(StreamKind.AUDIO, idx, "BitRate_Encoded"), first &= !this.appendString("BitRate Maximum", this.mi.get(StreamKind.AUDIO, idx, "BitRate_Maximum"), first &= !this.appendString("Bitrate Nominal", this.mi.get(StreamKind.AUDIO, idx, "BitRate_Nominal"), first &= !this.appendString("Bitrate", this.mi.get(StreamKind.AUDIO, idx, "BitRate"), first &= !this.appendString("BitRate Mode", this.mi.get(StreamKind.AUDIO, idx, "BitRate_Mode"), first, false, true), false, true), false, true), false, true), false, true), true, true), false, true), false, true), false, true), false, true), false, true), false, true), false, true), false, true);
    }

    public void logAudioTrackColumns(int idx) {
        if (this.mi == null || !this.mi.isValid()) {
            return;
        }
        this.sb.append("\n  - Audio track ");
        this.appendString("ID", this.mi.get(StreamKind.AUDIO, idx, "ID"), true, false, false);
        this.appendString("Title", this.mi.get(StreamKind.AUDIO, idx, "Title"), false, true, true);
        this.streamColumns.reset();
        this.sb.append("\n");
        this.appendStringNextColumn(this.streamColumns, "Format", this.mi.get(StreamKind.AUDIO, idx, "Format/String"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Version", this.mi.get(StreamKind.AUDIO, idx, "Format_Version"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Profile", this.mi.get(StreamKind.AUDIO, idx, "Format_Profile"), true, true);
        this.appendStringNextColumn(this.streamColumns, "CodecID", this.mi.get(StreamKind.AUDIO, idx, "CodecID"), true, true);
        this.appendStringNextColumn(this.streamColumns, "CodecID Desc", this.mi.get(StreamKind.AUDIO, idx, "CodecID_Description"), true, true);
        Double durationSec = MediaInfoParser.parseDuration(this.mi.get(StreamKind.AUDIO, 0, "Duration"));
        if (durationSec != null) {
            this.appendStringNextColumn(this.streamColumns, "Duration", StringUtil.formatDLNADuration(durationSec), false, true);
        }
        this.appendStringNextColumn(this.streamColumns, "BitRate Mode", this.mi.get(StreamKind.AUDIO, idx, "BitRate_Mode"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Bitrate", this.mi.get(StreamKind.AUDIO, idx, "BitRate"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Bitrate Nominal", this.mi.get(StreamKind.AUDIO, idx, "BitRate_Nominal"), false, true);
        this.appendStringNextColumn(this.streamColumns, "BitRate Maximum", this.mi.get(StreamKind.AUDIO, idx, "BitRate_Maximum"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Bitrate Encoded", this.mi.get(StreamKind.AUDIO, idx, "BitRate_Encoded"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Language", this.mi.get(StreamKind.AUDIO, idx, "Language"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Channel(s)", this.mi.get(StreamKind.AUDIO, idx, "Channel(s)"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Samplerate", this.mi.get(StreamKind.AUDIO, idx, "SamplingRate"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Track", this.mi.get(StreamKind.GENERAL, idx, "Track/Position"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Bit Depth", this.mi.get(StreamKind.AUDIO, idx, "BitDepth"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Delay", this.mi.get(StreamKind.AUDIO, idx, "Delay"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Delay Source", this.mi.get(StreamKind.AUDIO, idx, "Delay_Source"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Delay Original", this.mi.get(StreamKind.AUDIO, idx, "Delay_Original"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Delay O. Source", this.mi.get(StreamKind.AUDIO, idx, "Delay_Original_Source"), false, true);
    }

    public void logImage(int idx) {
        if (this.mi == null || !this.mi.isValid()) {
            return;
        }
        this.sb.append("\n    - Image - ");
        boolean first = true;
        this.appendString("Height", this.mi.get(StreamKind.IMAGE, idx, "Height"), first &= !this.appendString("Width", this.mi.get(StreamKind.IMAGE, idx, "Width"), first &= !this.appendString("ID", this.mi.get(StreamKind.IMAGE, idx, "ID"), first &= !this.appendString("Profile", this.mi.get(StreamKind.IMAGE, idx, "Format_Profile"), first &= !this.appendString("Version", this.mi.get(StreamKind.IMAGE, idx, "Format_Version"), first &= !this.appendString("Format", this.mi.get(StreamKind.IMAGE, idx, "Format"), first, true, true), true, true), true, true), false, true), false, true), false, true);
    }

    public void logImageColumns(int idx) {
        if (this.mi == null || !this.mi.isValid()) {
            return;
        }
        this.sb.append("\n  - Image ");
        this.appendString("ID", this.mi.get(StreamKind.IMAGE, idx, "ID"), true, false, false);
        this.streamColumns.reset();
        this.sb.append("\n");
        this.appendStringNextColumn(this.streamColumns, "Format", this.mi.get(StreamKind.IMAGE, idx, "Format"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Version", this.mi.get(StreamKind.IMAGE, idx, "Format_Version"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Profile", this.mi.get(StreamKind.IMAGE, idx, "Format_Profile"), true, true);
        this.appendStringNextColumn(this.streamColumns, "Width", this.mi.get(StreamKind.IMAGE, idx, "Width"), false, true);
        this.appendStringNextColumn(this.streamColumns, "Height", this.mi.get(StreamKind.IMAGE, idx, "Height"), false, true);
    }

    public void logSubtitleTrack(int idx, boolean videoSubtitle) {
        if (this.mi == null || !this.mi.isValid()) {
            return;
        }
        this.sb.append("\n    - Sub - ");
        boolean first = true;
        if (videoSubtitle) {
            this.appendString("ID", this.mi.get(StreamKind.VIDEO, idx, "ID"), first &= !this.appendString("Profile", this.mi.get(StreamKind.VIDEO, idx, "Format_Profile"), first &= !this.appendString("Version", this.mi.get(StreamKind.VIDEO, idx, "Format_Version"), first &= !this.appendString("Format", this.mi.get(StreamKind.VIDEO, idx, "Format"), first &= !this.appendString("Title", this.mi.get(StreamKind.VIDEO, idx, "Title"), first, true, true), true, true), true, true), true, true), false, true);
        } else {
            this.appendString("Language", this.mi.get(StreamKind.TEXT, idx, "Language"), first &= !this.appendString("ID", this.mi.get(StreamKind.TEXT, idx, "ID"), first &= !this.appendString("Profile", this.mi.get(StreamKind.TEXT, idx, "Format_Profile"), first &= !this.appendString("Version", this.mi.get(StreamKind.TEXT, idx, "Format_Version"), first &= !this.appendString("Format", this.mi.get(StreamKind.TEXT, idx, "Format"), first &= !this.appendString("Title", this.mi.get(StreamKind.TEXT, idx, "Title"), first, true, true), true, true), true, true), true, true), false, true), true, true);
        }
    }

    public void logSubtitleTrackColumns(int idx, boolean videoSubtitle) {
        if (this.mi == null || !this.mi.isValid()) {
            return;
        }
        this.sb.append("\n  - Subtitle ");
        this.streamColumns.reset();
        if (videoSubtitle) {
            this.appendString("ID", this.mi.get(StreamKind.VIDEO, idx, "ID"), true, false, false);
            this.appendString("Title", this.mi.get(StreamKind.VIDEO, idx, "Title"), false, true, true);
            this.sb.append("\n");
            this.appendStringNextColumn(this.streamColumns, "Format", this.mi.get(StreamKind.VIDEO, idx, "Format"), true, true);
            this.appendStringNextColumn(this.streamColumns, "Version", this.mi.get(StreamKind.VIDEO, idx, "Format_Version"), true, true);
            this.appendStringNextColumn(this.streamColumns, "Profile", this.mi.get(StreamKind.VIDEO, idx, "Format_Profile"), true, true);
        } else {
            this.appendString("ID", this.mi.get(StreamKind.TEXT, idx, "ID"), true, false, false);
            this.appendString("Title", this.mi.get(StreamKind.TEXT, idx, "Title"), false, true, true);
            this.sb.append("\n");
            this.appendStringNextColumn(this.streamColumns, "Format", this.mi.get(StreamKind.TEXT, idx, "Format"), true, true);
            this.appendStringNextColumn(this.streamColumns, "Version", this.mi.get(StreamKind.TEXT, idx, "Format_Version"), true, true);
            this.appendStringNextColumn(this.streamColumns, "Profile", this.mi.get(StreamKind.TEXT, idx, "Format_Profile"), true, true);
            this.appendStringNextColumn(this.streamColumns, "Language", this.mi.get(StreamKind.TEXT, idx, "Language"), true, true);
        }
    }

    public String toString() {
        return this.sb.toString();
    }

    protected static class Columns {
        private final boolean includeZeroColumn;
        private final int[] columns;
        private int lastColumn = -1;

        public Columns(boolean includeZeroColumn, int ... columns) {
            this.includeZeroColumn = includeZeroColumn;
            this.columns = columns;
        }

        public int lastColumn() {
            return this.lastColumn;
        }

        public int nextColumn() {
            if (this.lastColumn < 0 || this.lastColumn >= this.columns.length) {
                return this.includeZeroColumn ? 0 : 1;
            }
            return this.lastColumn + 1;
        }

        public void reset() {
            this.lastColumn = -1;
        }

        public String toNextColumnAbsolute(StringBuilder sb) {
            if (sb == null) {
                return "";
            }
            boolean newLine = false;
            int next = this.nextColumn();
            if (next < this.lastColumn) {
                newLine = true;
            }
            return newLine ? "\n" + this.toColumn(0, this.nextColumn()) : this.toColumn(sb, this.nextColumn());
        }

        public String toNextColumnRelative(StringBuilder sb) {
            if (sb == null) {
                return "";
            }
            boolean newLine = false;
            int linePosition = Columns.getLinePosition(sb);
            int column = -1;
            if (this.includeZeroColumn && linePosition == 0) {
                column = 0;
            } else {
                for (int i = 0; i < this.columns.length; ++i) {
                    if (this.columns[i] <= linePosition) continue;
                    column = i + 1;
                    break;
                }
            }
            if (column < 0) {
                column = this.includeZeroColumn ? 0 : 1;
                newLine = true;
            }
            return newLine ? "\n" + this.toColumn(0, column) : this.toColumn(linePosition, column);
        }

        public String toColumn(StringBuilder sb, int column) {
            if (sb == null || column > this.columns.length) {
                return "";
            }
            return this.toColumn(Columns.getLinePosition(sb), column);
        }

        public String toColumn(int linePosition, int column) {
            if (column > this.columns.length || linePosition < 0) {
                return "";
            }
            if (column < 1) {
                this.lastColumn = 0;
                return linePosition > 0 ? " " : "";
            }
            this.lastColumn = column;
            int fill = this.columns[column - 1] - linePosition;
            if (fill < 1 && linePosition > 0) {
                fill = 1;
            }
            return fill > 0 ? StringUtil.fillString(" ", fill) : "";
        }

        public static int getLinePosition(StringBuilder sb) {
            if (sb == null) {
                return 0;
            }
            int position = sb.lastIndexOf("\n");
            position = position < 0 ? sb.length() : sb.length() - position - 1;
            return position;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Columns: 0");
            for (int column : this.columns) {
                sb.append(", ").append(column);
            }
            return sb.toString();
        }
    }
}

