/*
 * Decompiled with CFR 0.152.
 */
package net.pms.parsers.mediainfo;

import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.util.HashMap;
import net.pms.platform.PlatformProgramPaths;
import net.pms.platform.windows.WindowsProgramPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface MediaInfoLibrary
extends Library {
    public static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoLibrary.class);
    public static final MediaInfoLibrary INSTANCE = MediaInfoLibrary.createInstance();

    public Pointer New();

    public void Delete(Pointer var1);

    public SizeT Open(Pointer var1, WString var2);

    public void Close(Pointer var1);

    public WString Inform(Pointer var1);

    public WString Get(Pointer var1, int var2, SizeT var3, WString var4, int var5, int var6);

    public WString GetI(Pointer var1, int var2, SizeT var3, SizeT var4, int var5);

    public SizeT Count_Get(Pointer var1, int var2, SizeT var3);

    public WString Option(Pointer var1, WString var2, WString var3);

    public static MediaInfoLibrary createInstance() {
        String libraryName = "mediainfo";
        if (Platform.isWindows() && System.getProperty("jna.library.path") == null && PlatformProgramPaths.get() instanceof WindowsProgramPaths && ((WindowsProgramPaths)PlatformProgramPaths.get()).getMediaInfo() != null) {
            String jnaPath = ((WindowsProgramPaths)PlatformProgramPaths.get()).getMediaInfo().toString();
            LOGGER.info("JNA Library folder set to: \"{}\"", (Object)jnaPath);
            System.setProperty("jna.library.path", jnaPath);
        }
        if (!Platform.isWindows() && !Platform.isMac()) {
            try {
                NativeLibrary.getInstance("zen");
            }
            catch (LinkageError e) {
                LOGGER.warn("Error loading libzen: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("function-mapper", (lib, method) -> "MediaInfo_" + method.getName());
        if (!Platform.isWindows()) {
            options.put("string-encoding", "UTF-8");
        }
        return Native.load(libraryName, MediaInfoLibrary.class, options);
    }

    public static class SizeT
    extends IntegerType {
        private static final long serialVersionUID = 1L;

        public SizeT() {
            super(Native.SIZE_T_SIZE, true);
        }

        public SizeT(long value) {
            super(Native.SIZE_T_SIZE, value, true);
        }
    }
}

