/*
 * Decompiled with CFR 0.152.
 */
package net.pms.parsers;

import com.drew.imaging.FileType;
import com.drew.imaging.FileTypeDetector;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.bmp.BmpMetadataReader;
import com.drew.imaging.gif.GifMetadataReader;
import com.drew.imaging.ico.IcoMetadataReader;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.pcx.PcxMetadataReader;
import com.drew.imaging.png.PngMetadataReader;
import com.drew.imaging.psd.PsdMetadataReader;
import com.drew.imaging.raf.RafMetadataReader;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.webp.WebpMetadataReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.bmp.BmpHeaderDirectory;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.gif.GifHeaderDirectory;
import com.drew.metadata.ico.IcoDirectory;
import com.drew.metadata.jfif.JfifDirectory;
import com.drew.metadata.jpeg.JpegDirectory;
import com.drew.metadata.pcx.PcxDirectory;
import com.drew.metadata.photoshop.PsdHeaderDirectory;
import com.drew.metadata.png.PngDirectory;
import com.drew.metadata.webp.WebpDirectory;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import net.pms.image.ExifInfo;
import net.pms.image.ExifOrientation;
import net.pms.image.ImageFormat;
import net.pms.image.ImageIORuntimeException;
import net.pms.image.ImageIOTools;
import net.pms.image.ImageInfo;
import net.pms.media.MediaInfo;
import net.pms.parsers.JaudiotaggerParser;
import net.pms.parsers.Parser;
import net.pms.util.InputFile;
import net.pms.util.ParseException;
import net.pms.util.ResettableInputStream;
import net.pms.util.UnknownFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataExtractorParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaudiotaggerParser.class);
    public static final String PARSER_NAME = "Drew";

    private MetadataExtractorParser() {
    }

    public static void parse(InputFile inputFile, MediaInfo mediaInfo) throws IOException {
        if (inputFile.getFile() != null) {
            MetadataExtractorParser.parse(inputFile.getFile(), mediaInfo);
        } else if (inputFile.getPush() != null) {
            try (PipedOutputStream out = new PipedOutputStream();
                 PipedInputStream fis = new PipedInputStream(out);){
                inputFile.getPush().push(out);
                MetadataExtractorParser.parseStream(fis, inputFile.getSize(), inputFile.getFilename(), mediaInfo);
            }
            catch (IOException e) {
                LOGGER.debug("Error reading \"{}\": {}", (Object)inputFile.getFilename(), (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        } else {
            throw new IllegalArgumentException("parseImage: inputFile cannot be null");
        }
    }

    public static void parse(File file, MediaInfo mediaInfo) throws IOException {
        long size = file.length();
        InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
        String filename = file.getAbsolutePath();
        MetadataExtractorParser.parseStream(fis, size, filename, mediaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseStream(InputStream stream, long size, String filename, MediaInfo mediaInfo) throws IOException {
        int maxBuffer = 0x100000;
        if (stream == null) {
            throw new IllegalArgumentException("parseImage: stream cannot be null");
        }
        if (mediaInfo == null) {
            throw new IllegalArgumentException("parseImage: media cannot be null");
        }
        boolean trace = LOGGER.isTraceEnabled();
        if (trace) {
            LOGGER.trace("Parsing image file \"{}\"", (Object)filename);
        }
        try (ResettableInputStream inputStream = new ResettableInputStream(stream, 0x100000);){
            ImageInfo imageInfo;
            ImageFormat format;
            Metadata metadata;
            block28: {
                ImageFormat tmpformat;
                FileType fileType = null;
                try {
                    fileType = FileTypeDetector.detectFileType(inputStream);
                    metadata = MetadataExtractorParser.getMetadata((InputStream)inputStream, fileType);
                }
                catch (IOException e) {
                    metadata = new Metadata();
                    LOGGER.debug("Error reading \"{}\": {}", (Object)filename, (Object)e.getMessage());
                    LOGGER.trace("", e);
                }
                catch (ImageProcessingException e) {
                    metadata = new Metadata();
                    LOGGER.debug("Error parsing {} metadata for \"{}\": {}", fileType != null ? fileType.toString().toUpperCase(Locale.ROOT) : "null", filename, e.getMessage());
                    LOGGER.trace("", e);
                }
                format = MetadataExtractorParser.toImageFormat(fileType);
                if ((format == null || format == ImageFormat.TIFF) && (tmpformat = MetadataExtractorParser.toImageFormat(metadata)) != null) {
                    format = tmpformat;
                }
                if (inputStream.isFullResetAvailable()) {
                    inputStream.fullReset();
                } else {
                    inputStream.close();
                    inputStream = new ResettableInputStream(stream, 0x100000);
                }
                imageInfo = null;
                try {
                    imageInfo = MetadataExtractorParser.readImageInfo(inputStream, size, metadata, false);
                }
                catch (IIOException | ParseException | UnknownFormatException e) {
                    if (format == null) {
                        throw new UnknownFormatException("Unable to recognize image format for \"" + filename + "\" - parsing failed", e);
                    }
                    LOGGER.debug("Unable to parse \"{}\" with ImageIO because the format is unsupported, image information will be limited", (Object)filename);
                    LOGGER.trace("ImageIO parse failure reason: {}", (Object)e.getMessage());
                    if (metadata == null) break block28;
                    try {
                        imageInfo = ImageInfo.create(metadata, format, size, true, true);
                    }
                    catch (ParseException pe) {
                        LOGGER.debug("Unable to parse metadata for \"{}\": {}", (Object)filename, (Object)pe.getMessage());
                        LOGGER.trace("", pe);
                    }
                }
            }
            if (imageInfo == null && format == null) {
                throw new ParseException("Parsing of \"" + filename + "\" failed");
            }
            if (format == null && imageInfo != null) {
                format = imageInfo.getFormat();
            } else if (imageInfo != null && imageInfo.getFormat() != null && format != null && format != imageInfo.getFormat()) {
                if (imageInfo.getFormat() == ImageFormat.TIFF && format.isRaw()) {
                    if (format == ImageFormat.ARW && !MetadataExtractorParser.isARW(metadata)) {
                        format = MetadataExtractorParser.toImageFormat(metadata);
                        if (format == null) {
                            format = ImageFormat.TIFF;
                        }
                        LOGGER.trace("Correcting misidentified image format ARW to {} for \"{}\"", (Object)format, (Object)filename);
                    } else {
                        imageInfo = ImageInfo.create(imageInfo.getWidth(), imageInfo.getHeight(), format, size, imageInfo.getBitDepth(), imageInfo.getNumComponents(), imageInfo.getColorSpace(), imageInfo.getColorSpaceType(), metadata, false, imageInfo.isImageIOSupported());
                        LOGGER.trace("Correcting misidentified image format TIFF to {} for \"{}\"", (Object)format.toString(), (Object)filename);
                    }
                } else {
                    LOGGER.debug("Image parsing for \"{}\" was inconclusive, metadata parsing detected {} format while ImageIO detected {}. Choosing {}.", new Object[]{filename, format, imageInfo.getFormat(), imageInfo.getFormat()});
                    format = imageInfo.getFormat();
                }
            }
            mediaInfo.setImageInfo(imageInfo);
            mediaInfo.setImageCount(1);
            if (format != null) {
                mediaInfo.setContainer(format.toFormatConfiguration());
            }
            mediaInfo.setSize(size);
            mediaInfo.setMediaParser(PARSER_NAME);
            Parser.postParse(mediaInfo, 2);
            if (trace) {
                LOGGER.trace("Parsing of image \"{}\" completed", (Object)filename);
            }
        }
    }

    public static ImageFormat toImageFormat(Metadata metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata cannot be null");
        }
        for (Directory directory : metadata.getDirectories()) {
            if (directory instanceof BmpHeaderDirectory) {
                return ImageFormat.BMP;
            }
            if (directory instanceof GifHeaderDirectory) {
                return ImageFormat.GIF;
            }
            if (directory instanceof IcoDirectory) {
                return ImageFormat.ICO;
            }
            if (directory instanceof JfifDirectory || directory instanceof JpegDirectory) {
                return ImageFormat.JPEG;
            }
            if (directory instanceof PcxDirectory) {
                return ImageFormat.PCX;
            }
            if (directory instanceof PngDirectory) {
                return ImageFormat.PNG;
            }
            if (directory instanceof PsdHeaderDirectory) {
                return ImageFormat.PSD;
            }
            if (!(directory instanceof WebpDirectory)) continue;
            return ImageFormat.WEBP;
        }
        Enum exifCompression = null;
        for (Directory directory : metadata.getDirectories()) {
            Integer i;
            if (!(directory instanceof ExifIFD0Directory) && !(directory instanceof ExifSubIFDDirectory)) continue;
            if (((ExifDirectoryBase)directory).containsTag(259) && (i = ((ExifDirectoryBase)directory).getInteger(259)) != null) {
                exifCompression = ExifInfo.ExifCompression.typeOf(i);
            }
            if (!directory.containsTag(50706)) continue;
            return ImageFormat.DNG;
        }
        if (exifCompression != null) {
            switch (1.$SwitchMap$net$pms$image$ExifInfo$ExifCompression[exifCompression.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    return ImageFormat.TIFF;
                }
                case 19: 
                case 20: {
                    return ImageFormat.DCR;
                }
                case 21: {
                    return ImageFormat.KDC;
                }
                case 22: {
                    return ImageFormat.NEF;
                }
                case 23: {
                    return ImageFormat.PEF;
                }
                case 24: 
                case 25: {
                    return ImageFormat.SRW;
                }
                case 26: {
                    return ImageFormat.ARW;
                }
            }
        }
        return null;
    }

    public static ImageFormat toImageFormat(FileType fileType) {
        if (fileType == null) {
            return null;
        }
        switch (fileType) {
            case Arw: {
                return ImageFormat.ARW;
            }
            case Bmp: {
                return ImageFormat.BMP;
            }
            case Cr2: {
                return ImageFormat.CR2;
            }
            case Crw: {
                return ImageFormat.CRW;
            }
            case Gif: {
                return ImageFormat.GIF;
            }
            case Ico: {
                return ImageFormat.ICO;
            }
            case Jpeg: {
                return ImageFormat.JPEG;
            }
            case Nef: {
                return ImageFormat.NEF;
            }
            case Orf: {
                return ImageFormat.ORF;
            }
            case Pcx: {
                return ImageFormat.PCX;
            }
            case Png: {
                return ImageFormat.PNG;
            }
            case Psd: {
                return ImageFormat.PSD;
            }
            case Raf: {
                return ImageFormat.RAF;
            }
            case Rw2: {
                return ImageFormat.RW2;
            }
            case Tiff: {
                return ImageFormat.TIFF;
            }
            case Riff: 
            case WebP: {
                return ImageFormat.WEBP;
            }
        }
        return null;
    }

    public static boolean isARW(Metadata metadata) {
        if (metadata == null) {
            return false;
        }
        Collection<ExifSubIFDDirectory> directories = metadata.getDirectoriesOfType(ExifSubIFDDirectory.class);
        for (ExifSubIFDDirectory directory : directories) {
            if (!directory.containsTag(259) || directory.getInteger(259) == null || directory.getInteger(259) != Short.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    public static Metadata getMetadata(byte[] bytes, ImageFormat format) throws ImageProcessingException, IOException {
        return MetadataExtractorParser.getMetadata(bytes, format, null);
    }

    public static Metadata getMetadata(byte[] bytes, FileType fileType) throws ImageProcessingException, IOException {
        return MetadataExtractorParser.getMetadata(bytes, null, fileType);
    }

    public static Metadata getMetadata(byte[] bytes, ImageFormat format, FileType fileType) throws ImageProcessingException, IOException {
        if (bytes == null) {
            return null;
        }
        return MetadataExtractorParser.getMetadata(new ByteArrayInputStream(bytes), format, fileType);
    }

    public static Metadata getMetadata(InputStream inputStream, ImageFormat format) throws ImageProcessingException, IOException {
        return MetadataExtractorParser.getMetadata(inputStream, format, null);
    }

    public static Metadata getMetadata(InputStream inputStream, FileType fileType) throws ImageProcessingException, IOException {
        return MetadataExtractorParser.getMetadata(inputStream, null, fileType);
    }

    public static Metadata getMetadata(InputStream inputStream, ImageFormat format, FileType fileType) throws ImageProcessingException, IOException {
        Metadata metadata;
        if (inputStream == null) {
            return null;
        }
        if (format == null && fileType == null) {
            throw new IllegalArgumentException("Either format or fileType must be non-null");
        }
        if (fileType != null) {
            metadata = switch (fileType) {
                case FileType.Bmp -> BmpMetadataReader.readMetadata(inputStream);
                case FileType.Gif -> GifMetadataReader.readMetadata(inputStream);
                case FileType.Ico -> IcoMetadataReader.readMetadata(inputStream);
                case FileType.Jpeg -> JpegMetadataReader.readMetadata(inputStream);
                case FileType.Pcx -> PcxMetadataReader.readMetadata(inputStream);
                case FileType.Png -> PngMetadataReader.readMetadata(inputStream);
                case FileType.Psd -> PsdMetadataReader.readMetadata(inputStream);
                case FileType.Raf -> RafMetadataReader.readMetadata(inputStream);
                case FileType.Riff, FileType.WebP -> WebpMetadataReader.readMetadata(inputStream);
                case FileType.Arw, FileType.Cr2, FileType.Nef, FileType.Orf, FileType.Rw2, FileType.Tiff -> TiffMetadataReader.readMetadata(new RandomAccessStreamReader(inputStream, 2048, -1L));
                default -> new Metadata();
            };
        } else {
            metadata = switch (format) {
                case ImageFormat.BMP -> BmpMetadataReader.readMetadata(inputStream);
                case ImageFormat.GIF -> GifMetadataReader.readMetadata(inputStream);
                case ImageFormat.ICO -> IcoMetadataReader.readMetadata(inputStream);
                case ImageFormat.JPEG -> JpegMetadataReader.readMetadata(inputStream);
                case ImageFormat.DCX, ImageFormat.PCX -> PcxMetadataReader.readMetadata(inputStream);
                case ImageFormat.PNG -> PngMetadataReader.readMetadata(inputStream);
                case ImageFormat.PSD -> PsdMetadataReader.readMetadata(inputStream);
                case ImageFormat.RAF -> RafMetadataReader.readMetadata(inputStream);
                case ImageFormat.TIFF, ImageFormat.ARW, ImageFormat.CR2, ImageFormat.NEF, ImageFormat.ORF, ImageFormat.RW2 -> TiffMetadataReader.readMetadata(new RandomAccessStreamReader(inputStream, 2048, -1L));
                case ImageFormat.WEBP -> WebpMetadataReader.readMetadata(inputStream);
                case ImageFormat.SOURCE -> ImageMetadataReader.readMetadata(inputStream);
                default -> new Metadata();
            };
        }
        return metadata;
    }

    public static ExifOrientation parseExifOrientation(Metadata metadata) {
        return MetadataExtractorParser.parseExifOrientation(metadata, ExifOrientation.TOP_LEFT);
    }

    public static ExifOrientation parseExifOrientation(Metadata metadata, ExifOrientation defaultOrientation) {
        if (metadata == null) {
            return defaultOrientation;
        }
        try {
            for (Directory directory : metadata.getDirectories()) {
                ExifIFD0Directory exifIFD0Directory;
                if (!(directory instanceof ExifIFD0Directory) || !(exifIFD0Directory = (ExifIFD0Directory)directory).containsTag(274)) continue;
                return ExifOrientation.typeOf(exifIFD0Directory.getInt(274));
            }
        }
        catch (MetadataException e) {
            return defaultOrientation;
        }
        return defaultOrientation;
    }

    public static byte[] getThumbnailFromMetadata(File file, Metadata metadata) {
        if (metadata == null) {
            return null;
        }
        return null;
    }

    public static int getJPEGExifIFDTagOffset(int tagId, RandomAccessReader reader) throws UnknownFormatException, IOException {
        reader.setMotorolaByteOrder(true);
        if (reader.getUInt16(0) != 65496) {
            throw new UnknownFormatException("Content isn't JPEG");
        }
        byte jpegSegmentIdentifier = -1;
        byte markerEOI = -39;
        byte app1 = -31;
        String exifSegmentPreamble = "Exif\u0000\u0000";
        byte segmentIdentifier = reader.getInt8(2);
        byte segmentType = reader.getInt8(3);
        int pos = 4;
        while (segmentIdentifier != jpegSegmentIdentifier || segmentType != app1 && segmentType != markerEOI || segmentType == app1 && !"Exif\u0000\u0000".equals(new String(reader.getBytes(pos + 2, "Exif\u0000\u0000".length()), 0, "Exif\u0000\u0000".length(), StandardCharsets.US_ASCII))) {
            segmentIdentifier = segmentType;
            segmentType = reader.getInt8(pos++);
        }
        if (segmentType == markerEOI) {
            return -1;
        }
        int segmentLength = reader.getUInt16(pos) - 2;
        pos += 2 + "Exif\u0000\u0000".length();
        if (segmentLength < "Exif\u0000\u0000".length()) {
            throw new ParseException("Exif segment is too small");
        }
        int exifHeaderOffset = pos;
        short byteOrderIdentifier = reader.getInt16(pos);
        pos += 4;
        switch (byteOrderIdentifier) {
            case 19789: {
                reader.setMotorolaByteOrder(true);
                break;
            }
            case 18761: {
                reader.setMotorolaByteOrder(false);
                break;
            }
            default: {
                throw new ParseException("Can't determine Exif endianness from: 0x" + Integer.toHexString(byteOrderIdentifier));
            }
        }
        pos = reader.getInt32(pos) + exifHeaderOffset;
        int tagCount = reader.getUInt16(pos);
        for (int tagNumber = 0; tagNumber < tagCount; ++tagNumber) {
            int tagOffset = pos + 2 + 12 * tagNumber;
            int curTagId = reader.getUInt16(tagOffset);
            if (curTagId != tagId) continue;
            return tagOffset + 8;
        }
        return -1;
    }

    public static Dimension getJPEGResolution(RandomAccessReader reader) throws UnknownFormatException, IOException {
        reader.setMotorolaByteOrder(true);
        if (reader.getUInt16(0) != 65496) {
            throw new UnknownFormatException("Content isn't JPEG");
        }
        byte jpegSegmentIdentifier = -1;
        byte markerEOI = -39;
        Set<Byte> sofs = Set.of((byte)-64, (byte)-63, (byte)-62, (byte)-61, (byte)-59, (byte)-58, (byte)-57, (byte)-56, (byte)-55, (byte)-54, (byte)-53, (byte)-51, (byte)-50, (byte)-49);
        byte segmentIdentifier = reader.getInt8(2);
        byte segmentType = reader.getInt8(3);
        int pos = 4;
        while (segmentIdentifier != jpegSegmentIdentifier || !sofs.contains(segmentType) && segmentType != markerEOI) {
            segmentIdentifier = segmentType;
            segmentType = reader.getInt8(pos++);
        }
        if (segmentType == markerEOI) {
            return null;
        }
        int segmentLength = reader.getUInt16(pos) - 2;
        pos += 3;
        if (segmentLength < 5) {
            throw new ParseException("SOF segment is too small");
        }
        return new Dimension(reader.getUInt16(pos + 2), reader.getUInt16(pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageInfo readImageInfo(InputStream inputStream, long size, Metadata metadata, boolean applyExifOrientation) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("input == null!");
        }
        try (ImageInputStream stream = ImageIOTools.createImageInputStream(inputStream);){
            Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
            if (!iter.hasNext()) {
                throw new UnknownFormatException("Unable to find a suitable image reader");
            }
            ImageReader reader = iter.next();
            try {
                boolean imageIOSupport;
                int width = -1;
                int height = -1;
                ImageFormat format = ImageFormat.toImageFormat(reader.getFormatName());
                if (format == null) {
                    throw new UnknownFormatException("Unable to determine image format");
                }
                ColorModel colorModel = null;
                try {
                    reader.setInput(stream, true, true);
                    Iterator<ImageTypeSpecifier> iterator = reader.getImageTypes(0);
                    if (iterator.hasNext()) {
                        colorModel = iterator.next().getColorModel();
                    }
                    width = reader.getWidth(0);
                    height = reader.getHeight(0);
                }
                catch (RuntimeException e) {
                    throw new ImageIORuntimeException("Error reading image information: " + e.getMessage(), e);
                }
                if (format == ImageFormat.TIFF) {
                    try {
                        ImageReadParam param = reader.getDefaultReadParam();
                        param.setSourceRegion(new Rectangle(1, 1));
                        reader.read(0, param);
                        imageIOSupport = true;
                    }
                    catch (IOException e) {
                        imageIOSupport = false;
                    }
                } else {
                    imageIOSupport = true;
                }
                ImageInfo imageInfo = ImageInfo.create(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
                reader.dispose();
                return imageInfo;
            }
            catch (Throwable throwable) {
                reader.dispose();
                throw throwable;
            }
        }
    }
}

