/*
 * Decompiled with CFR 0.152.
 */
package net.pms.parsers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.dlna.DLNAThumbnail;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.StandardEngineId;
import net.pms.formats.AudioAsVideo;
import net.pms.formats.Format;
import net.pms.formats.v2.SubtitleType;
import net.pms.io.FailSafeProcessWrapper;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.media.chapter.MediaChapter;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.parsers.JaudiotaggerParser;
import net.pms.parsers.MetadataExtractorParser;
import net.pms.parsers.Parser;
import net.pms.store.ThumbnailSource;
import net.pms.util.InputFile;
import net.pms.util.MpegUtil;
import net.pms.util.ProcessUtil;
import net.pms.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FFmpegParser.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    public static final String PARSER_NAME = "FFmpeg";
    private static String version;

    private FFmpegParser() {
    }

    public static void parse(MediaInfo media, InputFile inputFile, Format ext, int type) {
        if (!media.waitMediaParsing(5) || media.isMediaParsed()) {
            return;
        }
        if (inputFile != null) {
            File file = inputFile.getFile();
            if (file != null) {
                media.setSize(file.length());
            } else {
                media.setSize(inputFile.getSize());
            }
            boolean ffmpegParsing = true;
            if (file != null && type == 1 || ext instanceof AudioAsVideo) {
                ffmpegParsing = false;
                JaudiotaggerParser.parse(media, file, ext);
            }
            if (type == 2) {
                try {
                    ffmpegParsing = false;
                    MetadataExtractorParser.parse(inputFile, media);
                    media.setImageCount(media.getImageCount() + 1);
                }
                catch (IOException e) {
                    LOGGER.debug("Error parsing image \"{}\", switching to FFmpeg: {}", (Object)inputFile.getFilename(), (Object)e.getMessage());
                    LOGGER.trace("", e);
                    ffmpegParsing = true;
                }
            }
            if (ffmpegParsing) {
                FFmpegParser.parse(media, inputFile);
                if (file != null && "mpegts".equals(media.getContainer()) && media.getDefaultVideoTrack() != null && media.getDefaultVideoTrack().isH264() && media.getDurationInSeconds() == 0.0) {
                    try {
                        int length = MpegUtil.getDurationFromMpeg(file);
                        if (length > 0) {
                            media.setDuration(Double.valueOf(length));
                        }
                    }
                    catch (IOException e) {
                        LOGGER.trace("Error retrieving length: " + e.getMessage());
                    }
                }
            }
            Parser.postParse(media, type);
        }
    }

    private static void parse(MediaInfo media, InputFile inputFile) {
        String engine = EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO);
        if (engine == null) {
            LOGGER.warn("Cannot parse since the FFmpeg executable is undefined");
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(engine);
        args.add("-hide_banner");
        args.add("-i");
        String input = inputFile.getFile() != null ? ProcessUtil.getSystemPathName(inputFile.getFile().getAbsolutePath()) : "-";
        args.add(input);
        args.add("-vn");
        args.add("-an");
        args.add("-dn");
        args.add("-sn");
        OutputParams params = new OutputParams(CONFIGURATION);
        params.setMaxBufferSize(1.0);
        params.setStdIn(inputFile.getPush());
        params.setNoExitCheck(true);
        ProcessWrapperImpl pw = new ProcessWrapperImpl((String[])args.toArray(String[]::new), true, params, false, true);
        FailSafeProcessWrapper fspw = new FailSafeProcessWrapper(pw, 10000L);
        media.setParsing(true);
        fspw.runInSameThread();
        if (fspw.hasFail()) {
            LOGGER.info("Error parsing information from the file: " + input);
        } else {
            FFmpegParser.parseFFmpegInfo(media, pw.getResults(), input);
        }
        media.setParsing(false);
    }

    public static void parseUrl(MediaInfo media, String url) {
        String engine = EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO);
        if (engine == null) {
            LOGGER.warn("Cannot parse since the FFmpeg executable is undefined");
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(engine);
        args.add("-hide_banner");
        args.add("-i");
        args.add(url);
        args.add("-t");
        args.add("1");
        args.add("-f");
        args.add("null");
        args.add("-");
        OutputParams params = new OutputParams(CONFIGURATION);
        params.setMaxBufferSize(1.0);
        ProcessWrapperImpl pw = new ProcessWrapperImpl((String[])args.toArray(String[]::new), true, params, false, true);
        FailSafeProcessWrapper fspw = new FailSafeProcessWrapper(pw, 10000L);
        media.setParsing(true);
        fspw.runInSameThread();
        if (fspw.hasFail()) {
            LOGGER.info("Error parsing information from the url: " + url);
        } else {
            FFmpegParser.parseFFmpegInfo(media, pw.getResults(), url);
        }
        media.setParsing(false);
    }

    public static DLNAThumbnail getThumbnail(MediaInfo media, InputFile inputFile, Double seekPosition) {
        byte[] bytes;
        String engine = EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO);
        if (engine == null) {
            LOGGER.warn("Cannot generate thumbnail since the FFmpeg executable is undefined");
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(engine);
        DLNAThumbnail thumbnail = null;
        args.add("-ss");
        double thumbnailSeekPos = seekPosition != null ? seekPosition : (double)CONFIGURATION.getThumbnailSeekPos();
        thumbnailSeekPos = Math.min(thumbnailSeekPos, media.getDurationInSeconds());
        args.add(Integer.toString((int)thumbnailSeekPos));
        args.add("-i");
        if (inputFile.getFile() != null) {
            args.add(ProcessUtil.getSystemPathName(inputFile.getFile().getAbsolutePath()));
        } else {
            args.add("-");
        }
        args.add("-an");
        args.add("-dn");
        args.add("-sn");
        args.add("-vf");
        args.add("scale=320:-2");
        args.add("-vframes");
        args.add("1");
        args.add("-f");
        args.add("image2");
        args.add("pipe:");
        OutputParams params = new OutputParams(CONFIGURATION);
        params.setMaxBufferSize(1.0);
        params.setStdIn(inputFile.getPush());
        params.setNoExitCheck(true);
        ProcessWrapperImpl pw = new ProcessWrapperImpl((String[])args.toArray(String[]::new), true, params);
        media.waitMediaParsing(5);
        media.setParsing(true);
        FailSafeProcessWrapper fspw = new FailSafeProcessWrapper(pw, 3000L);
        fspw.runInSameThread();
        if (fspw.hasFail()) {
            LOGGER.info("Error generating thumbnail from the file: " + String.valueOf(inputFile.getFile()));
            media.setParsing(false);
            return null;
        }
        if (pw.getOutputByteArray() != null && (bytes = pw.getOutputByteArray().toByteArray()) != null && bytes.length > 0) {
            try {
                thumbnail = DLNAThumbnail.toThumbnail(bytes);
                if (thumbnail != null) {
                    media.setThumbnailSource(ThumbnailSource.FFMPEG_SEEK);
                }
            }
            catch (IOException e) {
                LOGGER.debug("Error while decoding thumbnail: " + e.getMessage());
                LOGGER.trace("", e);
            }
        }
        media.setParsing(false);
        return thumbnail;
    }

    public static void parseFFmpegInfo(MediaInfo media, List<String> lines, String input) {
        if (lines != null) {
            if ("-".equals(input)) {
                input = "pipe:";
            }
            boolean matches = false;
            int videoId = 0;
            int audioId = 0;
            int subtitleId = 0;
            ListIterator<String> fFmpegMetaData = lines.listIterator();
            block14: for (String line : lines) {
                fFmpegMetaData.next();
                line = line.trim();
                if (line.startsWith("Output")) {
                    matches = false;
                    continue;
                }
                if (line.startsWith("Input")) {
                    if (line.contains(input) || line.contains("from 'fd:':")) {
                        matches = true;
                        media.setContainer(line.substring(10, line.indexOf(44, 11)).trim());
                        if ("mov".equals(media.getContainer())) {
                            media.setContainer(line.substring(line.lastIndexOf(46) + 1, line.lastIndexOf(39)).trim());
                            LOGGER.trace("Setting container to " + media.getContainer() + " from the filename. To prevent false-positives, use MediaInfo=true in the renderer config.");
                        }
                        if ("matroska".equals(media.getContainer())) {
                            if (line.contains("matroska,webm, ")) {
                                media.setContainer(line.substring(line.lastIndexOf(46) + 1, line.lastIndexOf(39)).trim());
                                LOGGER.trace("Setting container to " + media.getContainer() + " from the filename. To prevent false-positives, use MediaInfo=true in the renderer config.");
                            } else {
                                media.setContainer("mkv");
                            }
                        }
                        if (!"asf".equals(media.getContainer())) continue;
                        media.setContainer(line.substring(line.lastIndexOf(46) + 1, line.lastIndexOf(39)).trim());
                        LOGGER.trace("Setting container to " + media.getContainer() + " from the filename. To prevent false-positives, use MediaInfo=true in the renderer config.");
                        continue;
                    }
                    matches = false;
                    continue;
                }
                if (!matches) continue;
                if (line.contains("Duration")) {
                    StringTokenizer st = new StringTokenizer(line, ",");
                    while (st.hasMoreTokens()) {
                        String bitr;
                        int spacepos;
                        String token = st.nextToken().trim();
                        if (token.startsWith("Duration: ")) {
                            Object durationStr = token.substring(10);
                            int l = ((String)durationStr).substring(((String)durationStr).indexOf(46) + 1).length();
                            if (l < 4) {
                                durationStr = (String)durationStr + "00".substring(0, 3 - l);
                            }
                            if (((String)durationStr).contains("N/A")) {
                                media.setDuration(null);
                                continue;
                            }
                            media.setDuration(FFmpegParser.parseDurationString((String)durationStr));
                            continue;
                        }
                        if (!token.startsWith("bitrate: ") || (spacepos = (bitr = token.substring(9)).indexOf(32)) <= -1) continue;
                        String value = bitr.substring(0, spacepos);
                        String unit = bitr.substring(spacepos + 1);
                        int bitrate = Integer.parseInt(value);
                        if (unit.equals("kb/s")) {
                            bitrate = 1024 * bitrate;
                        }
                        if (unit.equals("mb/s")) {
                            bitrate = 0x100000 * bitrate;
                        }
                        media.setBitRate(bitrate);
                    }
                    continue;
                }
                if (line.contains("Audio:")) {
                    StringTokenizer st = new StringTokenizer(line, ",");
                    MediaAudio audio = new MediaAudio();
                    audio.setId(audioId++);
                    audio.setStreamOrder(FFmpegParser.getStreamOrder(line));
                    audio.setLang(FFmpegParser.getLanguage(line));
                    audio.setDefault(line.contains("(default)"));
                    audio.setForced(line.contains("(forced)"));
                    int a = line.indexOf("[0x");
                    int b = line.indexOf(93, a);
                    if (a > -1 && b > a + 3) {
                        String idString = line.substring(a + 3, b);
                        try {
                            audio.setOptionalId(Long.valueOf(idString, 16));
                        }
                        catch (NumberFormatException nfe) {
                            LOGGER.debug("Error parsing Stream ID: " + idString);
                        }
                    }
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().trim();
                        if (token.startsWith("Stream")) {
                            String codec;
                            String audioString = "Audio: ";
                            int positionAfterAudioString = token.indexOf(audioString) + audioString.length();
                            if (token.indexOf(" ", positionAfterAudioString) != -1) {
                                codec = token.substring(positionAfterAudioString, token.indexOf(" ", positionAfterAudioString)).trim();
                                if (codec.equals("aac")) {
                                    if (token.contains("(LC)")) {
                                        codec = "aac-lc";
                                    } else if (token.contains("(HE-AAC)")) {
                                        codec = "he-aac";
                                    }
                                } else if (codec.startsWith("adpcm_ms")) {
                                    codec = "adpcm";
                                } else if (codec.startsWith("wma")) {
                                    codec = "wma";
                                } else if (token.contains("DTS-HD")) {
                                    codec = "dtshd";
                                }
                            } else {
                                codec = token.substring(positionAfterAudioString);
                                if (codec.equals("aac")) {
                                    codec = "aac-lc";
                                }
                            }
                            audio.setCodec(codec);
                            continue;
                        }
                        if (token.endsWith("Hz")) {
                            String sampleRate = token.substring(0, token.indexOf("Hz")).trim();
                            try {
                                audio.setSampleRate(Integer.parseInt(sampleRate));
                            }
                            catch (NumberFormatException nfe) {
                                LOGGER.debug("Could not parse sample rate \"" + sampleRate + "\"");
                            }
                            continue;
                        }
                        if (token.equals("mono")) {
                            audio.setNumberOfChannels(1);
                            continue;
                        }
                        if (token.equals("stereo")) {
                            audio.setNumberOfChannels(2);
                            continue;
                        }
                        if (token.equals("7.1")) {
                            audio.setNumberOfChannels(8);
                            continue;
                        }
                        if (token.equals("5:1") || token.equals("5.1") || token.equals("6 channels") || token.equals("5.1(side)")) {
                            audio.setNumberOfChannels(6);
                            continue;
                        }
                        if (token.equals("5 channels")) {
                            audio.setNumberOfChannels(5);
                            continue;
                        }
                        if (token.equals("4 channels")) {
                            audio.setNumberOfChannels(4);
                            continue;
                        }
                        if (token.equals("2 channels")) {
                            audio.setNumberOfChannels(2);
                            continue;
                        }
                        if (token.equals("s32")) {
                            audio.setBitDepth(32);
                            continue;
                        }
                        if (token.equals("s24")) {
                            audio.setBitDepth(24);
                            continue;
                        }
                        if (token.equals("s16")) {
                            audio.setBitDepth(16);
                            continue;
                        }
                        if (!token.endsWith(" kb/s") && !token.endsWith(" kb/s (default)")) continue;
                        String[] splitString = token.split("\\s+");
                        int bitrateAsInt = Integer.parseInt(splitString[0] + "000");
                        audio.setBitRate(bitrateAsInt);
                    }
                    int fFmpegMetaDataNr = fFmpegMetaData.nextIndex();
                    if (fFmpegMetaDataNr > -1) {
                        line = lines.get(fFmpegMetaDataNr);
                    }
                    if (line.contains("Metadata:")) {
                        line = lines.get(++fFmpegMetaDataNr);
                        while (line.indexOf("      ") == 0) {
                            if (line.toLowerCase().contains("title           :")) {
                                int aa = line.indexOf(": ");
                                int bb = line.length();
                                if (aa <= -1 || bb <= aa) continue;
                                audio.setTitle(line.substring(aa + 2, bb));
                                break;
                            }
                            line = lines.get(++fFmpegMetaDataNr);
                        }
                    }
                    media.addAudioTrack(audio);
                    continue;
                }
                if (line.contains("Video:") && !line.contains("(attached pic)")) {
                    MediaVideo video = new MediaVideo();
                    video.setId(videoId++);
                    video.setStreamOrder(FFmpegParser.getStreamOrder(line));
                    video.setLang(FFmpegParser.getLanguage(line));
                    video.setDefault(line.contains("(default)"));
                    video.setForced(line.contains("(forced)"));
                    StringTokenizer st = new StringTokenizer(line, ",");
                    while (st.hasMoreTokens()) {
                        String frameRate;
                        String token = st.nextToken().trim();
                        if (token.startsWith("Stream")) {
                            String videoString = "Video: ";
                            int positionAfterVideoString = token.indexOf(videoString) + videoString.length();
                            String codec = token.substring(positionAfterVideoString);
                            int profilePos = codec.indexOf(" (");
                            if (profilePos > -1) {
                                String formatProfile = FFmpegParser.getFormatProfile(codec);
                                video.setFormatProfile(formatProfile);
                                if (formatProfile != null) {
                                    if (formatProfile.endsWith(" 10")) {
                                        video.setBitDepth(10);
                                    } else if (formatProfile.endsWith(" 12")) {
                                        video.setBitDepth(12);
                                    }
                                }
                                codec = codec.substring(0, profilePos).trim();
                            }
                            if (codec.equalsIgnoreCase("flv1")) {
                                codec = "sor";
                            } else if (codec.equalsIgnoreCase("hevc")) {
                                codec = "h265";
                            } else if (codec.equalsIgnoreCase("mpeg4") || codec.equalsIgnoreCase("msmpeg4v2")) {
                                codec = token.contains("mpeg4 (Advanced Simple Profile) (XVID") ? "divx" : "mp4";
                            } else if (codec.equalsIgnoreCase("wmv2")) {
                                codec = "wmv";
                            }
                            video.setCodec(codec);
                            continue;
                        }
                        if (token.contains("tbc") || token.contains("tb(c)")) {
                            frameRate = token.substring(0, token.indexOf("tb")).trim();
                            try {
                                Double frameRateDouble = Double.valueOf(frameRate);
                                if (frameRateDouble.equals(video.getFrameRate())) continue;
                                video.setFrameRate(frameRateDouble / 2.0);
                            }
                            catch (NumberFormatException nfe) {
                                LOGGER.debug("Could not parse frame rate \"" + frameRate + "\"");
                            }
                            continue;
                        }
                        if ((token.contains("tbr") || token.contains("tb(r)")) && video.getFrameRate() == null) {
                            frameRate = token.substring(0, token.indexOf("tb")).trim();
                            try {
                                video.setFrameRate(Double.valueOf(frameRate));
                            }
                            catch (NumberFormatException nfe) {
                                LOGGER.debug("Could not parse frame rate \"" + frameRate + "\"");
                            }
                            continue;
                        }
                        if ((token.contains("fps") || token.contains("fps(r)")) && video.getFrameRate() == null) {
                            frameRate = token.substring(0, token.indexOf("fps")).trim();
                            try {
                                video.setFrameRate(Double.valueOf(frameRate));
                            }
                            catch (NumberFormatException nfe) {
                                LOGGER.debug("Could not parse frame rate \"" + frameRate + "\"");
                            }
                            continue;
                        }
                        if (token.indexOf(120) > -1 && !token.contains("max")) {
                            String resolution = token.trim();
                            if (resolution.contains(" [")) {
                                resolution = resolution.substring(0, resolution.indexOf(" ["));
                            }
                            try {
                                video.setWidth(Integer.parseInt(resolution.substring(0, resolution.indexOf(120))));
                            }
                            catch (NumberFormatException nfe) {
                                LOGGER.debug("Could not parse width from \"" + resolution.substring(0, resolution.indexOf(120)) + "\"");
                            }
                            try {
                                video.setHeight(Integer.parseInt(resolution.substring(resolution.indexOf(120) + 1)));
                            }
                            catch (NumberFormatException nfe) {
                                LOGGER.debug("Could not parse height from \"" + resolution.substring(resolution.indexOf(120) + 1) + "\"");
                            }
                            continue;
                        }
                        if (!token.contains("smpte2084")) continue;
                        video.setHDRFormat("HDR10");
                        video.setHDRFormatCompatibility("HDR10");
                    }
                    media.addVideoTrack(video);
                    continue;
                }
                if (line.contains("Subtitle:")) {
                    MediaSubtitle subtitle = new MediaSubtitle();
                    subtitle.setId(subtitleId++);
                    subtitle.setStreamOrder(FFmpegParser.getStreamOrder(line));
                    subtitle.setDefault(line.contains("(default)"));
                    subtitle.setForced(line.contains("(forced)"));
                    subtitle.setLang(FFmpegParser.getLanguage(line));
                    if (line.contains("srt") || line.contains("subrip")) {
                        subtitle.setType(SubtitleType.SUBRIP);
                    } else if (line.contains(" text")) {
                        subtitle.setType(SubtitleType.TEXT);
                    } else if (line.contains("microdvd")) {
                        subtitle.setType(SubtitleType.MICRODVD);
                    } else if (line.contains("sami")) {
                        subtitle.setType(SubtitleType.SAMI);
                    } else if (line.contains("ass") || line.contains("ssa")) {
                        subtitle.setType(SubtitleType.ASS);
                    } else if (line.contains("dvd_subtitle")) {
                        subtitle.setType(SubtitleType.VOBSUB);
                    } else if (line.contains("xsub")) {
                        subtitle.setType(SubtitleType.DIVX);
                    } else if (line.contains("mov_text")) {
                        subtitle.setType(SubtitleType.TX3G);
                    } else if (line.contains("webvtt")) {
                        subtitle.setType(SubtitleType.WEBVTT);
                    } else if (line.contains("eia_608")) {
                        subtitle.setType(SubtitleType.EIA608);
                    } else if (line.contains("dvb_subtitle")) {
                        subtitle.setType(SubtitleType.DVBSUB);
                    } else {
                        subtitle.setType(SubtitleType.UNKNOWN);
                    }
                    int fFmpegMetaDataNr = fFmpegMetaData.nextIndex();
                    if (fFmpegMetaDataNr > -1) {
                        line = lines.get(fFmpegMetaDataNr);
                    }
                    if (line.contains("Metadata:")) {
                        line = lines.get(++fFmpegMetaDataNr);
                        while (line.indexOf("      ") == 0) {
                            if (line.toLowerCase().contains("title           :")) {
                                int aa = line.indexOf(": ");
                                int bb = line.length();
                                if (aa <= -1 || bb <= aa) continue;
                                subtitle.setTitle(line.substring(aa + 2, bb));
                                break;
                            }
                            line = lines.get(++fFmpegMetaDataNr);
                        }
                    }
                    media.addSubtitlesTrack(subtitle);
                    continue;
                }
                if (line.contains("Chapters:")) {
                    int fFmpegMetaDataNr = fFmpegMetaData.nextIndex();
                    if (fFmpegMetaDataNr > -1) {
                        line = lines.get(fFmpegMetaDataNr);
                    }
                    ArrayList<MediaChapter> ffmpegChapters = new ArrayList<MediaChapter>();
                    while (line.contains("Chapter #")) {
                        MediaChapter chapter = new MediaChapter();
                        chapter.setId(FFmpegParser.getStreamOrder(line));
                        chapter.setLang(FFmpegParser.getLanguage(line));
                        if (line.contains("start ")) {
                            String startStr = line.substring(line.indexOf("start ") + 6);
                            if (startStr.contains(" ")) {
                                startStr = startStr.substring(0, startStr.indexOf(" "));
                            }
                            if (startStr.endsWith(",")) {
                                startStr = startStr.substring(0, startStr.length() - 1);
                            }
                            chapter.setStart(Double.parseDouble(startStr));
                        }
                        if (line.contains(" end ")) {
                            String endStr = line.substring(line.indexOf(" end ") + 5);
                            if (endStr.contains(" ")) {
                                endStr = endStr.substring(0, endStr.indexOf(" "));
                            }
                            chapter.setEnd(Double.parseDouble(endStr));
                        }
                        if ((line = lines.get(++fFmpegMetaDataNr)).contains("Metadata:")) {
                            line = lines.get(++fFmpegMetaDataNr);
                            while (line.indexOf("      ") == 0) {
                                if (line.contains(": ")) {
                                    int aa = line.indexOf(": ");
                                    String key = line.substring(0, aa).trim();
                                    String value = line.substring(aa + 2);
                                    if ("title".equals(key)) {
                                        if (MediaChapter.isTitleDefault(value)) break;
                                        chapter.setTitle(value);
                                        break;
                                    }
                                    LOGGER.debug("New chapter metadata not handled \"" + key + "\" : \"" + value + "\"");
                                    break;
                                }
                                line = lines.get(++fFmpegMetaDataNr);
                            }
                        }
                        ffmpegChapters.add(chapter);
                    }
                    media.setChapters(ffmpegChapters);
                    continue;
                }
                if (!line.contains("DOVI configuration record")) continue;
                int previousVideoId = videoId - 1;
                for (MediaVideo videoTrack : media.getVideoTracks()) {
                    if (videoTrack.getId() != previousVideoId) continue;
                    Object hdrFormat = "Dolby Vision";
                    if (line.contains("compatibility id: 2")) {
                        videoTrack.setHDRFormatCompatibility("SDR");
                    } else if (line.contains("compatibility id: 4")) {
                        videoTrack.setHDRFormatCompatibility("HLG");
                    } else if (line.contains("compatibility id: 6")) {
                        videoTrack.setHDRFormatCompatibility("Blu-ray / HDR10");
                        hdrFormat = (String)hdrFormat + " / SMPTE ST 2086";
                    } else if (videoTrack.getHDRFormatCompatibility() != null && videoTrack.getHDRFormatCompatibility().equals("HDR10")) {
                        hdrFormat = (String)hdrFormat + " / SMPTE ST 2086";
                    }
                    videoTrack.setHDRFormat((String)hdrFormat);
                    media.replaceVideoTrack(videoTrack, previousVideoId);
                    continue block14;
                }
            }
        }
        media.setMediaParser(PARSER_NAME);
    }

    private static int getStreamOrder(String line) {
        String idStr = line.substring(line.indexOf("#") + 1);
        int pos = idStr.indexOf(32);
        if (pos != -1) {
            idStr = idStr.substring(0, pos);
        }
        if ((pos = idStr.indexOf(40)) != -1) {
            idStr = idStr.substring(0, pos);
        }
        if ((pos = idStr.indexOf(91)) != -1) {
            idStr = idStr.substring(0, pos);
        }
        if ((pos = idStr.lastIndexOf(58)) == idStr.length() - 1) {
            idStr = idStr.substring(0, idStr.length() - 2);
        }
        String[] ids = idStr.split(":");
        try {
            if (ids.length > 1) {
                return Integer.parseInt(ids[1]);
            }
            return Integer.parseInt(ids[0]);
        }
        catch (NumberFormatException e) {
            LOGGER.info("Error parsing stream index from the line: " + line);
            return 0;
        }
    }

    private static String getLanguage(String line) {
        int a = line.indexOf(40);
        int b = line.indexOf("):", a);
        if (a > -1 && b > a) {
            return line.substring(a + 1, b);
        }
        return "und";
    }

    private static String getFormatProfile(String codec) {
        int profilePos = codec.indexOf(40);
        int profilePosEnd = codec.indexOf(41);
        if (profilePos > -1 && profilePosEnd > profilePos) {
            String formatProfile = codec.substring(profilePos + 1, profilePosEnd).toLowerCase();
            if (StringUtil.isEqual(formatProfile, "libaom-av1") || StringUtil.isEqual(formatProfile, "libdav1d")) {
                int profilePos2 = codec.indexOf(40, profilePos + 1);
                int profilePos2End = codec.indexOf(41, profilePosEnd + 1);
                if (profilePos2 > -1 && profilePos2End > profilePos2) {
                    formatProfile = codec.substring(profilePos2 + 1, profilePos2End).toLowerCase();
                }
            }
            return formatProfile;
        }
        return null;
    }

    private static Double parseDurationString(String duration) {
        return duration != null ? Double.valueOf(StringUtil.convertStringToTime(duration)) : null;
    }

    public static byte[][] getAnnexBFrameHeader(InputFile f) {
        String[] cmdArray = new String[14];
        cmdArray[0] = EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO);
        if (cmdArray[0] == null) {
            LOGGER.warn("Cannot process Annex B Frame Header is FFmpeg executable is undefined");
            return null;
        }
        cmdArray[1] = "-i";
        cmdArray[2] = f.getPush() == null && f.getFilename() != null ? f.getFilename() : "-";
        cmdArray[3] = "-vframes";
        cmdArray[4] = "1";
        cmdArray[5] = "-c:v";
        cmdArray[6] = "copy";
        cmdArray[7] = "-f";
        cmdArray[8] = "h264";
        cmdArray[9] = "-bsf";
        cmdArray[10] = "h264_mp4toannexb";
        cmdArray[11] = "-an";
        cmdArray[12] = "-y";
        cmdArray[13] = "pipe:";
        byte[][] returnData = new byte[2][];
        OutputParams params = new OutputParams(CONFIGURATION);
        params.setMaxBufferSize(1.0);
        params.setStdIn(f.getPush());
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, true, params);
        FailSafeProcessWrapper fspw = new FailSafeProcessWrapper(pw, 3000L);
        fspw.runInSameThread();
        if (fspw.hasFail()) {
            LOGGER.info("Error parsing information from the file: " + f.getFilename());
            return null;
        }
        byte[] data = pw.getOutputByteArray().toByteArray();
        returnData[0] = data;
        int kf = 0;
        for (int i = 3; i < data.length; ++i) {
            if (data[i - 3] != 1 || (data[i - 2] & 0x25) != 37 || (data[i - 1] & 0xFFFFFF88) != -120) continue;
            kf = i - 2;
            break;
        }
        int st = 0;
        boolean found = false;
        if (kf > 0) {
            for (int i = kf; i >= 5; --i) {
                if (data[i - 5] != 0 || data[i - 4] != 0 || data[i - 3] != 0 || (data[i - 2] & 1) != 1 || (data[i - 1] & 0x27) != 39) continue;
                st = i - 5;
                found = true;
                break;
            }
        }
        if (found) {
            byte[] header = new byte[kf - st];
            System.arraycopy(data, st, header, 0, kf - st);
            returnData[1] = header;
        }
        return returnData;
    }

    protected static String getVersion() {
        if (version != null) {
            return version;
        }
        String[] cmdArray = new String[2];
        cmdArray[0] = EngineFactory.getEngineExecutable(StandardEngineId.FFMPEG_VIDEO);
        if (cmdArray[0] == null) {
            LOGGER.warn("Cannot check version if FFmpeg executable is undefined");
            return null;
        }
        cmdArray[1] = "-version";
        OutputParams params = new OutputParams(null);
        params.setLog(true);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params, true, false);
        FailSafeProcessWrapper fspw = new FailSafeProcessWrapper(pw, 3000L);
        fspw.runInSameThread();
        if (fspw.hasFail()) {
            LOGGER.info("Error checking version");
            return null;
        }
        List<String> lines = pw.getOtherResults();
        for (String line : lines) {
            if (!line.startsWith("ffmpeg version")) continue;
            int index = line.indexOf(" ", 15);
            version = index > 0 ? line.substring(15, index) : line.substring(15);
            return version;
        }
        return version;
    }

    public static boolean isValid() {
        return EngineFactory.isEngineAvailable(StandardEngineId.FFMPEG_VIDEO);
    }
}

