/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.pms.network.webguiserver.GuiHttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="WebGuiServlet", urlPatterns={"/"})
public class WebGuiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebGuiServlet.class);
    public static final String BASE_PATH = "/";
    public static final String ABOUT_BASE_PATH = "/about";
    public static final String ACCOUNTS_BASE_PATH = "/accounts";
    public static final String ACTIONS_BASE_PATH = "/actions";
    public static final String LOGS_BASE_PATH = "/logs";
    public static final String PLAYER_BASE_PATH = "/player";
    public static final String SETTINGS_BASE_PATH = "/settings";
    public static final String SHARED_BASE_PATH = "/shared";
    private static final List<String> ROUTES = List.of("/about", "/accounts", "/actions", "/logs", "/player", "/settings", "/shared");

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String uri = req.getRequestURI();
            if (uri == null) {
                uri = "/index.html";
            } else if (uri.startsWith("/static/")) {
                resp.setHeader("Cache-Control", "public, max-age=604800");
            } else {
                uri = uri.toLowerCase();
            }
            if (uri.equals(BASE_PATH) || ROUTES.contains(uri) || uri.startsWith(PLAYER_BASE_PATH)) {
                uri = "/index.html";
            }
            LOGGER.trace("WebGuiServlet uri : {}", (Object)uri);
            if (!WebGuiServlet.writeAsync(req, resp, uri.substring(1))) {
                LOGGER.trace("WebGuiServlet request not available : {}", (Object)req.getRequestURI());
                WebGuiServlet.respond(req, resp, "<html><body>404 - File Not Found: " + req.getRequestURI() + "</body></html>", 404, "text/html");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in WebGuiServlet: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }
}

