/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sun.jna.Platform;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import net.pms.configuration.sharedcontent.SharedContentConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.iam.Account;
import net.pms.iam.AccountService;
import net.pms.iam.AuthService;
import net.pms.iam.Group;
import net.pms.network.webguiserver.GuiHttpServlet;
import net.pms.store.MediaStatusStore;
import net.pms.store.container.Feed;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="SharedContentApiServlet", urlPatterns={"/v1/api/shared"}, displayName="Shared Content Api Servlet")
public class SharedContentApiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedContentApiServlet.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path = req.getPathInfo();
            if (path.equals("/")) {
                Account account = AuthService.getAccountLoggedIn(req.getHeader("Authorization"), req.getRemoteAddr(), req.getRemoteAddr().equals(req.getLocalAddr()));
                if (account == null) {
                    SharedContentApiServlet.respondUnauthorized(req, resp);
                    return;
                }
                if (!account.havePermission(3072)) {
                    SharedContentApiServlet.respondForbidden(req, resp);
                    return;
                }
                JsonObject jsonResponse = new JsonObject();
                jsonResponse.add("shared_content", SharedContentConfiguration.getAsJsonArray());
                jsonResponse.addProperty("show_itunes_library", Platform.isMac() || Platform.isWindows());
                jsonResponse.addProperty("show_iphoto_library", Platform.isMac());
                jsonResponse.addProperty("show_aperture_library", Platform.isMac());
                JsonArray jGroups = new JsonArray();
                for (Group group : AccountService.getAllGroups()) {
                    jGroups.add(SharedContentApiServlet.groupToJsonObject(group));
                }
                jsonResponse.add("groups", jGroups);
                SharedContentApiServlet.respond(req, resp, jsonResponse.toString(), 200, "application/json");
            } else {
                LOGGER.trace("SharedContentApiServlet request not available : {}", (Object)path);
                SharedContentApiServlet.respondNotFound(req, resp);
            }
        }
        catch (RuntimeException e) {
            LOGGER.trace("", e);
            SharedContentApiServlet.respondInternalServerError(req, resp);
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error in SharedContentApiServlet.doGet(): {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path;
            switch (path = req.getPathInfo()) {
                case "/": {
                    Account account = AuthService.getAccountLoggedIn(req);
                    if (account == null) {
                        SharedContentApiServlet.respondUnauthorized(req, resp);
                        return;
                    }
                    if (!account.havePermission(2048)) {
                        SharedContentApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    JsonObject data = SharedContentApiServlet.getJsonObjectFromBody(req);
                    if (data.has("shared_content") && data.get("shared_content").isJsonArray()) {
                        SharedContentConfiguration.setFromJsonArray(data.get("shared_content").getAsJsonArray());
                    }
                    SharedContentApiServlet.respond(req, resp, "{}", 200, "application/json");
                    break;
                }
                case "/directories": {
                    Account account = AuthService.getAccountLoggedIn(req);
                    if (account == null) {
                        SharedContentApiServlet.respondUnauthorized(req, resp);
                        return;
                    }
                    if (!account.havePermission(2048)) {
                        SharedContentApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    JsonObject post = SharedContentApiServlet.getJsonObjectFromBody(req);
                    String directoryResponse = SharedContentApiServlet.getDirectoryResponse(post);
                    if (directoryResponse == null) {
                        SharedContentApiServlet.respondNotFound(req, resp, "Directory does not exist");
                        return;
                    }
                    SharedContentApiServlet.respond(req, resp, directoryResponse, 200, "application/json");
                    break;
                }
                case "/web-content-name": {
                    Account account = AuthService.getAccountLoggedIn(req);
                    if (account == null) {
                        SharedContentApiServlet.respondUnauthorized(req, resp);
                        return;
                    }
                    if (!account.havePermission(2048)) {
                        SharedContentApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    JsonObject request = SharedContentApiServlet.getJsonObjectFromBody(req);
                    if (request.has("source")) {
                        String webContentName;
                        String source = request.get("source").getAsString();
                        try {
                            String uri = Feed.getFeedUrl(source);
                            webContentName = Feed.getFeedTitle(uri);
                        }
                        catch (Exception e) {
                            LOGGER.info("FeedTitle not found for '{}'", (Object)source);
                            LOGGER.trace("", e);
                            webContentName = "";
                        }
                        SharedContentApiServlet.respond(req, resp, "{\"name\": \"" + webContentName + "\"}", 200, "application/json");
                        break;
                    }
                    SharedContentApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/mark-directory": {
                    Account account = AuthService.getAccountLoggedIn(req);
                    if (account == null) {
                        SharedContentApiServlet.respondUnauthorized(req, resp);
                        return;
                    }
                    if (!account.havePermission(1024)) {
                        SharedContentApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    JsonObject request = SharedContentApiServlet.getJsonObjectFromBody(req);
                    String directory = request.get("directory").getAsString();
                    boolean isPlayed = request.get("isPlayed").getAsBoolean();
                    int userId = account.getUser().getId();
                    if (userId == Integer.MAX_VALUE) {
                        userId = 0;
                    }
                    Connection connection = null;
                    try {
                        connection = MediaDatabase.getConnectionIfAvailable();
                        if (connection != null) {
                            MediaStatusStore.setDirectoryFullyPlayed(connection, directory, userId, isPlayed);
                        }
                    }
                    finally {
                        MediaDatabase.close(connection);
                    }
                    SharedContentApiServlet.respond(req, resp, "{}", 200, "application/json");
                    break;
                }
                default: {
                    LOGGER.trace("SettingsApiServlet request not available : {}", (Object)path);
                    SharedContentApiServlet.respondNotFound(req, resp);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.trace("", e);
            SharedContentApiServlet.respondInternalServerError(req, resp);
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error in SettingsApiServlet.doPost(): {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    private static String getDirectoryResponse(JsonObject data) {
        String requestedDirectory = data != null && data.has("path") ? data.get("path").getAsString() : "";
        return SharedContentApiServlet.getDirectoryResponse(requestedDirectory);
    }

    private static String getDirectoryResponse(String path) {
        if (StringUtils.isEmpty(path)) {
            path = System.getProperty("user.home");
        }
        if ("roots".equals(path)) {
            return SharedContentApiServlet.getRootsDirectoryResponse();
        }
        List<File> roots = Arrays.asList(File.listRoots());
        JsonObject jsonResponse = new JsonObject();
        File requestedDirectoryFile = new File(path);
        if (!requestedDirectoryFile.exists()) {
            return null;
        }
        Object[] directories = requestedDirectoryFile.listFiles(file -> file.isDirectory() && !file.isHidden() && file.canRead() && !file.getName().startsWith("."));
        Arrays.sort(directories);
        JsonArray jsonArray = new JsonArray();
        for (Object file2 : directories) {
            JsonObject directoryGroup = new JsonObject();
            String value = ((File)file2).toString();
            String label = ((File)file2).getName();
            directoryGroup.addProperty("label", label);
            directoryGroup.addProperty("value", value);
            jsonArray.add(directoryGroup);
        }
        jsonResponse.add("children", jsonArray);
        String name = requestedDirectoryFile.getName();
        if (StringUtils.isEmpty(name) && roots.contains(requestedDirectoryFile)) {
            name = requestedDirectoryFile.toString().replace("\\", "");
        }
        jsonArray = new JsonArray();
        JsonObject directoryGroup = new JsonObject();
        directoryGroup.addProperty("label", name);
        directoryGroup.addProperty("value", requestedDirectoryFile.toString());
        jsonArray.add(directoryGroup);
        while (requestedDirectoryFile.getParentFile() != null && requestedDirectoryFile.getParentFile().isDirectory()) {
            directoryGroup = new JsonObject();
            name = (requestedDirectoryFile = requestedDirectoryFile.getParentFile()).getName();
            if (StringUtils.isEmpty(name) && roots.contains(requestedDirectoryFile)) {
                name = requestedDirectoryFile.toString().replace("\\", "");
            }
            directoryGroup.addProperty("label", name);
            directoryGroup.addProperty("value", requestedDirectoryFile.toString());
            jsonArray.add(directoryGroup);
        }
        jsonResponse.add("parents", jsonArray);
        jsonResponse.add("separator", new JsonPrimitive(File.separator));
        return jsonResponse.toString();
    }

    private static String getRootsDirectoryResponse() {
        JsonObject jsonResponse = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (File file : File.listRoots()) {
            JsonObject directoryGroup = new JsonObject();
            directoryGroup.addProperty("label", file.toString().replace("\\", ""));
            directoryGroup.addProperty("value", file.toString());
            jsonArray.add(directoryGroup);
        }
        jsonResponse.add("children", jsonArray);
        jsonResponse.add("parents", new JsonArray());
        jsonResponse.add("separator", new JsonPrimitive(File.separator));
        return jsonResponse.toString();
    }

    private static JsonObject groupToJsonObject(Group group) {
        JsonObject jObject = GSON.toJsonTree(group).getAsJsonObject();
        jObject.remove("permissions");
        return jObject;
    }
}

