/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.pms.PMS;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.encoders.FFmpegHlsVideo;
import net.pms.encoders.HlsHelper;
import net.pms.encoders.ImageEngine;
import net.pms.external.tmdb.TMDB;
import net.pms.formats.Format;
import net.pms.iam.Account;
import net.pms.iam.AuthService;
import net.pms.image.BufferedImageFilterChain;
import net.pms.image.Image;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.image.ImagesUtil;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.media.MediaInfo;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.metadata.MediaVideoMetadata;
import net.pms.media.video.metadata.TvSeasonMetadata;
import net.pms.media.video.metadata.TvSeriesMetadata;
import net.pms.network.StartStopListener;
import net.pms.network.mediaserver.MediaServer;
import net.pms.network.webguiserver.GuiHttpServlet;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.WebGuiRenderer;
import net.pms.store.MediaStoreIds;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.container.CodeEnter;
import net.pms.store.container.MediaLibraryFolder;
import net.pms.store.container.MediaLibraryTvSeason;
import net.pms.store.container.MediaLibraryTvSeries;
import net.pms.store.container.TranscodeVirtualFolder;
import net.pms.store.item.MediaLibraryTvEpisode;
import net.pms.store.item.RealFile;
import net.pms.store.item.VirtualVideoAction;
import net.pms.store.utils.StoreResourceSorter;
import net.pms.util.ByteRange;
import net.pms.util.FileUtil;
import net.pms.util.FullyPlayed;
import net.pms.util.PropertiesUtil;
import net.pms.util.UMSUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="PlayerApiServlet", urlPatterns={"/v1/api/player"}, displayName="Player Api Servlet")
public class PlayerApiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayerApiServlet.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path = req.getPathInfo();
            if (path.equals("/")) {
                Account account = AuthService.getPlayerAccountLoggedIn(req);
                if (account == null) {
                    PlayerApiServlet.respondUnauthorized(req, resp);
                } else if (!account.havePermission(0x2000000)) {
                    PlayerApiServlet.respondForbidden(req, resp);
                } else {
                    String uuid = ConnectedRenderers.getRandomUUID();
                    PlayerApiServlet.respond(req, resp, "{\"uuid\":\"" + uuid + "\"}", 200, "application/json");
                }
            } else if (path.startsWith("/thumbnail/")) {
                PlayerApiServlet.sendThumbnail(req, resp);
            } else if (path.startsWith("/image/")) {
                PlayerApiServlet.sendImageMedia(req, resp);
            } else if (path.startsWith("/raw/")) {
                PlayerApiServlet.sendRawMedia(req, resp, false);
            } else if (path.startsWith("/download/")) {
                PlayerApiServlet.sendDownloadMedia(req, resp);
            } else if (path.startsWith("/media/")) {
                PlayerApiServlet.sendMedia(req, resp);
            } else {
                LOGGER.trace("PlayerApiServlet request not available : {}", (Object)path);
                PlayerApiServlet.respondNotFound(req, resp);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in PlayerApiServlet: {}", (Object)e.getMessage());
            LOGGER.trace("{}", e);
            PlayerApiServlet.respondInternalServerError(req, resp);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path;
            JsonObject action = PlayerApiServlet.getJsonObjectFromBody(req);
            if (!action.has("uuid")) {
                PlayerApiServlet.respondBadRequest(req, resp);
                return;
            }
            String uuid = action.get("uuid").getAsString();
            WebGuiRenderer renderer = PlayerApiServlet.getRenderer(req, uuid);
            if (renderer == null) {
                PlayerApiServlet.respondUnauthorized(req, resp);
                return;
            }
            if (!renderer.havePermission(0x2000000)) {
                PlayerApiServlet.respondForbidden(req, resp);
                return;
            }
            renderer.setActive(true);
            switch (path = req.getPathInfo()) {
                case "/browse": {
                    String lang;
                    String search;
                    String id;
                    JsonObject browse;
                    if (action.has("id") && (browse = PlayerApiServlet.getBrowsePage(renderer, id = action.get("id").getAsString(), search = action.has("search") ? action.get("search").getAsString() : null, lang = action.has("lang") ? action.get("lang").getAsString() : null)) != null) {
                        PlayerApiServlet.respond(req, resp, browse.toString(), 200, "application/json");
                        return;
                    }
                    PlayerApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/logout": {
                    ConnectedRenderers.removeWebPlayerRenderer(uuid);
                    PlayerApiServlet.respond(req, resp, "{}", 200, "application/json");
                    break;
                }
                case "/play": {
                    String lang;
                    String id;
                    JsonObject play;
                    if (action.has("id") && (play = PlayerApiServlet.getPlayPage(renderer, id = action.get("id").getAsString(), lang = action.has("lang") ? action.get("lang").getAsString() : null)) != null) {
                        PlayerApiServlet.respond(req, resp, play.toString(), 200, "application/json");
                        return;
                    }
                    PlayerApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/edit": {
                    String id;
                    JsonObject edit;
                    if (!renderer.havePermission(0x8000000)) {
                        PlayerApiServlet.respondForbidden(req, resp);
                    } else if (!TMDB.isReady()) {
                        PlayerApiServlet.respondNotFound(req, resp);
                    } else if (action.has("id") && (edit = PlayerApiServlet.getEditData(renderer, id = action.get("id").getAsString())) != null) {
                        PlayerApiServlet.respond(req, resp, edit.toString(), 200, "application/json");
                        return;
                    }
                    PlayerApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/findMetadata": {
                    if (!renderer.havePermission(0x8000000)) {
                        PlayerApiServlet.respondForbidden(req, resp);
                    } else if (!TMDB.isReady()) {
                        PlayerApiServlet.respondNotFound(req, resp);
                    } else if (action.has("id") && !action.get("id").isJsonNull() && action.has("media_type") && !action.get("media_type").isJsonNull() && action.has("search") && !action.get("search").isJsonNull()) {
                        String lang;
                        JsonArray editResults;
                        String id = action.get("id").getAsString();
                        String mediaType = action.get("media_type").getAsString();
                        String search = action.get("search").getAsString();
                        Integer year = null;
                        if (action.has("year") && !action.get("year").isJsonNull()) {
                            try {
                                year = action.get("year").getAsInt();
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if ((editResults = PlayerApiServlet.getMetadataResults(renderer, id, mediaType, search, year, lang = action.has("lang") && !action.get("lang").isJsonNull() ? action.get("lang").getAsString() : null)) != null) {
                            PlayerApiServlet.respond(req, resp, editResults.toString(), 200, "application/json");
                            return;
                        }
                    }
                    PlayerApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/setMetadata": {
                    String mediaType;
                    Long tmdbId;
                    String id;
                    boolean changed;
                    if (!renderer.havePermission(0x8000000)) {
                        PlayerApiServlet.respondForbidden(req, resp);
                    } else if (!TMDB.isReady()) {
                        PlayerApiServlet.respondNotFound(req, resp);
                    } else if (action.has("id") && !action.get("id").isJsonNull() && action.has("tmdb_id") && !action.get("tmdb_id").isJsonNull() && action.has("media_type") && !action.get("media_type").isJsonNull() && (changed = PlayerApiServlet.setMetadata(renderer, id = action.get("id").getAsString(), tmdbId = Long.valueOf(action.get("tmdb_id").getAsLong()), mediaType = action.get("media_type").getAsString()))) {
                        PlayerApiServlet.respond(req, resp, "{}", 200, "application/json");
                        return;
                    }
                    PlayerApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/setFullyPlayed": {
                    boolean fullyPlayed;
                    String id;
                    boolean changed;
                    if (action.has("id") && !action.get("id").isJsonNull() && action.has("fullyPlayed") && !action.get("fullyPlayed").isJsonNull() && (changed = PlayerApiServlet.setFullyPlayed(renderer, id = action.get("id").getAsString(), fullyPlayed = action.get("fullyPlayed").getAsBoolean()))) {
                        PlayerApiServlet.respond(req, resp, "{}", 200, "application/json");
                        return;
                    }
                    PlayerApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/show": {
                    String lang;
                    String id;
                    JsonObject show;
                    if (action.has("id") && (show = PlayerApiServlet.getShowPage(renderer, id = action.get("id").getAsString(), lang = action.has("lang") ? action.get("lang").getAsString() : null)) != null) {
                        PlayerApiServlet.respond(req, resp, show.toString(), 200, "application/json");
                        return;
                    }
                    PlayerApiServlet.respondBadRequest(req, resp);
                    break;
                }
                case "/getMediaInfo": {
                    String id;
                    JsonObject mediaInfo;
                    if (action.has("id") && (mediaInfo = PlayerApiServlet.getMediaInfo(renderer, id = action.get("id").getAsString())) != null) {
                        PlayerApiServlet.respond(req, resp, mediaInfo.toString(), 200, "application/json");
                        return;
                    }
                    PlayerApiServlet.respondBadRequest(req, resp);
                    break;
                }
                default: {
                    LOGGER.trace("PlayerApiServlet request not available : {}", (Object)path);
                    PlayerApiServlet.respondNotFound(req, resp);
                    break;
                }
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error("Exception in PlayerApiServlet: {}", (Object)e.getMessage());
            LOGGER.trace("{}", e);
            PlayerApiServlet.respondInternalServerError(req, resp);
        }
        catch (InterruptedException e) {
            PlayerApiServlet.respondInternalServerError(req, resp);
            Thread.currentThread().interrupt();
        }
    }

    private static synchronized WebGuiRenderer getRenderer(HttpServletRequest req, String uuid) {
        ConnectedRenderers.RENDERER_LOCK.lock();
        try {
            if (ConnectedRenderers.hasWebPlayerRenderer(uuid)) {
                WebGuiRenderer webGuiRenderer = ConnectedRenderers.getWebPlayerRenderer(uuid);
                return webGuiRenderer;
            }
            if (ConnectedRenderers.isValidUUID(uuid)) {
                PlayerApiServlet.createRenderer(req, uuid);
                if (ConnectedRenderers.hasWebPlayerRenderer(uuid)) {
                    WebGuiRenderer webGuiRenderer = ConnectedRenderers.getWebPlayerRenderer(uuid);
                    return webGuiRenderer;
                }
            }
        }
        finally {
            ConnectedRenderers.RENDERER_LOCK.unlock();
        }
        return null;
    }

    private static void createRenderer(HttpServletRequest req, String uuid) {
        Account account = AuthService.getPlayerAccountLoggedIn(req);
        if (account == null || !account.havePermission(0x2000000)) {
            return;
        }
        try {
            LOGGER.info("Found new web gui renderer with uuid: {}", (Object)uuid);
            String userAgent = req.getHeader("User-agent");
            String langs = PlayerApiServlet.getRequestLanguages(req);
            WebGuiRenderer renderer = new WebGuiRenderer(uuid, account.getUser().getId(), userAgent, langs);
            renderer.associateIP(PlayerApiServlet.getInetAddress(req));
            renderer.setActive(true);
            ConnectedRenderers.addWebPlayerRenderer(renderer);
            LOGGER.debug("Created web gui renderer for " + renderer.getRendererName());
        }
        catch (ConfigurationException ex) {
            LOGGER.warn("Error in loading configuration of WebPlayerRenderer");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private static String getIconNameFromFolderName(String folderName, String defaultIconName) {
        if (folderName.startsWith("i18n@")) {
            folderName = folderName.substring(5);
        }
        if (defaultIconName == null) {
            defaultIconName = "folder";
        }
        return switch (folderName) {
            case ".." -> "back";
            case "#--TRANSCODE--#" -> "settings";
            case "3dMovies" -> "badge-3d";
            case "4kVideos" -> "badge-4k";
            case "Audio" -> "audio";
            case "ByDate" -> "calendar";
            case "DvdImages" -> "disc";
            case "FilterByInformation" -> "info-square";
            case "FilterByProgress" -> "loader-2";
            case "HdVideos" -> "badge-hd";
            case "InProgress" -> "loader-2";
            case "MostPlayed" -> "heart";
            case "Movies" -> "movie";
            case "Music" -> "audio";
            case "Photo" -> "image";
            case "RecentlyAdded" -> "calendar";
            case "RecentlyPlayed" -> "eye";
            case "SdVideos" -> "badge-sd";
            case "TvShows" -> "device-tv";
            case "Unsorted" -> "shuffle";
            case "Video" -> "movie";
            case "Web" -> "world-www";
            case "YouTube" -> "brand-youtube";
            case "YouTube Channels" -> "brand-youtube";
            default -> defaultIconName;
        };
    }

    private static JsonObject getBrowsePage(WebGuiRenderer renderer, String id, String search, String lang) throws IOException, InterruptedException {
        LOGGER.debug("Make browse page " + id);
        JsonObject result = new JsonObject();
        result.addProperty("goal", "browse");
        JsonArray jBreadcrumbs = new JsonArray();
        JsonArray jFolders = new JsonArray();
        JsonArray mediaLibraryFolders = new JsonArray();
        JsonArray jMedias = new JsonArray();
        StoreResource rootResource = id.equals("0") ? null : renderer.getMediaStore().getResource(id);
        List<StoreResource> resources = renderer.getMediaStore().getResources(id, true);
        if (!resources.isEmpty() && resources.get(0).getParent() != null && resources.get(0).getParent() instanceof CodeEnter) {
            return null;
        }
        if (StringUtils.isNotEmpty(search) && !(resources instanceof CodeEnter)) {
            UMSUtils.filterResourcesByName(resources, search, false, false);
        }
        boolean hasFile = false;
        if (!resources.isEmpty() && resources.get(0).getParent() != null && resources.get(0).getParent().isFolder()) {
            String thisName;
            StoreContainer thisResourceFromResources = resources.get(0).getParent();
            if (thisResourceFromResources.isChildrenSorted()) {
                StoreResourceSorter.sortResourcesByDefault(resources, lang);
            }
            if ((thisName = thisResourceFromResources.getSystemName()).equals("MediaLibrary")) {
                for (StoreResource resource : resources) {
                    hasFile = true;
                    JsonObject jMedia = new JsonObject();
                    jMedia.addProperty("id", resource.getResourceId());
                    jMedia.addProperty("name", resource.getLocalizedDisplayName(lang));
                    jMedia.addProperty("icon", PlayerApiServlet.getIconNameFromFolderName(resource.getSystemName(), null));
                    jMedias.add(jMedia);
                }
            }
            jBreadcrumbs = PlayerApiServlet.getBreadcrumbs(thisResourceFromResources, lang);
            if (resources.get(0).getParent().getParent() != null) {
                StoreContainer parentFromResources = resources.get(0).getParent().getParent();
                JsonObject jFolder = new JsonObject();
                jFolder.addProperty("id", parentFromResources.getResourceId());
                jFolder.addProperty("name", "..");
                jFolder.addProperty("icon", "back");
                jFolders.add(jFolder);
            }
        }
        if (resources.isEmpty() && rootResource != null && rootResource.isFolder()) {
            jBreadcrumbs = PlayerApiServlet.getBreadcrumbs(rootResource, lang);
            if (rootResource.getParent() != null) {
                StoreContainer parentFromResources = rootResource.getParent();
                JsonObject jFolder = new JsonObject();
                jFolder.addProperty("id", parentFromResources.getResourceId());
                jFolder.addProperty("name", "..");
                jFolder.addProperty("icon", "back");
                jFolders.add(jFolder);
            }
        }
        for (StoreResource resource : resources) {
            if (resource == null) continue;
            if (resource instanceof VirtualVideoAction) {
                hasFile = true;
                JsonObject jMedia = new JsonObject();
                jMedia.addProperty("id", resource.getResourceId());
                jMedia.addProperty("name", resource.getLocalizedDisplayName(lang));
                jMedias.add(jMedia);
                continue;
            }
            if (resource.isFolder()) {
                Boolean isDisplayFoldersAsThumbnails = false;
                if (resource.getParent().getSystemName().equals("TvShows") || resource.getParent().getSystemName().equals("Recommendations") || resource.getParent().getParent() != null && resource.getParent().getParent().getSystemName().equals("FilterByProgress") || resource.getParent().getParent() != null && resource.getParent().getParent().getParent() != null && resource.getParent().getParent().getParent().getSystemName().equals("FilterByInformation")) {
                    isDisplayFoldersAsThumbnails = true;
                }
                if (isDisplayFoldersAsThumbnails.booleanValue() && isDisplayFoldersAsThumbnails.booleanValue() && resource instanceof MediaLibraryFolder) continue;
                boolean addFolderToFoldersListOnLeft = true;
                if (id.equals("0") && resource.getSystemName().equals("MediaLibrary")) {
                    StoreResource imagesFolder;
                    StoreResource audioFolder;
                    JsonObject mediaLibraryFolder;
                    List<StoreResource> mediaLibraryChildren = renderer.getMediaStore().getResources(resource.getId(), true);
                    StoreResource videoFolder = UMSUtils.getFirstResourceWithSystemName(mediaLibraryChildren, "Video");
                    if (videoFolder != null) {
                        mediaLibraryFolder = new JsonObject();
                        mediaLibraryFolder.addProperty("id", videoFolder.getResourceId());
                        mediaLibraryFolder.addProperty("name", videoFolder.getLocalizedDisplayName(lang));
                        mediaLibraryFolder.addProperty("icon", "video");
                        mediaLibraryFolders.add(mediaLibraryFolder);
                    }
                    if ((audioFolder = UMSUtils.getFirstResourceWithSystemName(mediaLibraryChildren, "Audio")) != null) {
                        mediaLibraryFolder = new JsonObject();
                        mediaLibraryFolder.addProperty("id", audioFolder.getResourceId());
                        mediaLibraryFolder.addProperty("name", audioFolder.getLocalizedDisplayName(lang));
                        mediaLibraryFolder.addProperty("icon", "audio");
                        mediaLibraryFolders.add(mediaLibraryFolder);
                    }
                    if ((imagesFolder = UMSUtils.getFirstResourceWithSystemName(mediaLibraryChildren, "Photo")) != null) {
                        mediaLibraryFolder = new JsonObject();
                        mediaLibraryFolder.addProperty("id", imagesFolder.getResourceId());
                        mediaLibraryFolder.addProperty("name", imagesFolder.getLocalizedDisplayName(lang));
                        mediaLibraryFolder.addProperty("icon", "image");
                        mediaLibraryFolders.add(mediaLibraryFolder);
                    }
                    if (videoFolder != null) {
                        JsonObject jMediasSelections = new JsonObject();
                        jMediasSelections.add("recentlyAdded", PlayerApiServlet.getMediaLibraryFolderChilds(videoFolder, renderer, "RecentlyAdded", lang));
                        jMediasSelections.add("recentlyPlayed", PlayerApiServlet.getMediaLibraryFolderChilds(videoFolder, renderer, "RecentlyPlayed", lang));
                        jMediasSelections.add("inProgress", PlayerApiServlet.getMediaLibraryFolderChilds(videoFolder, renderer, "InProgress", lang));
                        jMediasSelections.add("mostPlayed", PlayerApiServlet.getMediaLibraryFolderChilds(videoFolder, renderer, "MostPlayed", lang));
                        result.add("mediasSelections", jMediasSelections);
                        addFolderToFoldersListOnLeft = false;
                    }
                }
                if (!addFolderToFoldersListOnLeft) continue;
                JsonObject jFolder = new JsonObject();
                jFolder.addProperty("id", resource.getResourceId());
                String folderName = resource.getLocalizedDisplayName(lang);
                jFolder.addProperty("name", folderName);
                jFolder.addProperty("icon", PlayerApiServlet.getIconNameFromFolderName(folderName, null));
                jFolders.add(jFolder);
                continue;
            }
            hasFile = true;
            jMedias.add(PlayerApiServlet.getMediaJsonObject(resource, lang));
        }
        if (rootResource instanceof MediaLibraryFolder) {
            JsonObject metadata;
            MediaLibraryFolder folder = (MediaLibraryFolder)rootResource;
            if (folder.isTVSeries()) {
                metadata = PlayerApiServlet.getMetadataAsJsonObject(rootResource, renderer, lang);
                if (metadata != null) {
                    metadata.addProperty("isEditable", renderer.havePermission(0x8000000) && TMDB.isReady());
                    result.add("metadata", metadata);
                }
                if (folder.isFullyPlayedAware()) {
                    result.addProperty("fullyplayed", folder.isFullyPlayed());
                }
            } else if (folder.isTVSeason() && (metadata = PlayerApiServlet.getMetadataAsJsonObject(rootResource, renderer, lang)) != null) {
                result.add("metadata", metadata);
            }
            if (folder.getSystemName().equals("TvShows") || folder.getSystemName().equals("Recommendations") || folder.getParent() != null && folder.getParent().getSystemName().equals("FilterByProgress") || folder.getParent() != null && folder.getParent().getParent() != null && folder.getParent().getParent().getSystemName().equals("FilterByInformation")) {
                for (StoreResource resource : resources) {
                    if (!(resource instanceof MediaLibraryFolder)) continue;
                    hasFile = true;
                    jMedias.add(PlayerApiServlet.getMediaJsonObject(resource, lang));
                }
            }
        }
        result.addProperty("umsversion", PropertiesUtil.getProjectProperties().get("project.version"));
        result.addProperty("name", id.equals("0") || rootResource == null ? CONFIGURATION.getServerDisplayName() : rootResource.getLocalizedDisplayName(lang));
        result.addProperty("hasFile", hasFile);
        result.addProperty("useWebControl", CONFIGURATION.useWebPlayerControls());
        result.add("breadcrumbs", jBreadcrumbs);
        result.add("mediaLibraryFolders", mediaLibraryFolders);
        result.add("folders", jFolders);
        result.add("medias", jMedias);
        return result;
    }

    private static JsonObject getMediaJsonObject(StoreResource resource, String lang) {
        JsonObject jMedia = new JsonObject();
        if (resource.isFolder()) {
            jMedia.addProperty("goal", "browse");
            jMedia.addProperty("name", resource.getLocalizedDisplayName(lang));
        } else if (resource instanceof StoreItem) {
            StoreItem item = (StoreItem)resource;
            if (item.getFormat() != null && item.getFormat().isVideo()) {
                jMedia.addProperty("goal", "show");
            } else {
                jMedia.addProperty("goal", "play");
            }
            jMedia.addProperty("name", item.getLocalizedResumeName(lang));
            jMedia.addProperty("updateId", MediaStoreIds.getObjectUpdateIdAsString(item.getLongId()));
        }
        jMedia.addProperty("id", resource.getResourceId());
        return jMedia;
    }

    private static JsonArray getBreadcrumbs(StoreResource resource, String lang) {
        JsonArray jBreadcrumbs = new JsonArray();
        JsonObject jBreadcrumb = new JsonObject();
        jBreadcrumb.addProperty("id", "");
        jBreadcrumb.addProperty("name", resource.getLocalizedDisplayName(lang));
        jBreadcrumbs.add(jBreadcrumb);
        StoreResource thisResourceFromResources = resource;
        while (thisResourceFromResources.getParent() != null && thisResourceFromResources.getParent().isFolder()) {
            thisResourceFromResources = thisResourceFromResources.getParent();
            jBreadcrumb = new JsonObject();
            jBreadcrumb.addProperty("id", thisResourceFromResources.getResourceId());
            jBreadcrumb.addProperty("name", thisResourceFromResources.getLocalizedDisplayName(lang));
            jBreadcrumbs.add(jBreadcrumb);
        }
        JsonArray jBreadcrumbsInverted = new JsonArray();
        for (int i = jBreadcrumbs.size(); i > 0; --i) {
            jBreadcrumbsInverted.add(jBreadcrumbs.get(i - 1));
        }
        return jBreadcrumbsInverted;
    }

    private static JsonArray getMediaLibraryFolderChilds(StoreResource videoFolder, Renderer renderer, String systemName, String lang) throws IOException {
        List<StoreResource> videoFolderChildren = renderer.getMediaStore().getResources(videoFolder.getId(), true);
        StoreResource videoFolderChild = UMSUtils.getFirstResourceWithSystemName(videoFolderChildren, systemName);
        if (videoFolderChild == null) {
            LOGGER.trace("The videoFolderChildren folder was empty after filtering for " + systemName);
            return null;
        }
        JsonArray jLibraryVideos = new JsonArray();
        List<StoreResource> libraryVideos = renderer.getMediaStore().getResources(videoFolderChild.getId(), true);
        for (StoreResource libraryVideo : libraryVideos) {
            if (libraryVideo instanceof TranscodeVirtualFolder) continue;
            jLibraryVideos.add(PlayerApiServlet.getMediaJsonObject(libraryVideo, lang));
            if (jLibraryVideos.size() <= 5) continue;
            break;
        }
        return jLibraryVideos;
    }

    private static JsonObject getShowPage(WebGuiRenderer renderer, String id, String lang) throws IOException, InterruptedException {
        JsonObject result = PlayerApiServlet.getPlayPage(renderer, id, lang);
        result.remove("goal");
        result.addProperty("goal", "show");
        return result;
    }

    private static JsonObject getPlayPage(WebGuiRenderer renderer, String id, String lang) throws IOException, InterruptedException {
        StoreItem libraryItem;
        StoreItem item;
        LOGGER.debug("Make play page " + id);
        JsonObject result = new JsonObject();
        result.addProperty("goal", "play");
        JsonArray jFolders = new JsonArray();
        JsonArray medias = new JsonArray();
        JsonObject media = new JsonObject();
        StoreResource resource = renderer.getMediaStore().getResource(id);
        StoreItem storeItem = item = resource instanceof StoreItem ? (libraryItem = (StoreItem)resource) : null;
        if (item == null) {
            LOGGER.debug("Bad web play id: " + id);
            throw new IOException("Bad Id");
        }
        if (item.getParent() != null && item.getParent().isFolder()) {
            JsonObject jFolder = new JsonObject();
            jFolder.addProperty("id", item.getParent().getResourceId());
            jFolder.addProperty("name", "..");
            jFolders.add(jFolder);
        }
        Format format = item.getFormat();
        boolean isImage = format.isImage();
        boolean isVideo = format.isVideo();
        boolean isAudio = format.isAudio();
        String mime = item.getMimeType();
        media.addProperty("mime", mime);
        media.addProperty("updateId", MediaStoreIds.getObjectUpdateIdAsString(item.getLongId()));
        if (isVideo) {
            media.addProperty("mediaType", "video");
            JsonObject metadata = PlayerApiServlet.getMetadataAsJsonObject(item, renderer, lang);
            if (metadata != null) {
                metadata.addProperty("isEditable", renderer.havePermission(0x8000000) && TMDB.isReady());
                media.add("metadata", metadata);
            }
            media.addProperty("isVideoWithChapters", item.getMediaInfo() != null && item.getMediaInfo().hasChapters());
            if (item.getMediaStatus() != null && item.getMediaStatus().getLastPlaybackPosition() != null && item.getMediaStatus().getLastPlaybackPosition() > 0.0) {
                media.addProperty("resumePosition", item.getMediaStatus().getLastPlaybackPosition().intValue());
            }
        } else if (isAudio) {
            media.addProperty("mediaType", "audio");
            media.addProperty("isNativeAudio", mime.equals("audio/mpeg"));
        } else if (isImage) {
            media.addProperty("mediaType", "image");
            int delay = CONFIGURATION.getWebPlayerImgSlideDelay() * 1000;
            if (delay > 0 && CONFIGURATION.getWebPlayerAutoCont(format)) {
                media.addProperty("delay", delay);
            }
            media.remove("mime");
        } else {
            media.addProperty("mediaType", "");
        }
        media.addProperty("name", item.getLocalizedResumeName(lang));
        media.addProperty("id", id);
        media.addProperty("autoContinue", CONFIGURATION.getWebPlayerAutoCont(format));
        media.addProperty("isDynamicPls", CONFIGURATION.isDynamicPls());
        media.addProperty("isDownload", renderer.havePermission(0x4000000) && CONFIGURATION.useWebPlayerDownload());
        if (item.isFullyPlayedAware()) {
            media.addProperty("fullyplayed", item.isFullyPlayed());
        }
        media.addProperty("hasMediaInfo", true);
        media.add("surroundMedias", PlayerApiServlet.getSurroundingByType(item, lang));
        medias.add(media);
        result.add("medias", medias);
        result.add("folders", jFolders);
        result.add("breadcrumbs", PlayerApiServlet.getBreadcrumbs(item, lang));
        result.addProperty("useWebControl", CONFIGURATION.useWebPlayerControls());
        return result;
    }

    private static JsonObject getEditData(WebGuiRenderer renderer, String id) throws IOException, InterruptedException {
        MediaLibraryTvSeries mediaLibraryTvSeries;
        MediaLibraryTvSeries tvSeries;
        StoreItem libraryItem;
        LOGGER.debug("Make edit data " + id);
        StoreResource resource = renderer.getMediaStore().getResource(id);
        StoreItem item = resource instanceof StoreItem ? (libraryItem = (StoreItem)resource) : null;
        MediaLibraryTvSeries mediaLibraryTvSeries2 = tvSeries = resource instanceof MediaLibraryTvSeries ? (mediaLibraryTvSeries = (MediaLibraryTvSeries)resource) : null;
        if (tvSeries == null && item == null) {
            LOGGER.debug("Bad web edit id: " + id);
            throw new IOException("Bad Id");
        }
        JsonObject result = new JsonObject();
        if (item != null && item.getMediaInfo().isVideo() && item.getMediaInfo().hasVideoMetadata()) {
            RealFile realFile;
            MediaVideoMetadata metadata = item.getMediaInfo().getVideoMetadata();
            String search = metadata.getMovieOrShowName();
            if (item instanceof RealFile && (realFile = (RealFile)item).getFile() != null) {
                String filename = realFile.getFile().getName();
                String absolutePath = realFile.getFile().getParent();
                result.addProperty("filename", filename);
                result.addProperty("folder", absolutePath);
                if (StringUtils.isBlank(search)) {
                    search = FileUtil.basicPrettify(filename);
                }
            }
            result.addProperty("search", search);
            if (metadata.isTvEpisode()) {
                result.addProperty("media_type", "tv_episode");
                result.addProperty("episode", PlayerApiServlet.getLong(metadata.getTvEpisodeNumberUnpadded()));
                result.addProperty("season", metadata.getTvSeason());
                if (metadata.getSeriesMetadata() != null) {
                    result.addProperty("year", metadata.getSeriesMetadata().getStartYear());
                }
            } else {
                result.addProperty("media_type", "movie");
                result.addProperty("year", metadata.getYear());
            }
        } else if (tvSeries != null && tvSeries.getTvSeriesMetadata() != null) {
            TvSeriesMetadata metadata = tvSeries.getTvSeriesMetadata();
            result.addProperty("search", metadata.getTitle());
            result.addProperty("year", metadata.getStartYear());
            result.addProperty("media_type", "tv");
        }
        return result;
    }

    private static JsonObject getMediaInfo(WebGuiRenderer renderer, String id) throws IOException, InterruptedException {
        RealFile realFile;
        RealFile item;
        LOGGER.debug("Make media info " + id);
        StoreResource resource = renderer.getMediaStore().getResource(id);
        RealFile realFile2 = item = resource instanceof RealFile ? (realFile = (RealFile)resource) : null;
        if (item == null) {
            LOGGER.debug("Bad media info id: " + id);
            throw new IOException("Bad Id");
        }
        JsonObject result = new JsonObject();
        File file = item.getFile();
        result.addProperty("filename", item.getFileName());
        result.addProperty("size", file.length());
        MediaInfo mediaInfo = item.getMediaInfo();
        if (mediaInfo != null) {
            result.add("mediaInfo", mediaInfo.toJson());
        }
        return result;
    }

    private static JsonArray getMetadataResults(WebGuiRenderer renderer, String id, String mediaType, String search, Integer year, String lang) throws IOException, InterruptedException {
        MediaLibraryTvSeries mediaLibraryTvSeries;
        MediaLibraryTvSeries tvSeries;
        StoreItem libraryItem;
        LOGGER.debug("Make metadata results " + id);
        StoreResource resource = renderer.getMediaStore().getResource(id);
        StoreItem item = resource instanceof StoreItem ? (libraryItem = (StoreItem)resource) : null;
        MediaLibraryTvSeries mediaLibraryTvSeries2 = tvSeries = resource instanceof MediaLibraryTvSeries ? (mediaLibraryTvSeries = (MediaLibraryTvSeries)resource) : null;
        if (item == null && tvSeries == null) {
            LOGGER.debug("Bad web edit id: " + id);
            throw new IOException("Bad Id");
        }
        JsonArray result = null;
        if ("tv".equals(mediaType) || "tv_episode".equals(mediaType)) {
            Long currentId = item != null && item.getMediaInfo() != null && item.getMediaInfo().hasVideoMetadata() && item.getMediaInfo().getVideoMetadata().isTvEpisode() ? item.getMediaInfo().getVideoMetadata().getTmdbTvId() : (tvSeries != null && tvSeries.getTvSeriesMetadata() != null ? tvSeries.getTvSeriesMetadata().getTmdbId() : null);
            result = TMDB.getTvShowsFromEpisode(search, year, lang, currentId);
        } else if ("movie".equals(mediaType) && item != null) {
            Long currentId = item.getMediaInfo() != null && item.getMediaInfo().hasVideoMetadata() && !item.getMediaInfo().getVideoMetadata().isTvEpisode() ? item.getMediaInfo().getVideoMetadata().getTmdbId() : null;
            result = TMDB.getMovies(search, year, lang, currentId);
        }
        return result;
    }

    private static boolean setMetadata(WebGuiRenderer renderer, String id, Long tmdbId, String mediaType) throws IOException, InterruptedException {
        MediaLibraryTvSeries mediaLibraryTvSeries;
        MediaLibraryTvSeries tvSeries;
        StoreItem libraryItem;
        LOGGER.debug("Setd metadata " + id);
        StoreResource resource = renderer.getMediaStore().getResource(id);
        StoreItem item = resource instanceof StoreItem ? (libraryItem = (StoreItem)resource) : null;
        MediaLibraryTvSeries mediaLibraryTvSeries2 = tvSeries = resource instanceof MediaLibraryTvSeries ? (mediaLibraryTvSeries = (MediaLibraryTvSeries)resource) : null;
        if (tvSeries == null && item == null || tmdbId == null) {
            LOGGER.debug("Bad metadata id: " + id);
            throw new IOException("Bad Id");
        }
        if (item != null && item.getMediaInfo() != null && item.getMediaInfo().getFileId() != null) {
            if (mediaType.equals("tv_episode")) {
                return TMDB.updateTvShowForEpisode(item.getMediaInfo(), tmdbId);
            }
            if (mediaType.equals("movie")) {
                return TMDB.updateMovieMetadata(item.getMediaInfo(), tmdbId);
            }
        } else if (mediaType.equals("tv") && tvSeries != null && tvSeries.getTvSeriesMetadata() != null && tvSeries.getTvSeriesMetadata().getTvSeriesId() != null) {
            return TMDB.updateTvShowMetadata(tvSeries.getTvSeriesMetadata().getTvSeriesId(), tmdbId);
        }
        return false;
    }

    private static boolean setFullyPlayed(WebGuiRenderer renderer, String id, boolean fullyPlayed) throws IOException, InterruptedException {
        StoreResource resource = renderer.getMediaStore().getResource(id);
        if (resource.isFullyPlayedAware()) {
            resource.setFullyPlayed(fullyPlayed);
            return true;
        }
        return false;
    }

    private static JsonObject getSurroundingByType(StoreItem item, String lang) {
        JsonObject result = new JsonObject();
        List<StoreResource> children = item.getParent().getChildren();
        boolean looping = CONFIGURATION.getWebPlayerAutoLoop(item.getFormat());
        int type = item.getType();
        int size = children.size();
        int mod = looping ? size : 9999;
        int self = children.indexOf(item);
        for (int step = -1; step < 2; step += 2) {
            StoreItem storeItem;
            int i = self;
            int offset = step < 0 && looping ? size : 0;
            StoreResource next = null;
            while (!((i = (offset + i + step) % mod) >= size || i < 0 || i == self || (next = children.get(i)) instanceof StoreItem && (storeItem = (StoreItem)next).getType() == type)) {
                next = null;
            }
            if (next == null || !(next instanceof StoreItem)) continue;
            storeItem = (StoreItem)next;
            JsonObject jMedia = new JsonObject();
            jMedia.addProperty("id", storeItem.getResourceId());
            jMedia.addProperty("name", storeItem.getLocalizedResumeName(lang));
            result.add(step > 0 ? "next" : "prev", jMedia);
        }
        return result;
    }

    private static DLNAThumbnailInputStream getMediaThumbImage(StoreResource resource) {
        DLNAThumbnailInputStream in;
        if (resource == null) {
            return null;
        }
        resource.checkThumbnail();
        try {
            in = resource.fetchThumbnailInputStream();
            if (in == null) {
                in = resource.getGenericThumbnailInputStream(null);
            }
        }
        catch (IOException ex) {
            return null;
        }
        BufferedImageFilterChain filterChain = null;
        if (resource.isFullyPlayedMark()) {
            filterChain = new BufferedImageFilterChain(FullyPlayed.getOverlayFilter());
        }
        if ((filterChain = resource.addFlagFilters(filterChain)) != null) {
            try {
                in = in.transcode(in.getDLNAImageProfile(), false, filterChain);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return in;
    }

    private static WebGuiRenderer getValidRendererOrRespondError(HttpServletRequest req, HttpServletResponse resp, String[] data, int count, int permissions) throws IOException {
        if (data.length >= count) {
            WebGuiRenderer renderer = PlayerApiServlet.getRenderer(req, data[2]);
            if (renderer == null) {
                PlayerApiServlet.respondUnauthorized(req, resp);
            } else if (!renderer.havePermission(permissions)) {
                PlayerApiServlet.respondForbidden(req, resp);
                return null;
            }
            return renderer;
        }
        PlayerApiServlet.respondBadRequest(req, resp);
        return null;
    }

    private static void sendRawMedia(HttpServletRequest req, HttpServletResponse resp, boolean isDownload) throws IOException {
        String path = req.getPathInfo();
        String[] pathData = path.split("/");
        WebGuiRenderer renderer = PlayerApiServlet.getValidRendererOrRespondError(req, resp, pathData, 4, 0x2000000);
        if (renderer == null) {
            return;
        }
        String id = pathData[3];
        try {
            StoreItem storeItem;
            StoreResource resource;
            List<StoreResource> res = renderer.getMediaStore().getResources(id, false);
            StoreResource item = res.size() == 1 ? ((resource = res.get(0)) instanceof StoreItem ? (storeItem = (StoreItem)resource) : null) : null;
            if (item == null) {
                LOGGER.debug("media unknown");
                PlayerApiServlet.respondNotFound(req, resp);
                return;
            }
            long len = item.length();
            ByteRange range = PlayerApiServlet.parseRange(req, len);
            AsyncContext async = req.startAsync();
            InputStream in = ((StoreItem)item).getInputStream(range);
            if (len == 0L) {
                len = item.length();
            }
            String mime = ((StoreItem)item).getMimeType();
            resp.setContentType(mime);
            resp.setHeader("Accept-Ranges", "bytes");
            resp.setHeader("Server", MediaServer.getServerName());
            resp.setHeader("Connection", "keep-alive");
            if (isDownload) {
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + new File(item.getFileName()).getName() + "\"");
            }
            if (in != null) {
                if ((long)in.available() != len) {
                    resp.setHeader("Content-Range", "bytes " + range.getStart() + "-" + in.available() + "/" + len);
                    resp.setStatus(206);
                    resp.setContentLength(in.available());
                } else {
                    resp.setStatus(200);
                    resp.setContentLength(in.available());
                }
                if (LOGGER.isTraceEnabled()) {
                    PlayerApiServlet.logHttpServletResponse(req, resp, null, true);
                }
                BufferedOutputStream os = new BufferedOutputStream(resp.getOutputStream(), 524288);
                LOGGER.debug("start raw dump");
                PlayerApiServlet.copyStreamAsync(in, os, async);
            } else {
                resp.setStatus(500);
                resp.setContentLength(0);
                async.complete();
            }
        }
        catch (IOException ex) {
            PlayerApiServlet.respondInternalServerError(req, resp);
        }
    }

    private static void sendDownloadMedia(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getPathInfo();
        String[] pathData = path.split("/");
        WebGuiRenderer renderer = PlayerApiServlet.getValidRendererOrRespondError(req, resp, pathData, 4, 0x4000000);
        if (renderer == null) {
            return;
        }
        String id = pathData[3];
        try {
            StoreItem storeItem;
            StoreResource resource;
            List<StoreResource> res = renderer.getMediaStore().getResources(id, false);
            StoreResource item = res.size() == 1 ? ((resource = res.get(0)) instanceof StoreItem ? (storeItem = (StoreItem)resource) : null) : null;
            if (item == null) {
                LOGGER.debug("media unknown");
                PlayerApiServlet.respondNotFound(req, resp);
                return;
            }
            File media = new File(item.getFileName());
            String mime = ((StoreItem)item).getMimeType();
            resp.setContentType(mime);
            resp.setHeader("Server", MediaServer.getServerName());
            resp.setHeader("Connection", "keep-alive");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + media.getName() + "\"");
            resp.setStatus(200);
            resp.setContentLengthLong(media.length());
            InputStream in = ((StoreItem)item).getInputStream();
            if (LOGGER.isTraceEnabled()) {
                PlayerApiServlet.logHttpServletResponse(req, resp, null, true);
            }
            AsyncContext async = req.startAsync();
            ServletOutputStream os = resp.getOutputStream();
            PlayerApiServlet.copyStreamAsync(in, os, async);
        }
        catch (IOException ex) {
            PlayerApiServlet.respondInternalServerError(req, resp);
        }
    }

    private static void sendImageMedia(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getPathInfo();
        String[] pathData = path.split("/");
        WebGuiRenderer renderer = PlayerApiServlet.getValidRendererOrRespondError(req, resp, pathData, 4, 0x2000000);
        if (renderer == null) {
            return;
        }
        String id = pathData[3];
        try {
            InputStream in;
            long len;
            String mime;
            StoreItem storeItem;
            StoreResource resource;
            List<StoreResource> res = renderer.getMediaStore().getResources(id, false);
            StoreResource item = res.size() == 1 ? ((resource = res.get(0)) instanceof StoreItem ? (storeItem = (StoreItem)resource) : null) : null;
            if (item == null) {
                LOGGER.debug("media unknown");
                PlayerApiServlet.respondNotFound(req, resp);
                return;
            }
            if (item.getMediaInfo() != null && item.getMediaInfo().isImage() && item.getMediaInfo().getImageInfo() != null) {
                ImageInfo imageInfo = item.getMediaInfo().getImageInfo();
                boolean supported = renderer.isImageFormatSupported(imageInfo.getFormat());
                mime = ((StoreItem)item).getFormat() != null ? ((StoreItem)item).getFormat().mimeType() : ((StoreItem)item).getMimeType();
                long l = len = supported && imageInfo.getSize() != Long.MIN_VALUE ? imageInfo.getSize() : item.length();
                if (supported) {
                    in = ((StoreItem)item).getInputStream();
                } else {
                    ProcessWrapper transcodeProcess;
                    InputStream imageInputStream = ((StoreItem)item).isTranscoded() && ((StoreItem)item).getTranscodingSettings().getEngine() instanceof ImageEngine ? ((transcodeProcess = ((StoreItem)item).getTranscodingSettings().getEngine().launchTranscode((StoreItem)item, item.getMediaInfo(), new OutputParams(PMS.getConfiguration()))) != null ? transcodeProcess.getInputStream(0L) : null) : ((StoreItem)item).getInputStream();
                    Image image = Image.toImage(imageInputStream, 3840, 2400, ImagesUtil.ScaleType.MAX, ImageFormat.JPEG, false);
                    len = image == null ? 0L : (long)image.getBytes(false).length;
                    in = image == null ? null : new ByteArrayInputStream(image.getBytes(false));
                }
            } else {
                PlayerApiServlet.respondUnsupportedMediaType(req, resp);
                return;
            }
            ByteRange range = new ByteRange(0L, len);
            AsyncContext async = req.startAsync();
            resp.setContentType(mime);
            resp.setHeader("Accept-Ranges", "bytes");
            resp.setHeader("Server", MediaServer.getServerName());
            resp.setHeader("Connection", "keep-alive");
            if (in != null) {
                if ((long)in.available() != len) {
                    resp.setHeader("Content-Range", "bytes " + range.getStart() + "-" + in.available() + "/" + len);
                    resp.setStatus(206);
                    resp.setContentLength(in.available());
                } else {
                    resp.setStatus(200);
                    resp.setContentLength(in.available());
                }
                if (LOGGER.isTraceEnabled()) {
                    PlayerApiServlet.logHttpServletResponse(req, resp, null, true);
                }
                BufferedOutputStream os = new BufferedOutputStream(resp.getOutputStream(), 524288);
                PlayerApiServlet.copyStreamAsync(in, os, async);
            } else {
                resp.setStatus(500);
                resp.setContentLength(0);
                async.complete();
            }
        }
        catch (IOException ex) {
            PlayerApiServlet.respondInternalServerError(req, resp);
        }
    }

    private static void sendMedia(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        StoreItem storeItem;
        StoreItem item;
        String path = req.getPathInfo();
        String[] pathData = path.split("/");
        WebGuiRenderer renderer = PlayerApiServlet.getValidRendererOrRespondError(req, resp, pathData, 4, 0x2000000);
        if (renderer == null) {
            return;
        }
        String sessionId = pathData[2];
        String resourceId = pathData[3];
        String uri = req.getRequestURI();
        StoreResource resource = renderer.getMediaStore().getResource(resourceId);
        StoreItem storeItem2 = item = resource instanceof StoreItem ? (storeItem = (StoreItem)resource) : null;
        if (item == null) {
            LOGGER.debug("media unknown");
            PlayerApiServlet.respondNotFound(req, resp);
            return;
        }
        MediaSubtitle sid = null;
        String mimeType = item.getMimeType();
        MediaInfo media = item.getMediaInfo();
        if (media == null) {
            media = new MediaInfo();
            item.setMediaInfo(media);
        }
        if (mimeType.equals("MIMETYPE_AUTO") && media.getMimeType() != null) {
            mimeType = media.getMimeType();
        }
        if (item.getFormat().isVideo() && PMS.getConfiguration().getWebPlayerSubs() && item.getMediaSubtitle() != null && item.getMediaSubtitle().isExternal()) {
            sid = item.getMediaSubtitle();
            item.setMediaSubtitle(null);
        }
        try {
            if (item.getFormat().isVideo() && item.isTranscoded() && item.getTranscodingSettings().getEngine() instanceof FFmpegHlsVideo) {
                resp.setHeader("Server", MediaServer.getServerName());
                if (uri.endsWith("/chapters.vtt")) {
                    String response = HlsHelper.getChaptersWebVtt(item);
                    PlayerApiServlet.respond(req, resp, response, 200, "text/vtt");
                } else if (uri.endsWith("/chapters.json")) {
                    String response = HlsHelper.getChaptersHls(item);
                    PlayerApiServlet.respond(req, resp, response, 200, "application/json");
                } else if (pathData.length > 5 && "hls".equals(pathData[4])) {
                    if (pathData[5].endsWith(".m3u8")) {
                        String rendition = pathData[5];
                        rendition = rendition.replace(".m3u8", "");
                        String response = HlsHelper.getHLSm3u8ForRendition(item, renderer, req.getServletPath() + "/media/" + sessionId + "/", rendition);
                        PlayerApiServlet.respond(req, resp, response, 200, "application/x-mpegURL");
                    } else {
                        AsyncContext async = req.startAsync();
                        InputStream in = HlsHelper.getInputStream(uri, item);
                        if (in != null) {
                            StartStopListener startStopListener = null;
                            resp.setHeader("Connection", "keep-alive");
                            if (uri.endsWith(".ts")) {
                                resp.setContentType("video/MP2T");
                                startStopListener = new StartStopListener(renderer.getUUID(), item);
                            } else if (uri.endsWith(".vtt")) {
                                resp.setContentType("text/vtt");
                            }
                            resp.setHeader("Transfer-Encoding", "chunked");
                            resp.setStatus(200);
                            if (LOGGER.isTraceEnabled()) {
                                PlayerApiServlet.logHttpServletResponse(req, resp, null, true);
                            }
                            BufferedOutputStream os = new BufferedOutputStream(resp.getOutputStream(), 524288);
                            PlayerApiServlet.copyStreamAsync(in, os, async, startStopListener);
                        } else {
                            resp.setStatus(500);
                            resp.setContentLength(0);
                            async.complete();
                        }
                    }
                } else {
                    String response = HlsHelper.getHLSm3u8(item, renderer, req.getServletPath() + "/media/" + sessionId + "/");
                    PlayerApiServlet.respond(req, resp, response, 200, "application/x-mpegURL");
                }
            } else {
                AsyncContext async = req.startAsync();
                ByteRange range = PlayerApiServlet.parseRange(req, item.length());
                LOGGER.debug("Sending {} with mime type {} to {}", item, mimeType, renderer);
                InputStream in = item.getInputStream(range);
                long len = item.length();
                boolean isTranscoding = item.isTranscoded();
                resp.setContentType(mimeType);
                resp.setHeader("Server", MediaServer.getServerName());
                resp.setHeader("Connection", "keep-alive");
                if (in != null) {
                    if (isTranscoding) {
                        resp.setHeader("Transfer-Encoding", "chunked");
                        resp.setStatus(200);
                    } else if ((long)in.available() != len) {
                        range.setEnd(range.getStart() + (long)in.available());
                        if (in.available() == 0) {
                            len = range.getEnd() + 1L;
                        }
                        resp.setHeader("Content-Range", "bytes " + range.getStart() + "-" + range.getEnd() + "/" + len);
                        resp.setContentLength(in.available());
                        resp.setStatus(206);
                    } else {
                        resp.setContentLength(in.available());
                        resp.setStatus(200);
                    }
                    if (LOGGER.isTraceEnabled()) {
                        PlayerApiServlet.logHttpServletResponse(req, resp, null, true);
                    }
                    if (sid != null) {
                        item.setMediaSubtitle(sid);
                    }
                    StartStopListener startStopListener = new StartStopListener(req.getRemoteHost(), item);
                    BufferedOutputStream os = new BufferedOutputStream(resp.getOutputStream(), 8192);
                    PlayerApiServlet.copyStreamAsync(in, os, async, startStopListener);
                } else {
                    resp.setStatus(500);
                    resp.setContentLength(0);
                    async.complete();
                }
            }
        }
        catch (IOException ex) {
            PlayerApiServlet.respondInternalServerError(req, resp);
        }
    }

    private static void sendThumbnail(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getPathInfo();
        String[] pathData = path.split("/");
        WebGuiRenderer renderer = PlayerApiServlet.getValidRendererOrRespondError(req, resp, pathData, 4, 0x2000000);
        if (renderer == null) {
            return;
        }
        StoreResource resource = renderer.getMediaStore().getResource(pathData[3]);
        DLNAThumbnailInputStream thumb = PlayerApiServlet.getMediaThumbImage(resource);
        if (thumb != null) {
            AsyncContext async = req.startAsync();
            resp.setContentType(ImageFormat.PNG.equals((Object)thumb.getFormat()) ? "image/png" : "image/jpeg");
            resp.setHeader("Server", MediaServer.getServerName());
            resp.setHeader("Accept-Ranges", "bytes");
            resp.setHeader("Connection", "keep-alive");
            resp.setStatus(200);
            resp.setContentLengthLong(thumb.getSize());
            ServletOutputStream os = resp.getOutputStream();
            PlayerApiServlet.copyStreamAsync(thumb, os, async);
        } else {
            PlayerApiServlet.respondNotFound(req, resp);
        }
    }

    private static JsonObject getMetadataAsJsonObject(StoreResource resource, Renderer renderer, String lang) {
        JsonObject result = null;
        if (resource instanceof MediaLibraryTvSeries) {
            MediaLibraryTvSeries mediaLibraryTvSeries = (MediaLibraryTvSeries)resource;
            TvSeriesMetadata tvSeriesMetadata = mediaLibraryTvSeries.getTvSeriesMetadata();
            result = tvSeriesMetadata.asJsonObject(lang);
        } else if (resource instanceof MediaLibraryTvSeason) {
            MediaLibraryTvSeason mediaLibraryTvSeason = (MediaLibraryTvSeason)resource;
            TvSeasonMetadata tvSeasonMetadata = mediaLibraryTvSeason.getTvSeasonMetadata();
            if (tvSeasonMetadata != null) {
                result = tvSeasonMetadata.asJsonObject(lang);
            }
        } else if (resource != null && resource.getMediaInfo() != null && resource.getMediaInfo().hasVideoMetadata()) {
            result = resource.getMediaInfo().getVideoMetadata().asJsonObject(lang);
        }
        if (result == null) {
            return null;
        }
        StoreResource actorsFolder = null;
        StoreResource countriesFolder = null;
        StoreResource directorsFolder = null;
        StoreResource genresFolder = null;
        StoreResource ratedFolder = null;
        if (CONFIGURATION.isShowMediaLibraryFolder()) {
            List<StoreResource> rootFolderChildren = renderer.getMediaStore().getResources("0", true);
            StoreResource mediaLibraryFolder = UMSUtils.getFirstResourceWithSystemName(rootFolderChildren, "MediaLibrary");
            if (mediaLibraryFolder == null) {
                return null;
            }
            List<StoreResource> mediaLibraryChildren = renderer.getMediaStore().getResources(mediaLibraryFolder.getId(), true);
            StoreResource videoFolder = UMSUtils.getFirstResourceWithSystemName(mediaLibraryChildren, "Video");
            boolean isRelatedToTV = resource instanceof MediaLibraryTvSeries || resource instanceof MediaLibraryTvEpisode;
            String folderName = isRelatedToTV ? "TvShows" : "Movies";
            List<StoreResource> videoFolderChildren = renderer.getMediaStore().getResources(videoFolder.getId(), true);
            StoreResource tvShowsOrMoviesFolder = UMSUtils.getFirstResourceWithSystemName(videoFolderChildren, folderName);
            List<StoreResource> tvShowsOrMoviesChildren = renderer.getMediaStore().getResources(tvShowsOrMoviesFolder.getId(), true);
            StoreResource filterByInformationFolder = UMSUtils.getFirstResourceWithSystemName(tvShowsOrMoviesChildren, "FilterByInformation");
            if (filterByInformationFolder != null) {
                List<StoreResource> filterByInformationChildren = renderer.getMediaStore().getResources(filterByInformationFolder.getId(), true);
                block14: for (int filterByInformationChildrenIterator = 0; filterByInformationChildrenIterator < filterByInformationChildren.size(); ++filterByInformationChildrenIterator) {
                    StoreResource filterByInformationChild = filterByInformationChildren.get(filterByInformationChildrenIterator);
                    switch (filterByInformationChild.getSystemName()) {
                        case "Actors": {
                            actorsFolder = filterByInformationChild;
                            continue block14;
                        }
                        case "Country": {
                            countriesFolder = filterByInformationChild;
                            continue block14;
                        }
                        case "Director": {
                            directorsFolder = filterByInformationChild;
                            continue block14;
                        }
                        case "Genres": {
                            genresFolder = filterByInformationChild;
                            continue block14;
                        }
                        case "Rated": {
                            ratedFolder = filterByInformationChild;
                            continue block14;
                        }
                    }
                }
            }
        }
        PlayerApiServlet.addJsonArrayStoreIds(result, "actors", actorsFolder, renderer);
        PlayerApiServlet.addJsonArrayStoreIds(result, "countries", countriesFolder, renderer);
        PlayerApiServlet.addJsonArrayStoreIds(result, "directors", directorsFolder, renderer);
        PlayerApiServlet.addJsonArrayStoreIds(result, "genres", genresFolder, renderer);
        PlayerApiServlet.addStringStoreId(result, "rated", ratedFolder, renderer);
        result.addProperty("imageBaseURL", TMDB.getTmdbImageBaseURL());
        return result;
    }

    private static void addJsonArrayStoreIds(JsonObject object, String memberName, StoreResource folder, Renderer renderer) {
        JsonArray array;
        JsonElement element;
        if (object.has(memberName) && (element = object.remove(memberName)).isJsonArray() && !(array = element.getAsJsonArray()).isEmpty()) {
            JsonArray dlnaChilds = new JsonArray();
            for (JsonElement child : array) {
                if (!child.isJsonPrimitive()) continue;
                String value = child.getAsString();
                JsonObject dlnaChild = new JsonObject();
                dlnaChild.addProperty("name", value);
                if (folder != null) {
                    List<StoreResource> folderChildren = renderer.getMediaStore().getResources(folder.getId(), true);
                    UMSUtils.filterResourcesByName(folderChildren, value, true, true);
                    if (!folderChildren.isEmpty()) {
                        dlnaChild.addProperty("id", folderChildren.get(0).getId());
                    }
                }
                dlnaChilds.add(dlnaChild);
            }
            object.add(memberName, dlnaChilds);
        }
    }

    private static void addStringStoreId(JsonObject object, String memberName, StoreResource folder, Renderer renderer) {
        JsonElement element;
        if (object.has(memberName) && (element = object.remove(memberName)).isJsonPrimitive()) {
            String value = element.getAsString();
            JsonObject dlnaChild = new JsonObject();
            dlnaChild.addProperty("name", value);
            if (folder != null) {
                List<StoreResource> folderChildren = renderer.getMediaStore().getResources(folder.getId(), true);
                UMSUtils.filterResourcesByName(folderChildren, value, true, true);
                if (!folderChildren.isEmpty()) {
                    dlnaChild.addProperty("id", folderChildren.get(0).getId());
                }
            }
            object.add(memberName, dlnaChild);
        }
    }

    private static Long getLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static ByteRange parseRange(HttpServletRequest req, long len) {
        String range = req.getHeader("Range");
        if (range == null || "".equals(range)) {
            return new ByteRange(0L, len);
        }
        String[] tmp = range.split("=")[1].split("-");
        long start = Long.parseLong(tmp[0]);
        long end = tmp.length == 1 ? len : Long.parseLong(tmp[1]);
        return new ByteRange(start, end);
    }

    private static boolean directmime(String mime) {
        return mime != null && (mime.equals("video/mp4") || mime.equals("video/webm") || mime.equals("video/ogg") || mime.equals("audio/mp4") || mime.equals("audio/mpeg") || mime.equals("audio/ogg") || mime.equals("audio/wav") || mime.equals("image/bmp") || mime.equals("image/png") || mime.equals("image/jpeg") || mime.equals("image/gif"));
    }
}

