/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver;

import jakarta.websocket.Session;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import net.pms.iam.Account;
import net.pms.iam.AuthService;
import net.pms.network.webguiserver.WebSocketDispatcher;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.devices.WebGuiRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketDispatcher.class);
    private final Session session;
    private final String remoteAddress;
    private final boolean isLocalhost;
    private String subscribe;
    private Account account;
    private String playerUuid;
    private WebGuiRenderer renderer;

    public WebSocketSession(Session session) {
        this.session = session;
        if (session.getUserProperties().containsKey("jakarta.websocket.endpoint.remoteAddress")) {
            InetSocketAddress address = (InetSocketAddress)session.getUserProperties().get("jakarta.websocket.endpoint.remoteAddress");
            this.remoteAddress = address.getHostString();
            this.isLocalhost = address.getAddress().isAnyLocalAddress() || address.getAddress().isLoopbackAddress();
        } else {
            this.remoteAddress = "";
            this.isLocalhost = false;
        }
    }

    public String getId() {
        return this.session.getId();
    }

    public boolean isUserId(int id) {
        return this.account != null && this.account.getUser().getId() == id;
    }

    public boolean havePermission(int permission) {
        return this.account != null && this.account.havePermission(permission);
    }

    public void sendText(String text) throws IOException {
        this.session.getBasicRemote().sendText(text);
    }

    public void sendMessage(String message) {
        try {
            this.sendText(message);
        }
        catch (IOException e) {
            LOGGER.debug("Error sending message to '{}' with message : {}", (Object)this.session.getId(), (Object)message);
            LOGGER.trace("", e);
        }
    }

    public void setSubscribe(String subscribe) {
        this.subscribe = subscribe;
        if (this.getWebGuiRenderer() != null) {
            this.renderer.updateWebSocketPlayer();
        }
    }

    public void setToken(String token) {
        this.account = AuthService.getAccountLoggedIn(token, this.remoteAddress, this.isLocalhost);
    }

    public void setPlayerUuid(String uuid) {
        if (this.playerUuid != null && !this.playerUuid.equals(uuid) && this.renderer != null) {
            this.renderer.setWebSocketSession(null);
            this.renderer = null;
        }
        this.playerUuid = uuid;
        this.getWebGuiRenderer();
    }

    private WebGuiRenderer getWebGuiRenderer() {
        if (this.renderer != null) {
            return this.renderer;
        }
        if (this.playerUuid == null) {
            return null;
        }
        if (ConnectedRenderers.hasWebPlayerRenderer(this.playerUuid)) {
            this.renderer = ConnectedRenderers.getWebPlayerRenderer(this.playerUuid);
            this.renderer.setWebSocketSession(this);
            this.renderer.updateWebSocketPlayer();
        }
        return this.renderer;
    }

    public void setPlayerStatus(Map<String, String> status) {
        if (this.getWebGuiRenderer() != null) {
            this.renderer.setPlayerStatus(status);
        }
    }

    public boolean isOpen() {
        return this.session.isOpen();
    }

    public boolean isPlayerOpen() {
        return this.isOpen() && "Player".equals(this.subscribe);
    }
}

