/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.mdns.chromecast;

import ch.qos.logback.classic.Level;
import java.io.IOException;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import net.pms.PMS;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.RendererConfigurations;
import net.pms.network.NetworkDeviceFilter;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.devices.ChromecastDevice;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.litvak.chromecast.api.v2.ChromeCast;

public class ChromecastServiceListener
implements ServiceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromecastServiceListener.class);
    private final RendererConfiguration rendererConf = RendererConfigurations.getRendererConfigurationByName("Chromecast");
    private ArrayList<ChromecastDevice> chromeCasts = new ArrayList();

    public ChromecastServiceListener() throws IOException {
        if (!PMS.getConfiguration().isChromecastDbg()) {
            ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("su.litvak.chromecast.api.v2");
            logger.setLevel(Level.OFF);
        }
    }

    @Override
    public void serviceAdded(ServiceEvent event) {
        if (event.getInfo() == null) {
            LOGGER.debug("Bad Chromcast event: {}", (Object)event.toString());
            return;
        }
        LOGGER.debug("Found chromecast: {}", (Object)event.getInfo().getName());
        ServiceInfo serviceInfo = event.getDNS().getServiceInfo("_googlecast._tcp.local.", event.getInfo().getName());
        InetAddress ia = ChromecastServiceListener.getAllowedInetAddress(serviceInfo.getInet4Addresses());
        if (ia == null) {
            return;
        }
        ChromeCast chromeCast = new ChromeCast(ia.getHostAddress(), serviceInfo.getPort());
        chromeCast.setName(event.getInfo().getName());
        chromeCast.setAppsURL(serviceInfo.getURLs().length == 0 ? null : serviceInfo.getURLs()[0]);
        chromeCast.setApplication(serviceInfo.getApplication());
        try {
            chromeCast.connect();
            ChromecastDevice chromecastDevice = new ChromecastDevice(chromeCast, this.rendererConf, InetAddress.getByName(chromeCast.getAddress()));
            PMS.get().setRendererFound(chromecastDevice);
            this.chromeCasts.add(chromecastDevice);
        }
        catch (IOException | GeneralSecurityException | ConfigurationException e) {
            LOGGER.error("Chromecast registration failed with the following error: {}", e);
            LOGGER.trace("", e);
        }
        catch (InterruptedException e) {
            LOGGER.info("Chromecast registration was interrupted");
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void serviceRemoved(ServiceEvent event) {
        if (event.getInfo() == null) {
            return;
        }
        String name = event.getInfo().getName();
        if (StringUtils.isEmpty(name)) {
            name = this.rendererConf.getConfName();
        }
        ArrayList<ChromecastDevice> devices = new ArrayList<ChromecastDevice>();
        for (ChromecastDevice device : this.chromeCasts) {
            if (name.equals(device.getRendererName())) {
                ConnectedRenderers.delete(device, 5000L);
                LOGGER.debug("Chromecast \"{}\" is gone.", (Object)name);
                continue;
            }
            devices.add(device);
        }
        this.chromeCasts = devices;
    }

    @Override
    public void serviceResolved(ServiceEvent event) {
    }

    public static void addService(JmDNS mDNS) throws IOException {
        mDNS.addServiceListener("_googlecast._tcp.local.", new ChromecastServiceListener());
    }

    private static InetAddress getAllowedInetAddress(InetAddress[] addresses) {
        for (InetAddress ia : addresses) {
            if (!NetworkDeviceFilter.isAllowed(ia)) continue;
            return ia;
        }
        return null;
    }
}

