/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.transport.impl.jetty;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.pms.network.mediaserver.jupnp.transport.impl.StreamsLoggerHelper;
import org.eclipse.jetty.client.BytesRequestContent;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.StringRequestContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.jupnp.http.Headers;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpOperation;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.spi.AbstractStreamClient;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyStreamClientImpl
extends AbstractStreamClient<StreamClientConfigurationImpl, Request> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyStreamClientImpl.class);
    protected final StreamClientConfigurationImpl configuration;
    protected final HttpClient httpClient;

    public JettyStreamClientImpl(StreamClientConfigurationImpl configuration) throws InitializationException {
        this.configuration = configuration;
        this.httpClient = new HttpClient();
        this.httpClient.setConnectTimeout(configuration.getTimeoutSeconds() * 1000);
        this.httpClient.setMaxConnectionsPerDestination(2);
        int cpus = Runtime.getRuntime().availableProcessors();
        int maxThreads = 5 * cpus;
        QueuedThreadPool queuedThreadPool = this.createThreadPool("jupnp-stream-client", 5, maxThreads, 60000);
        this.httpClient.setExecutor(queuedThreadPool);
        if (configuration.getSocketBufferSize() != -1) {
            this.httpClient.setRequestBufferSize(configuration.getSocketBufferSize());
            this.httpClient.setResponseBufferSize(configuration.getSocketBufferSize());
        }
        try {
            LOGGER.info("Starting Jetty HTTP client v{} connection manager/pool", (Object)Jetty.VERSION);
            this.httpClient.start();
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate HTTP client", e);
            throw new InitializationException("Failed to instantiate HTTP client", e);
        }
    }

    @Override
    public StreamClientConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    protected Request createRequest(StreamRequestMessage requestMessage) {
        Request request;
        UpnpRequest upnpRequest = (UpnpRequest)requestMessage.getOperation();
        LOGGER.trace("Creating HTTP request. URI: '{}' method: '{}'", (Object)upnpRequest.getURI(), (Object)upnpRequest.getMethod());
        switch (upnpRequest.getMethod()) {
            case GET: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                try {
                    request = this.httpClient.newRequest(upnpRequest.getURI()).method(upnpRequest.getHttpMethodName());
                    break;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.debug("Cannot create request because URI '{}' is invalid", (Object)upnpRequest.getURI(), (Object)e);
                    return null;
                }
            }
            case POST: 
            case NOTIFY: {
                try {
                    request = this.httpClient.newRequest(upnpRequest.getURI()).method(upnpRequest.getHttpMethodName());
                    request.body(this.createContentProvider(requestMessage));
                    break;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.debug("Cannot create request because URI '{}' is invalid", (Object)upnpRequest.getURI(), (Object)e);
                    return null;
                }
            }
            default: {
                throw new RuntimeException("Unknown HTTP method: " + upnpRequest.getHttpMethodName());
            }
        }
        if (((UpnpRequest)requestMessage.getOperation()).getHttpMinorVersion() == 0) {
            request.version(HttpVersion.HTTP_1_0);
        } else {
            request.version(HttpVersion.HTTP_1_1);
            JettyStreamClientImpl.addHeader(request, HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
        }
        if (!requestMessage.getHeaders().containsKey(UpnpHeader.Type.USER_AGENT)) {
            request.agent(this.getConfiguration().getUserAgentValue(requestMessage.getUdaMajorVersion(), requestMessage.getUdaMinorVersion()));
        }
        JettyStreamClientImpl.addHeaders(request, requestMessage.getHeaders());
        return request;
    }

    @Override
    protected Callable<StreamResponseMessage> createCallable(StreamRequestMessage requestMessage, Request request) {
        return () -> {
            LOGGER.trace("Sending HTTP request: {}", (Object)requestMessage);
            if (LOGGER.isTraceEnabled()) {
                StreamsLoggerHelper.logStreamClientRequestMessage(requestMessage);
            }
            try {
                ContentResponse httpResponse = request.send();
                LOGGER.trace("Received HTTP response: {}", (Object)httpResponse.getReason());
                UpnpResponse responseOperation = new UpnpResponse(httpResponse.getStatus(), httpResponse.getReason());
                StreamResponseMessage responseMessage = new StreamResponseMessage(responseOperation);
                responseMessage.setHeaders(new UpnpHeaders(JettyStreamClientImpl.getHeaders(httpResponse)));
                byte[] bytes = httpResponse.getContent();
                if (bytes == null || 0 == bytes.length) {
                    LOGGER.trace("HTTP response message has no entity");
                    if (LOGGER.isTraceEnabled()) {
                        StreamsLoggerHelper.logStreamClientResponseMessage(responseMessage, requestMessage);
                    }
                    return responseMessage;
                }
                if (responseMessage.isContentTypeMissingOrText()) {
                    LOGGER.trace("HTTP response message contains text entity");
                } else {
                    LOGGER.trace("HTTP response message contains binary entity");
                }
                responseMessage.setBodyCharacters(bytes);
                if (LOGGER.isTraceEnabled()) {
                    StreamsLoggerHelper.logStreamClientResponseMessage(responseMessage, requestMessage);
                }
                return responseMessage;
            }
            catch (RuntimeException e) {
                LOGGER.error("Request: {} failed", (Object)request, (Object)e);
                throw e;
            }
        };
    }

    @Override
    protected void abort(Request request) {
        request.abort(new Exception("Request aborted by API"));
    }

    @Override
    protected boolean logExecutionException(Throwable t) {
        if (t instanceof IllegalStateException) {
            LOGGER.trace("Illegal state: {}", (Object)t.getMessage());
            return true;
        }
        if (t != null && t.getMessage().contains("HTTP protocol violation")) {
            SpecificationViolationReporter.report(t.getMessage(), new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        LOGGER.trace("Shutting down HTTP client connection manager/pool");
        try {
            this.httpClient.stop();
        }
        catch (Exception e) {
            LOGGER.info("Shutting down of HTTP client throwed exception", e);
        }
    }

    protected <O extends UpnpOperation> Request.Content createContentProvider(UpnpMessage<O> upnpMessage) {
        if (upnpMessage.getBodyType().equals((Object)UpnpMessage.BodyType.STRING)) {
            LOGGER.trace("Preparing HTTP request entity as String");
            return new StringRequestContent(upnpMessage.getBodyString(), upnpMessage.getContentTypeCharset());
        }
        LOGGER.trace("Preparing HTTP request entity as byte[]");
        return new BytesRequestContent(new byte[][]{upnpMessage.getBodyBytes()});
    }

    private QueuedThreadPool createThreadPool(String consumerName, int minThreads, int maxThreads, int keepAliveTimeout) {
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool(maxThreads, minThreads, keepAliveTimeout);
        queuedThreadPool.setName(consumerName);
        queuedThreadPool.setDaemon(true);
        return queuedThreadPool;
    }

    public static void addHeaders(Request request, Headers headers) {
        HttpFields httpFields = request.getHeaders();
        if (httpFields instanceof HttpFields.Mutable) {
            HttpFields.Mutable httpHeaders = (HttpFields.Mutable)httpFields;
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String value : entry.getValue()) {
                    httpHeaders.add(entry.getKey(), value);
                }
            }
        }
    }

    public static void addHeader(Request request, HttpHeader header, String value) {
        HttpFields httpFields = request.getHeaders();
        if (httpFields instanceof HttpFields.Mutable) {
            HttpFields.Mutable httpHeaders = (HttpFields.Mutable)httpFields;
            httpHeaders.add(header, value);
        }
    }

    public static Headers getHeaders(Response response) {
        Headers headers = new Headers();
        for (HttpField httpField : response.getHeaders()) {
            headers.add(httpField.getName(), httpField.getValue());
        }
        return headers;
    }
}

