/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.transport.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import net.pms.network.NetworkDeviceFilter;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.transport.impl.MulticastReceiverConfigurationImpl;
import org.jupnp.transport.impl.MulticastReceiverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmsMulticastReceiver
extends MulticastReceiverImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastReceiverImpl.class);

    public UmsMulticastReceiver(MulticastReceiverConfigurationImpl configuration) {
        super(configuration);
    }

    @Override
    public void run() {
        LOGGER.debug("Entering blocking receiving loop, listening for UDP datagrams on: " + String.valueOf(this.socket.getLocalAddress()));
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[this.getConfiguration().getMaxDatagramBytes()];
                    DatagramPacket datagram = new DatagramPacket(buf, buf.length);
                    this.socket.receive(datagram);
                    if (!NetworkDeviceFilter.isAllowed(datagram.getAddress())) {
                        LOGGER.trace("Ip Filtering denying address: {}", (Object)datagram.getAddress().getHostAddress());
                        continue;
                    }
                    InetAddress receivedOnLocalAddress = this.networkAddressFactory.getLocalAddress(this.multicastInterface, this.multicastAddress.getAddress() instanceof Inet6Address, datagram.getAddress());
                    LOGGER.debug("UDP datagram received from: " + datagram.getAddress().getHostAddress() + ":" + datagram.getPort() + " on local interface: " + this.multicastInterface.getDisplayName() + " and address: " + receivedOnLocalAddress.getHostAddress());
                    this.router.received(this.datagramProcessor.read(receivedOnLocalAddress, datagram));
                }
            }
            catch (SocketException ex) {
                LOGGER.debug("Socket closed");
            }
            catch (UnsupportedDataException ex) {
                LOGGER.info("Could not read datagram: " + ex.getMessage());
                continue;
            }
            catch (IOException | IllegalStateException ex) {
                throw new RuntimeException(ex);
            }
            break;
        }
        try {
            if (!this.socket.isClosed()) {
                LOGGER.debug("Closing multicast socket");
                this.socket.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

